/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodUtils {
    private MethodUtils() {
    }

    @Contract(value="null -> false")
    public static boolean isComparatorCompare(@Nullable PsiMethod method) {
        return method != null && MethodUtils.methodMatches(method, "java.util.Comparator", (PsiType)PsiType.INT, "compare", null, null);
    }

    @Contract(value="null -> false")
    public static boolean isCompareTo(@Nullable PsiMethod method) {
        return method != null && MethodUtils.methodMatches(method, null, (PsiType)PsiType.INT, "compareTo", new PsiType[]{PsiType.NULL}) && InheritanceUtil.isInheritor((PsiClass)method.getContainingClass(), (String)"java.lang.Comparable");
    }

    @Contract(value="null -> false")
    public static boolean isCompareToIgnoreCase(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClassType stringType = TypeUtils.getStringType((PsiElement)method);
        return MethodUtils.methodMatches(method, "java.lang.String", (PsiType)PsiType.INT, "compareToIgnoreCase", new PsiType[]{stringType});
    }

    @Contract(value="null -> false")
    public static boolean isHashCode(@Nullable PsiMethod method) {
        return method != null && MethodUtils.methodMatches(method, null, (PsiType)PsiType.INT, "hashCode", new PsiType[0]);
    }

    @Contract(value="null -> false")
    public static boolean isFinalize(@Nullable PsiMethod method) {
        return method != null && MethodUtils.methodMatches(method, null, (PsiType)PsiType.VOID, "finalize", new PsiType[0]);
    }

    @Contract(value="null -> false")
    public static boolean isToString(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClassType stringType = TypeUtils.getStringType((PsiElement)method);
        return MethodUtils.methodMatches(method, null, (PsiType)stringType, "toString", new PsiType[0]);
    }

    @Contract(value="null -> false")
    public static boolean isEquals(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClassType objectType = TypeUtils.getObjectType((PsiElement)method);
        return MethodUtils.methodMatches(method, null, (PsiType)PsiType.BOOLEAN, "equals", new PsiType[]{objectType});
    }

    @Contract(value="null -> false")
    public static boolean isEqualsIgnoreCase(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClassType stringType = TypeUtils.getStringType((PsiElement)method);
        return MethodUtils.methodMatches(method, "java.lang.String", (PsiType)PsiType.BOOLEAN, "equalsIgnoreCase", new PsiType[]{stringType});
    }

    public static boolean methodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @Nullable PsiType returnType, @Nullable Pattern methodNamePattern, PsiType ... parameterTypes) {
        String name2;
        Matcher matcher;
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(0);
        }
        if (methodNamePattern != null && !(matcher = methodNamePattern.matcher(name2 = method.getName())).matches()) {
            return false;
        }
        return MethodUtils.methodMatches(method, containingClassName, returnType, parameterTypes);
    }

    public static boolean methodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, PsiType ... parameterTypes) {
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(1);
        }
        String name2 = method.getName();
        if (methodName != null && !methodName.equals(name2)) {
            return false;
        }
        return MethodUtils.methodMatches(method, containingClassName, returnType, parameterTypes);
    }

    private static boolean methodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @Nullable PsiType returnType, PsiType ... parameterTypes) {
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(2);
        }
        if (parameterTypes != null) {
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != parameterTypes.length) {
                return false;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            for (int i = 0; i < parameters2.length; ++i) {
                ProgressManager.checkCanceled();
                PsiParameter parameter2 = parameters2[i];
                PsiType type2 = parameter2.getType();
                PsiType parameterType = parameterTypes[i];
                if (PsiType.NULL.equals((Object)parameterType) || parameterType == null || EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(type2, parameterType)) continue;
                return false;
            }
        }
        if (returnType != null) {
            PsiType methodReturnType = method.getReturnType();
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(returnType, methodReturnType)) {
                return false;
            }
        }
        if (containingClassName != null) {
            PsiClass containingClass = method.getContainingClass();
            return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)containingClassName);
        }
        return true;
    }

    public static boolean simpleMethodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @NonNls @Nullable String returnTypeString, @NonNls @Nullable String methodName, String ... parameterTypeStrings) {
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(3);
        }
        Project project2 = method.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiElementFactory factory = psiFacade.getElementFactory();
        try {
            if (parameterTypeStrings != null) {
                PsiType[] parameterTypes = PsiType.createArray((int)parameterTypeStrings.length);
                for (int i = 0; i < parameterTypeStrings.length; ++i) {
                    ProgressManager.checkCanceled();
                    String parameterTypeString = parameterTypeStrings[i];
                    parameterTypes[i] = factory.createTypeFromText(parameterTypeString, (PsiElement)method);
                }
                if (returnTypeString != null) {
                    PsiType returnType = factory.createTypeFromText(returnTypeString, (PsiElement)method);
                    return MethodUtils.methodMatches(method, containingClassName, returnType, methodName, parameterTypes);
                }
                return MethodUtils.methodMatches(method, containingClassName, null, methodName, parameterTypes);
            }
            if (returnTypeString != null) {
                PsiType returnType = factory.createTypeFromText(returnTypeString, (PsiElement)method);
                return MethodUtils.methodMatches(method, containingClassName, returnType, methodName, new PsiType[0]);
            }
            return MethodUtils.methodMatches(method, containingClassName, null, methodName, new PsiType[0]);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasSuper(@NotNull PsiMethod method) {
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(4);
        }
        return MethodUtils.getSuper(method) != null;
    }

    @Nullable
    public static PsiMethod getSuper(@NotNull PsiMethod method) {
        MethodSignatureBackedByPsiMethod signature;
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(5);
        }
        if ((signature = MethodUtils.getSuperMethodSignature(method)) == null) {
            return null;
        }
        return signature.getMethod();
    }

    @Nullable
    public static MethodSignatureBackedByPsiMethod getSuperMethodSignature(@NotNull PsiMethod method) {
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(6);
        }
        if (method.isConstructor() || method.hasModifierProperty("static") || method.hasModifierProperty("private")) {
            return null;
        }
        return (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
    }

    public static boolean isOverridden(@NotNull PsiMethod method) {
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(7);
        }
        return OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null;
    }

    public static boolean isOverriddenInHierarchy(@NotNull PsiMethod method, @NotNull PsiClass baseClass) {
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(8);
        }
        if (baseClass == null) {
            MethodUtils.$$$reportNull$$$0(9);
        }
        if (!PsiUtil.canBeOverridden((PsiMethod)method) || baseClass instanceof PsiAnonymousClass || baseClass.hasModifierProperty("final")) {
            return false;
        }
        Query search2 = ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)baseClass.getUseScope(), (boolean)true, (boolean)true, (boolean)true);
        for (PsiClass inheritor : search2) {
            PsiMethod overridingMethod = inheritor.findMethodBySignature(method, false);
            if (overridingMethod == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(PsiMethod method) {
        return ControlFlowUtils.isEmptyCodeBlock(method.getBody());
    }

    public static boolean isTrivial(PsiMethod method, boolean throwIsTrivial) {
        if (method.hasModifierProperty("native")) {
            return false;
        }
        return MethodUtils.isTrivial(method.getBody(), throwIsTrivial);
    }

    public static boolean isTrivial(PsiClassInitializer initializer) {
        return MethodUtils.isTrivial(initializer.getBody(), false);
    }

    private static boolean isTrivial(PsiCodeBlock codeBlock, boolean throwIsTrivial) {
        if (codeBlock == null) {
            return true;
        }
        PsiStatement[] statements = codeBlock.getStatements();
        if (statements.length == 0) {
            return true;
        }
        for (PsiStatement statement2 : statements) {
            ProgressManager.checkCanceled();
            if (statement2 instanceof PsiEmptyStatement) continue;
            if (statement2 instanceof PsiReturnStatement) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
                PsiExpression returnValue = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
                if (returnValue != null && !(returnValue instanceof PsiLiteralExpression)) continue;
                return true;
            }
            if (statement2 instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement2;
                PsiExpression condition2 = ifStatement.getCondition();
                Object result2 = ExpressionUtils.computeConstantExpression(condition2);
                if (result2 != null && result2.equals(Boolean.FALSE)) continue;
                return false;
            }
            if (statement2 instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
                PsiExpression expression2 = expressionStatement.getExpression();
                if (!(expression2 instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                if ("super".equals(methodExpression.getText())) continue;
                return false;
            }
            return throwIsTrivial && statement2 instanceof PsiThrowStatement;
        }
        return true;
    }

    public static boolean hasInThrows(@NotNull PsiMethod method, String ... exceptions) {
        PsiJavaCodeReferenceElement[] references;
        if (method == null) {
            MethodUtils.$$$reportNull$$$0(10);
        }
        if (exceptions == null) {
            MethodUtils.$$$reportNull$$$0(11);
        }
        if (exceptions.length == 0) {
            throw new IllegalArgumentException("no exceptions specified");
        }
        PsiReferenceList throwsList = method.getThrowsList();
        for (PsiJavaCodeReferenceElement reference : references = throwsList.getReferenceElements()) {
            ProgressManager.checkCanceled();
            PsiElement target2 = reference.resolve();
            if (!(target2 instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)target2;
            String qualifiedName = aClass.getQualifiedName();
            for (String exception : exceptions) {
                if (!exception.equals(qualifiedName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isChainable(PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)method.getContainingClass(), (PsiClass)PsiUtil.resolveClassInClassTypeOnly((PsiType)method.getReturnType()), (boolean)true)) {
            return false;
        }
        PsiElement navigationElement = method.getNavigationElement();
        if (!(navigationElement instanceof PsiMethod)) {
            return false;
        }
        method = (PsiMethod)navigationElement;
        PsiStatement lastStatement = ControlFlowUtils.getLastStatementInBlock(method.getBody());
        if (!(lastStatement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)lastStatement;
        PsiExpression returnValue = returnStatement.getReturnValue();
        return returnValue instanceof PsiThisExpression;
    }

    @Contract(value="null -> false")
    public static boolean isStringLength(@Nullable PsiMethod method) {
        if (method == null || !method.getName().equals("length") || method.getParameterList().getParametersCount() != 0) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return aClass != null && "java.lang.String".equals(aClass.getQualifiedName());
    }

    public static boolean haveEquivalentModifierLists(PsiMethod method, PsiMethod superMethod) {
        PsiModifierList list1 = method.getModifierList();
        PsiModifierList list2 = superMethod.getModifierList();
        if (list1.hasModifierProperty("strictfp") != list2.hasModifierProperty("strictfp") || list1.hasModifierProperty("synchronized") != list2.hasModifierProperty("synchronized") || list1.hasModifierProperty("public") != list2.hasModifierProperty("public") || list1.hasModifierProperty("protected") != list2.hasModifierProperty("protected") || list1.hasModifierProperty("final") != list2.hasModifierProperty("final") || list1.hasModifierProperty("abstract") != list2.hasModifierProperty("abstract")) {
            return false;
        }
        return AnnotationUtil.equal((PsiAnnotation[])list1.getAnnotations(), (PsiAnnotation[])list2.getAnnotations());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/MethodUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "methodMatches";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "simpleMethodMatches";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSuper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuperMethodSignature";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isOverridden";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isOverriddenInHierarchy";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "hasInThrows";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

