/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestUtils {
    public static final String RUN_WITH = "org.junit.runner.RunWith";

    private TestUtils() {
    }

    public static boolean isInTestSourceContent(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile file2 = element.getContainingFile();
        VirtualFile virtualFile = file2 == null ? null : file2.getVirtualFile();
        return virtualFile != null && ProjectRootManager.getInstance((Project)file2.getProject()).getFileIndex().isInTestSourceContent(virtualFile);
    }

    public static boolean isPartOfJUnitTestMethod(@NotNull PsiElement element) {
        PsiMethod method;
        if (element == null) {
            TestUtils.$$$reportNull$$$0(0);
        }
        return (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false)) != null && TestUtils.isJUnitTestMethod(method);
    }

    public static boolean isJUnit4BeforeOrAfterMethod(@NotNull PsiMethod method) {
        if (method == null) {
            TestUtils.$$$reportNull$$$0(1);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.Before", (boolean)true) || AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.After", (boolean)true);
    }

    public static boolean isJUnit4BeforeClassOrAfterClassMethod(@NotNull PsiMethod method) {
        if (method == null) {
            TestUtils.$$$reportNull$$$0(2);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.BeforeClass", (boolean)true) || AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.AfterClass", (boolean)true);
    }

    public static boolean isJUnitTestMethod(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        Set frameworks = TestFrameworks.detectApplicableFrameworks((PsiClass)containingClass);
        return frameworks.stream().anyMatch(framework -> framework.getName().startsWith("JUnit") && framework.isTestMethod((PsiElement)method, false));
    }

    public static boolean isRunnable(PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (method.hasModifierProperty("abstract") || method.hasModifierProperty("static") || !method.hasModifierProperty("public")) {
            return false;
        }
        PsiType returnType = method.getReturnType();
        if (!PsiType.VOID.equals((Object)returnType)) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        return parameterList.getParametersCount() == 0;
    }

    public static boolean isJUnit3TestMethod(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        String methodName = method.getName();
        String test = "test";
        if (!methodName.startsWith("test") || !method.hasModifierProperty("public") && method.getParameterList().getParametersCount() > 0) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        return TestUtils.isJUnitTestClass(containingClass);
    }

    public static boolean isJUnit4TestMethod(@Nullable PsiMethod method) {
        return method != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.Test", (boolean)true);
    }

    public static boolean isAnnotatedTestMethod(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)containingClass);
        if (testFramework == null) {
            return false;
        }
        if (testFramework.isTestMethod((PsiElement)method, false)) {
            String testFrameworkName = testFramework.getName();
            return testFrameworkName.equals("JUnit4") || testFrameworkName.equals("JUnit5");
        }
        return false;
    }

    public static boolean isJUnitTestClass(@Nullable PsiClass targetClass) {
        return targetClass != null && InheritanceUtil.isInheritor((PsiClass)targetClass, (String)"junit.framework.TestCase");
    }

    public static boolean isJUnit4TestClass(@Nullable PsiClass aClass, boolean runWithIsTestClass) {
        if (aClass == null) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)RUN_WITH, (boolean)true)) {
            return runWithIsTestClass;
        }
        for (PsiMethod method : aClass.getAllMethods()) {
            if (!TestUtils.isJUnit4TestMethod(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInTestCode(PsiElement element) {
        if (TestUtils.isPartOfJUnitTestMethod(element)) {
            return true;
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (containingClass != null && TestFrameworks.getInstance().isTestOrConfig(containingClass)) {
            return true;
        }
        return TestUtils.isInTestSourceContent(element);
    }

    public static boolean testInstancePerClass(@NotNull PsiClass containingClass) {
        PsiAnnotationMemberValue value2;
        PsiAnnotation annotation;
        if (containingClass == null) {
            TestUtils.$$$reportNull$$$0(3);
        }
        return (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)containingClass, (String[])new String[]{"org.junit.jupiter.api.TestInstance"})) != null && (value2 = annotation.findDeclaredAttributeValue("value")) != null && value2.getText().contains("PER_CLASS");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/TestUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isPartOfJUnitTestMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isJUnit4BeforeOrAfterMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isJUnit4BeforeClassOrAfterClassMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "testInstancePerClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

