/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaParameterTypeCanBeSpecifiedInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.name", new Object[0]);
        if (string == null) {
            LambdaParameterTypeCanBeSpecifiedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.descriptor", infos);
        if (string == null) {
            LambdaParameterTypeCanBeSpecifiedInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InferLambdaParameterTypeVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new InferLambdaParameterTypeFix(infos);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/LambdaParameterTypeCanBeSpecifiedInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class InferLambdaParameterTypeFix
    extends InspectionGadgetsFix {
        private final Object[] myInfos;

        public InferLambdaParameterTypeFix(Object ... infos) {
            this.myInfos = infos;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.quickfix", this.myInfos);
            if (string == null) {
                InferLambdaParameterTypeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.family.quickfix", new Object[0]);
            if (string == null) {
                InferLambdaParameterTypeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            if (element instanceof PsiLambdaExpression) {
                LambdaRefactoringUtil.specifyLambdaParameterTypes((PsiLambdaExpression)element);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/style/LambdaParameterTypeCanBeSpecifiedInspection$InferLambdaParameterTypeFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class InferLambdaParameterTypeVisitor
    extends BaseInspectionVisitor {
        private InferLambdaParameterTypeVisitor() {
        }

        public void visitLambdaExpression(PsiLambdaExpression lambdaExpression) {
            String inferredTypesText;
            super.visitLambdaExpression(lambdaExpression);
            PsiParameter[] parameters2 = lambdaExpression.getParameterList().getParameters();
            if (parameters2.length == 0) {
                return;
            }
            for (PsiParameter parameter2 : parameters2) {
                if (parameter2.getTypeElement() == null) continue;
                return;
            }
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            if (functionalInterfaceType != null && LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType) != null && (inferredTypesText = LambdaRefactoringUtil.createLambdaParameterListWithFormalTypes(functionalInterfaceType, lambdaExpression, true)) != null) {
                this.registerError((PsiElement)lambdaExpression, inferredTypesText);
            }
        }
    }
}

