/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RemoveModifierFix;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryFinalOnLocalVariableOrParameterInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean onlyWarnOnAbstractMethods = false;
    public boolean reportLocalVariables = true;
    public boolean reportParameters = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.final.on.local.variable.or.parameter.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryFinalOnLocalVariableOrParameterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiVariable variable = (PsiVariable)infos[0];
        String variableName = variable.getName();
        if (variable instanceof PsiParameter) {
            String string = InspectionGadgetsBundle.message("unnecessary.final.on.parameter.problem.descriptor", variableName);
            if (string == null) {
                UnnecessaryFinalOnLocalVariableOrParameterInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unnecessary.final.on.local.variable.problem.descriptor", variableName);
        if (string == null) {
            UnnecessaryFinalOnLocalVariableOrParameterInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        JCheckBox box1 = panel2.addCheckboxEx(InspectionGadgetsBundle.message("unnecessary.final.report.local.variables.option", new Object[0]), "reportLocalVariables");
        JCheckBox box2 = panel2.addCheckboxEx(InspectionGadgetsBundle.message("unnecessary.final.report.parameters.option", new Object[0]), "reportParameters");
        panel2.addDependentCheckBox(InspectionGadgetsBundle.message("unnecessary.final.on.parameter.only.interface.option", new Object[0]), "onlyWarnOnAbstractMethods", box2);
        box1.addChangeListener(e -> {
            if (!box1.isSelected()) {
                box2.setSelected(true);
            }
        });
        box2.addChangeListener(e -> {
            if (!box2.isSelected()) {
                box1.setSelected(true);
            }
        });
        return panel2;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryFinalOnLocalVariableOrParameterVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RemoveModifierFix("final");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessaryFinalOnLocalVariableOrParameterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnnecessaryFinalOnLocalVariableOrParameterVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryFinalOnLocalVariableOrParameterVisitor() {
        }

        public void visitDeclarationStatement(PsiDeclarationStatement statement2) {
            super.visitDeclarationStatement(statement2);
            if (!UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportLocalVariables) {
                return;
            }
            PsiElement[] declaredElements = statement2.getDeclaredElements();
            if (declaredElements.length == 0) {
                return;
            }
            PsiElement firstElement = declaredElements[0];
            if (!(firstElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable firstVariable = (PsiLocalVariable)firstElement;
            if (!firstVariable.hasModifierProperty("final")) {
                return;
            }
            PsiCodeBlock containingBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiCodeBlock.class);
            if (containingBlock == null) {
                return;
            }
            for (PsiElement declaredElement : declaredElements) {
                PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
                if (!this.isNecessaryFinal((PsiVariable)variable, (PsiElement)containingBlock)) continue;
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)firstElement;
            this.registerModifierError("final", (PsiModifierListOwner)variable, variable);
        }

        public void visitMethod(PsiMethod method) {
            PsiParameter[] parameters2;
            super.visitMethod(method);
            if (!UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportParameters) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            for (PsiParameter parameter2 : parameters2 = parameterList.getParameters()) {
                this.checkParameter(method, parameter2);
            }
        }

        private void checkParameter(PsiMethod method, PsiParameter parameter2) {
            if (!parameter2.hasModifierProperty("final")) {
                return;
            }
            if (method.hasModifierProperty("abstract")) {
                this.registerModifierError("final", (PsiModifierListOwner)parameter2, parameter2);
            } else if (!UnnecessaryFinalOnLocalVariableOrParameterInspection.this.onlyWarnOnAbstractMethods) {
                this.check(parameter2);
            }
        }

        public void visitTryStatement(PsiTryStatement statement2) {
            PsiCatchSection[] catchSections;
            super.visitTryStatement(statement2);
            if (UnnecessaryFinalOnLocalVariableOrParameterInspection.this.onlyWarnOnAbstractMethods || !UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportParameters) {
                return;
            }
            for (PsiCatchSection catchSection : catchSections = statement2.getCatchSections()) {
                PsiParameter parameter2 = catchSection.getParameter();
                PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                if (parameter2 == null || catchBlock == null || !parameter2.hasModifierProperty("final")) continue;
                this.check(parameter2);
            }
        }

        public void visitForeachStatement(PsiForeachStatement statement2) {
            super.visitForeachStatement(statement2);
            if (UnnecessaryFinalOnLocalVariableOrParameterInspection.this.onlyWarnOnAbstractMethods || !UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportParameters) {
                return;
            }
            PsiParameter parameter2 = statement2.getIterationParameter();
            if (!parameter2.hasModifierProperty("final")) {
                return;
            }
            this.check(parameter2);
        }

        private boolean isNecessaryFinal(PsiVariable parameter2, PsiElement context) {
            return !PsiUtil.isLanguageLevel8OrHigher((PsiElement)parameter2) && VariableAccessUtils.variableIsUsedInInnerClass(parameter2, context);
        }

        private void check(PsiParameter parameter2) {
            if (!this.isNecessaryFinal((PsiVariable)parameter2, parameter2.getDeclarationScope())) {
                this.registerModifierError("final", (PsiModifierListOwner)parameter2, parameter2);
            }
        }
    }
}

