/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaParameterHidingMemberVariableInspectionBase
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;

    @NotNull
    public String getID() {
        if ("LambdaParameterHidesMemberVariable" == null) {
            LambdaParameterHidingMemberVariableInspectionBase.$$$reportNull$$$0(0);
        }
        return "LambdaParameterHidesMemberVariable";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("lambda.parameter.hides.member.variable.display.name", new Object[0]);
        if (string == null) {
            LambdaParameterHidingMemberVariableInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("lambda.parameter.hides.member.variable.problem.descriptor", aClass.getName());
        if (string == null) {
            LambdaParameterHidingMemberVariableInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("lambda.parameter.hides.member.variable.ignore.invisible.option", new Object[0]), "m_ignoreInvisibleFields");
        return optionsPanel;
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return PsiUtil.isLanguageLevel8OrHigher((PsiElement)file2);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LambdaParameterHidingMemberVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/visibility/LambdaParameterHidingMemberVariableInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class LambdaParameterHidingMemberVariableVisitor
    extends BaseInspectionVisitor {
        private LambdaParameterHidingMemberVariableVisitor() {
        }

        public void visitParameter(@NotNull PsiParameter variable) {
            if (variable == null) {
                LambdaParameterHidingMemberVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitParameter(variable);
            PsiElement declarationScope = variable.getDeclarationScope();
            if (!(declarationScope instanceof PsiLambdaExpression)) {
                return;
            }
            PsiClass aClass = this.checkFieldName((PsiVariable)variable);
            if (aClass == null) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, aClass);
        }

        @Nullable
        private PsiClass checkFieldName(PsiVariable variable) {
            String variableName = variable.getName();
            if (variableName == null) {
                return null;
            }
            PsiClass aClass = ClassUtils.getContainingClass((PsiElement)variable);
            while (aClass != null) {
                PsiField field = aClass.findFieldByName(variableName, true);
                if (field != null) {
                    if (!LambdaParameterHidingMemberVariableInspectionBase.this.m_ignoreInvisibleFields) {
                        return aClass;
                    }
                    if (ClassUtils.isFieldVisible(field, aClass) && PsiUtil.getEnclosingStaticElement((PsiElement)variable, (PsiClass)aClass) == null || field.hasModifierProperty("static")) {
                        return aClass;
                    }
                }
                aClass = ClassUtils.getContainingClass((PsiElement)aClass);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/visibility/LambdaParameterHidingMemberVariableInspectionBase$LambdaParameterHidingMemberVariableVisitor", "visitParameter"));
        }
    }
}

