/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceFormatStringWithConcatenationIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = element -> {
            if (!(element instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
            if (!MethodCallUtils.isCallToMethod(methodCallExpression, "java.lang.String", (PsiType)TypeUtils.getStringType(element), "format", (PsiType[])null)) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            return arguments.length > 1 && ReplaceFormatStringWithConcatenationIntention.getPercentSCount(arguments[0]) == arguments.length - 1 || arguments.length > 2 && ReplaceFormatStringWithConcatenationIntention.getPercentSCount(arguments[1]) == arguments.length - 2;
        };
        if (psiElementPredicate == null) {
            ReplaceFormatStringWithConcatenationIntention.$$$reportNull$$$0(0);
        }
        return psiElementPredicate;
    }

    static int getPercentSCount(PsiExpression expression2) {
        if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiLiteralExpression) && !(expression2 instanceof PsiPolyadicExpression) || !ExpressionUtils.hasStringType(expression2)) {
            return -1;
        }
        Object value2 = ExpressionUtils.computeConstantExpression(expression2);
        if (!(value2 instanceof String)) {
            return -1;
        }
        String string = (String)value2;
        int index = string.indexOf(37);
        int length = string.length();
        int count = 0;
        while (index >= 0 && length > index + 1) {
            char c = string.charAt(index + 1);
            if (c == 's') {
                ++count;
            } else if (c != '%') {
                return -1;
            }
            index = string.indexOf(37, index + 1);
        }
        if (count == 0) {
            return -1;
        }
        return count;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            ReplaceFormatStringWithConcatenationIntention.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiMethodCallExpression)) {
            return;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        String replacementExpression = ExpressionUtils.hasStringType(arguments[0]) ? ReplaceFormatStringWithConcatenationIntention.buildReplacementExpression(arguments, 0) : ReplaceFormatStringWithConcatenationIntention.buildReplacementExpression(arguments, 1);
        PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, replacementExpression);
    }

    public static String buildReplacementExpression(PsiExpression[] arguments, int indexOfFormatString) {
        StringBuilder builder = new StringBuilder();
        String value2 = (String)ExpressionUtils.computeConstantExpression(arguments[indexOfFormatString]);
        assert (value2 != null);
        value2 = value2.replace("%%", "%");
        int start = 0;
        int end = value2.indexOf("%s");
        int count = 0;
        while (end >= 0) {
            if (end > start) {
                if (builder.length() > 0) {
                    builder.append('+');
                }
                builder.append('\"').append(value2.substring(start, end)).append('\"');
            }
            if (builder.length() > 0) {
                builder.append('+');
            }
            PsiExpression argument = arguments[indexOfFormatString + ++count];
            if (builder.length() == 0 && !ExpressionUtils.hasStringType(argument)) {
                builder.append("String.valueOf(").append(argument.getText()).append(')');
            } else {
                builder.append(argument.getText());
            }
            start = end + 2;
            end = value2.indexOf("%s", start);
        }
        if (start < value2.length() - 1) {
            if (builder.length() > 0) {
                builder.append('+');
            }
            builder.append('\"').append(value2.substring(start)).append('\"');
        }
        return builder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/concatenation/ReplaceFormatStringWithConcatenationIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/concatenation/ReplaceFormatStringWithConcatenationIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

