/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.constant;

import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.PsiElementPredicate;

class ConstantExpressionPredicate
implements PsiElementPredicate {
    ConstantExpressionPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiExpression[] operands2;
        if (!(element instanceof PsiPolyadicExpression)) {
            return false;
        }
        if (element instanceof PsiLiteralExpression || element instanceof PsiClassObjectAccessExpression) {
            return false;
        }
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)element;
        PsiType expressionType = expression2.getType();
        if (expressionType == null || expressionType.equalsToText("java.lang.String")) {
            return false;
        }
        for (PsiExpression operand2 : operands2 = expression2.getOperands()) {
            if (operand2 == null) {
                return false;
            }
            PsiType type2 = operand2.getType();
            if (type2 != null && !type2.equalsToText("java.lang.String")) continue;
            return false;
        }
        if (!PsiUtil.isConstantExpression((PsiExpression)expression2)) {
            return false;
        }
        try {
            Object value2 = ExpressionUtils.computeConstantExpression((PsiExpression)expression2, true);
            if (value2 == null) {
                return false;
            }
        }
        catch (ConstantEvaluationOverflowException ignore) {
            return false;
        }
        PsiElement parent = element.getParent();
        return !(parent instanceof PsiExpression) || !PsiUtil.isConstantExpression((PsiExpression)((PsiExpression)parent));
    }
}

