/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.forloop.IndexedForEachLoopPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceForEachLoopWithIndexedForLoopIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        IndexedForEachLoopPredicate indexedForEachLoopPredicate = new IndexedForEachLoopPredicate();
        if (indexedForEachLoopPredicate == null) {
            ReplaceForEachLoopWithIndexedForLoopIntention.$$$reportNull$$$0(0);
        }
        return indexedForEachLoopPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiForeachStatement statement2;
        if (element == null) {
            ReplaceForEachLoopWithIndexedForLoopIntention.$$$reportNull$$$0(1);
        }
        if ((statement2 = (PsiForeachStatement)element.getParent()) == null) {
            return;
        }
        PsiExpression iteratedValue2 = statement2.getIteratedValue();
        if (iteratedValue2 == null) {
            return;
        }
        PsiParameter iterationParameter = statement2.getIterationParameter();
        PsiType type2 = iterationParameter.getType();
        PsiType iteratedValueType = iteratedValue2.getType();
        if (iteratedValueType == null) {
            return;
        }
        boolean isArray = iteratedValueType instanceof PsiArrayType;
        PsiElement grandParent = statement2.getParent();
        Object context = grandParent instanceof PsiLabeledStatement ? (PsiStatement)grandParent : statement2;
        String iteratedValueText = ReplaceForEachLoopWithIndexedForLoopIntention.getReferenceToIterate(iteratedValue2, (PsiElement)context);
        StringBuilder newStatement = new StringBuilder();
        String indexText = ReplaceForEachLoopWithIndexedForLoopIntention.createVariableName("i", (PsiType)PsiType.INT, (PsiElement)statement2);
        this.createForLoopDeclaration(statement2, iteratedValue2, isArray, iteratedValueText, newStatement, indexText);
        Project project2 = statement2.getProject();
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project2);
        if (((JavaCodeStyleSettings)codeStyleSettings.getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_LOCALS) {
            newStatement.append("final ");
        }
        newStatement.append(type2.getCanonicalText());
        newStatement.append(' ');
        newStatement.append(iterationParameter.getName());
        newStatement.append(" = ");
        newStatement.append(iteratedValueText);
        if (isArray) {
            newStatement.append('[');
            newStatement.append(indexText);
            newStatement.append("];");
        } else {
            newStatement.append(".get(");
            newStatement.append(indexText);
            newStatement.append(");");
        }
        PsiStatement body2 = statement2.getBody();
        if (body2 == null) {
            return;
        }
        if (body2 instanceof PsiBlockStatement) {
            PsiCodeBlock block = ((PsiBlockStatement)body2).getCodeBlock();
            PsiElement[] children2 = block.getChildren();
            for (int i = 1; i < children2.length - 1; ++i) {
                newStatement.append(children2[i].getText());
            }
        } else {
            newStatement.append(body2.getText());
        }
        newStatement.append('}');
        PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)statement2, newStatement.toString());
    }

    protected void createForLoopDeclaration(PsiForeachStatement statement2, PsiExpression iteratedValue2, boolean array, String iteratedValueText, StringBuilder newStatement, String indexText) {
        newStatement.append("for(int ");
        newStatement.append(indexText);
        newStatement.append(" = 0; ");
        newStatement.append(indexText);
        newStatement.append('<');
        if (iteratedValue2 instanceof PsiTypeCastExpression) {
            newStatement.append('(');
            newStatement.append(iteratedValueText);
            newStatement.append(')');
        } else {
            newStatement.append(iteratedValueText);
        }
        if (array) {
            newStatement.append(".length");
        } else {
            newStatement.append(".size()");
        }
        newStatement.append(';');
        newStatement.append(indexText);
        newStatement.append("++)");
        newStatement.append("{ ");
    }

    @Nullable
    private static String getVariableName(PsiExpression expression2) {
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String name2 = methodExpression.getReferenceName();
            if (name2 == null) {
                return null;
            }
            if (name2.startsWith("to") && name2.length() > 2) {
                return StringUtil.decapitalize((String)name2.substring(2));
            }
            if (name2.startsWith("get") && name2.length() > 3) {
                return StringUtil.decapitalize((String)name2.substring(3));
            }
            return name2;
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression castExpression = (PsiTypeCastExpression)expression2;
            PsiExpression operand2 = castExpression.getOperand();
            return ReplaceForEachLoopWithIndexedForLoopIntention.getVariableName(operand2);
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression2;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            String name3 = ReplaceForEachLoopWithIndexedForLoopIntention.getVariableName(arrayExpression);
            return name3 == null ? null : StringUtil.unpluralize((String)name3);
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            PsiExpression innerExpression = parenthesizedExpression.getExpression();
            return ReplaceForEachLoopWithIndexedForLoopIntention.getVariableName(innerExpression);
        }
        if (expression2 instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)expression2;
            String referenceName = referenceElement.getReferenceName();
            if (referenceName == null) {
                return expression2.getText();
            }
            return referenceName;
        }
        return null;
    }

    private static String getReferenceToIterate(PsiExpression expression2, PsiElement context) {
        if (expression2 instanceof PsiMethodCallExpression || expression2 instanceof PsiTypeCastExpression || expression2 instanceof PsiArrayAccessExpression || expression2 instanceof PsiNewExpression) {
            String variableName = ReplaceForEachLoopWithIndexedForLoopIntention.getVariableName(expression2);
            return ReplaceForEachLoopWithIndexedForLoopIntention.createVariable(variableName, expression2, context);
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            PsiExpression innerExpression = parenthesizedExpression.getExpression();
            return ReplaceForEachLoopWithIndexedForLoopIntention.getReferenceToIterate(innerExpression, context);
        }
        if (expression2 instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)expression2;
            String variableName = ReplaceForEachLoopWithIndexedForLoopIntention.getVariableName(expression2);
            if (referenceElement.isQualified()) {
                return ReplaceForEachLoopWithIndexedForLoopIntention.createVariable(variableName, expression2, context);
            }
            PsiElement target2 = referenceElement.resolve();
            if (target2 instanceof PsiVariable) {
                return variableName;
            }
            return ReplaceForEachLoopWithIndexedForLoopIntention.createVariable(variableName, expression2, context);
        }
        return expression2.getText();
    }

    private static String createVariable(String variableNameRoot, PsiExpression iteratedValue2, PsiElement context) {
        String variableName = ReplaceForEachLoopWithIndexedForLoopIntention.createVariableName(variableNameRoot, iteratedValue2);
        Project project2 = context.getProject();
        PsiType iteratedValueType = iteratedValue2.getType();
        assert (iteratedValueType != null);
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiDeclarationStatement declarationStatement = elementFactory.createVariableDeclarationStatement(variableName, iteratedValueType, iteratedValue2);
        PsiElement newElement = context.getParent().addBefore((PsiElement)declarationStatement, context);
        JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(newElement);
        return variableName;
    }

    public static String createVariableName(@Nullable String baseName, @NotNull PsiExpression assignedExpression) {
        if (assignedExpression == null) {
            ReplaceForEachLoopWithIndexedForLoopIntention.$$$reportNull$$$0(2);
        }
        Project project2 = assignedExpression.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        SuggestedNameInfo names = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, baseName, assignedExpression, null);
        if (names.names.length == 0) {
            return codeStyleManager.suggestUniqueVariableName(baseName, (PsiElement)assignedExpression, true);
        }
        return codeStyleManager.suggestUniqueVariableName(names.names[0], (PsiElement)assignedExpression, true);
    }

    public static String createVariableName(@Nullable String baseName, @NotNull PsiType type2, @NotNull PsiElement context) {
        if (type2 == null) {
            ReplaceForEachLoopWithIndexedForLoopIntention.$$$reportNull$$$0(3);
        }
        if (context == null) {
            ReplaceForEachLoopWithIndexedForLoopIntention.$$$reportNull$$$0(4);
        }
        Project project2 = context.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        SuggestedNameInfo names = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, baseName, null, type2);
        if (names.names.length == 0) {
            return codeStyleManager.suggestUniqueVariableName(baseName, context, true);
        }
        return codeStyleManager.suggestUniqueVariableName(names.names[0], context, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/forloop/ReplaceForEachLoopWithIndexedForLoopIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/forloop/ReplaceForEachLoopWithIndexedForLoopIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createVariableName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

