/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.interfacetoclass;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.interfacetoclass.ConvertInterfaceToClassPredicate;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertInterfaceToClassIntention
extends Intention {
    @Override
    public boolean startInWriteAction() {
        return false;
    }

    public static void changeInterfaceToClass(PsiClass anInterface) throws IncorrectOperationException {
        PsiClass[] innerClasses;
        PsiField[] fields;
        PsiMethod[] methods;
        PsiIdentifier nameIdentifier = anInterface.getNameIdentifier();
        assert (nameIdentifier != null);
        PsiElement whiteSpace = nameIdentifier.getPrevSibling();
        assert (whiteSpace != null);
        PsiElement interfaceToken = whiteSpace.getPrevSibling();
        assert (interfaceToken != null);
        PsiKeyword interfaceKeyword = (PsiKeyword)interfaceToken.getOriginalElement();
        Project project2 = anInterface.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiKeyword classKeyword = factory.createKeyword("class");
        interfaceKeyword.replace((PsiElement)classKeyword);
        PsiModifierList classModifierList = anInterface.getModifierList();
        if (classModifierList == null) {
            return;
        }
        classModifierList.setModifierProperty("abstract", true);
        PsiElement parent = anInterface.getParent();
        if (parent instanceof PsiClass) {
            classModifierList.setModifierProperty("static", true);
        }
        for (PsiMethod method : methods = anInterface.getMethods()) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"public", (boolean)true);
            if (method.hasModifierProperty("default")) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"default", (boolean)false);
                continue;
            }
            if (method.hasModifierProperty("static")) continue;
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"abstract", (boolean)true);
        }
        for (PsiField field : fields = anInterface.getFields()) {
            PsiModifierList modifierList = field.getModifierList();
            if (modifierList == null) continue;
            modifierList.setModifierProperty("public", true);
            modifierList.setModifierProperty("static", true);
            modifierList.setModifierProperty("final", true);
        }
        for (PsiClass innerClass : innerClasses = anInterface.getInnerClasses()) {
            PsiModifierList modifierList = innerClass.getModifierList();
            if (modifierList == null) continue;
            modifierList.setModifierProperty("public", true);
            if (innerClass.isInterface()) continue;
            modifierList.setModifierProperty("static", true);
        }
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        boolean conflictsDialogOK;
        if (element == null) {
            ConvertInterfaceToClassIntention.$$$reportNull$$$0(0);
        }
        PsiClass anInterface = (PsiClass)element.getParent();
        SearchScope searchScope = anInterface.getUseScope();
        Collection inheritors = ClassInheritorsSearch.search((PsiClass)anInterface, (SearchScope)searchScope, (boolean)false).findAll();
        MultiMap conflicts = new MultiMap();
        inheritors.forEach(aClass -> {
            PsiElement target2;
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            PsiJavaCodeReferenceElement[] referenceElements = extendsList.getReferenceElements();
            if (referenceElements.length > 0 && (target2 = referenceElements[0].resolve()) instanceof PsiClass && !"java.lang.Object".equals(((PsiClass)target2).getQualifiedName())) {
                conflicts.putValue(aClass, (Object)IntentionPowerPackBundle.message("0.already.extends.1.and.will.not.compile.after.converting.2.to.a.class", RefactoringUIUtil.getDescription((PsiElement)aClass, true), RefactoringUIUtil.getDescription(target2, true), RefactoringUIUtil.getDescription((PsiElement)anInterface, false)));
            }
        });
        PsiFunctionalExpression functionalExpression = (PsiFunctionalExpression)FunctionalExpressionSearch.search((PsiClass)anInterface, (SearchScope)searchScope).findFirst();
        if (functionalExpression != null) {
            String conflictMessage = ClassPresentationUtil.getFunctionalExpressionPresentation(functionalExpression, true) + " will not compile after converting " + RefactoringUIUtil.getDescription((PsiElement)anInterface, false) + " to a class";
            conflicts.putValue((Object)functionalExpression, (Object)conflictMessage);
        }
        if (conflicts.isEmpty()) {
            conflictsDialogOK = true;
        } else {
            Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
            }
            ConflictsDialog conflictsDialog = new ConflictsDialog(anInterface.getProject(), (MultiMap<PsiElement, String>)conflicts, () -> ConvertInterfaceToClassIntention.convertInterfaceToClass(anInterface, inheritors));
            conflictsDialogOK = conflictsDialog.showAndGet();
        }
        if (conflictsDialogOK) {
            ConvertInterfaceToClassIntention.convertInterfaceToClass(anInterface, inheritors);
        }
    }

    private static void convertInterfaceToClass(PsiClass anInterface, Collection<PsiClass> inheritors) {
        ArrayList<PsiClass> prepare = new ArrayList<PsiClass>();
        prepare.add(anInterface);
        prepare.addAll(inheritors);
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(prepare)) {
            return;
        }
        WriteAction.run(() -> {
            ConvertInterfaceToClassIntention.moveSubClassImplementsToExtends(anInterface, inheritors);
            ConvertInterfaceToClassIntention.changeInterfaceToClass(anInterface);
            ConvertInterfaceToClassIntention.moveExtendsToImplements(anInterface);
        });
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ConvertInterfaceToClassPredicate convertInterfaceToClassPredicate = new ConvertInterfaceToClassPredicate();
        if (convertInterfaceToClassPredicate == null) {
            ConvertInterfaceToClassIntention.$$$reportNull$$$0(1);
        }
        return convertInterfaceToClassPredicate;
    }

    private static void moveExtendsToImplements(PsiClass anInterface) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] extendsRefElements;
        PsiReferenceList extendsList = anInterface.getExtendsList();
        PsiReferenceList implementsList = anInterface.getImplementsList();
        assert (extendsList != null);
        for (PsiJavaCodeReferenceElement referenceElement : extendsRefElements = extendsList.getReferenceElements()) {
            assert (implementsList != null);
            PsiElement resolved = referenceElement.resolve();
            if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isInterface()) continue;
            implementsList.add((PsiElement)referenceElement);
            referenceElement.delete();
        }
    }

    private static void moveSubClassImplementsToExtends(PsiClass oldInterface, Collection<PsiClass> inheritors) {
        PsiJavaCodeReferenceElement oldInterfaceReference = JavaPsiFacade.getElementFactory((Project)oldInterface.getProject()).createClassReferenceElement(oldInterface);
        for (PsiClass inheritor : inheritors) {
            PsiReferenceList implementsList = inheritor.getImplementsList();
            PsiReferenceList extendsList = inheritor.getExtendsList();
            if (implementsList == null) continue;
            ConvertInterfaceToClassIntention.moveReference(implementsList, extendsList, oldInterfaceReference);
        }
    }

    private static void moveReference(@NotNull PsiReferenceList source, @Nullable PsiReferenceList target2, @NotNull PsiJavaCodeReferenceElement reference) throws IncorrectOperationException {
        if (source == null) {
            ConvertInterfaceToClassIntention.$$$reportNull$$$0(2);
        }
        if (reference == null) {
            ConvertInterfaceToClassIntention.$$$reportNull$$$0(3);
        }
        PsiJavaCodeReferenceElement[] implementsReferences = source.getReferenceElements();
        String qualifiedName = reference.getQualifiedName();
        for (PsiJavaCodeReferenceElement implementsReference : implementsReferences) {
            String implementsReferenceQualifiedName = implementsReference.getQualifiedName();
            if (!qualifiedName.equals(implementsReferenceQualifiedName)) continue;
            if (target2 != null) {
                PsiElement aClass;
                PsiJavaCodeReferenceElement[] referenceElements = target2.getReferenceElements();
                if (referenceElements.length > 0 && (aClass = referenceElements[0].resolve()) instanceof PsiClass && "java.lang.Object".equals(((PsiClass)aClass).getQualifiedName())) {
                    referenceElements[0].delete();
                }
                target2.add((PsiElement)implementsReference);
            }
            implementsReference.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/interfacetoclass/ConvertInterfaceToClassIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/interfacetoclass/ConvertInterfaceToClassIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "moveReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

