/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.junit.CreateAssertPredicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CreateAssertIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        CreateAssertPredicate createAssertPredicate = new CreateAssertPredicate();
        if (createAssertPredicate == null) {
            CreateAssertIntention.$$$reportNull$$$0(0);
        }
        return createAssertPredicate;
    }

    @Override
    public void processIntention(PsiElement element) {
        String newStatement;
        PsiExpressionStatement statement2 = (PsiExpressionStatement)element;
        PsiExpression expression2 = statement2.getExpression();
        if (BoolUtils.isNegation(expression2)) {
            newStatement = CreateAssertIntention.buildNewStatement("assertFalse", element, BoolUtils.getNegatedExpressionText(expression2));
        } else if (ComparisonUtils.isNullComparison(expression2)) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            PsiExpression comparedExpression = ExpressionUtils.getValueComparedWithNull(binaryExpression);
            assert (comparedExpression != null);
            newStatement = JavaTokenType.EQEQ.equals(binaryExpression.getOperationTokenType()) ? CreateAssertIntention.buildNewStatement("assertNull", element, comparedExpression.getText()) : CreateAssertIntention.buildNewStatement("assertNotNull", element, comparedExpression.getText());
        } else if (CreateAssertIntention.isEqualityComparison(expression2)) {
            PsiExpression comparingExpression;
            PsiExpression comparedExpression;
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs instanceof PsiLiteralExpression) {
                comparedExpression = rhs;
                comparingExpression = lhs;
            } else {
                comparedExpression = lhs;
                comparingExpression = rhs;
            }
            assert (comparingExpression != null);
            PsiType type2 = lhs.getType();
            newStatement = PsiType.DOUBLE.equals((Object)type2) || PsiType.FLOAT.equals((Object)type2) ? CreateAssertIntention.buildNewStatement("assertEquals", element, comparedExpression.getText(), comparingExpression.getText(), "0.0") : (type2 instanceof PsiPrimitiveType ? CreateAssertIntention.buildNewStatement("assertEquals", element, comparedExpression.getText(), comparingExpression.getText()) : CreateAssertIntention.buildNewStatement("assertSame", element, comparedExpression.getText(), comparingExpression.getText()));
        } else if (CreateAssertIntention.isEqualsExpression(expression2)) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression comparedExpression = methodExpression.getQualifierExpression();
            assert (comparedExpression != null);
            PsiExpressionList argList = call.getArgumentList();
            PsiExpression comparingExpression = argList.getExpressions()[0];
            newStatement = comparingExpression instanceof PsiLiteralExpression ? CreateAssertIntention.buildNewStatement("assertEquals", element, comparingExpression.getText(), comparedExpression.getText()) : CreateAssertIntention.buildNewStatement("assertEquals", element, comparedExpression.getText(), comparingExpression.getText());
        } else {
            newStatement = CreateAssertIntention.buildNewStatement("assertTrue", element, expression2.getText());
        }
        PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)statement2, newStatement);
    }

    @NonNls
    private static String buildNewStatement(@NonNls String memberName, PsiElement context, String ... argumentTexts) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        StringBuilder builder = new StringBuilder(memberName).append('(');
        boolean comma = false;
        for (String argumentText : argumentTexts) {
            if (comma) {
                builder.append(',');
            } else {
                comma = true;
            }
            builder.append(argumentText);
        }
        builder.append(')');
        String text2 = builder.toString();
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)factory.createExpressionFromText(text2, context);
        PsiMethod method = methodCallExpression.resolveMethod();
        if (CreateAssertIntention.isJUnitMethod(method) || CreateAssertIntention.hasStaticImports(context) && ImportUtils.addStaticImport("org.junit.Assert", memberName, context)) {
            return text2 + ';';
        }
        return "org.junit.Assert." + text2 + ';';
    }

    private static boolean isJUnitMethod(PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String qualifiedName = containingClass.getQualifiedName();
        return "org.junit.Assert".equals(qualifiedName) || "junit.framework.TestCase".equals(qualifiedName);
    }

    private static boolean hasStaticImports(PsiElement element) {
        PsiFile file2 = element.getContainingFile();
        if (!(file2 instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file2;
        PsiImportList importList = javaFile.getImportList();
        return importList != null && importList.getImportStaticStatements().length > 0;
    }

    private static boolean isEqualsExpression(PsiExpression expression2) {
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"equals".equals(methodName)) {
            return false;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        PsiExpressionList argList = call.getArgumentList();
        PsiExpression[] expressions2 = argList.getExpressions();
        return expressions2.length == 1 && expressions2[0] != null;
    }

    private static boolean isEqualityComparison(PsiExpression expression2) {
        if (!(expression2 instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        return JavaTokenType.EQEQ.equals(tokenType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/junit/CreateAssertIntention", "getElementPredicate"));
    }
}

