/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToNestedIfIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (!(element instanceof PsiReturnStatement)) {
                    return false;
                }
                PsiReturnStatement returnStatement = (PsiReturnStatement)element;
                PsiExpression returnValue = ParenthesesUtils.stripParentheses(returnStatement.getReturnValue());
                if (!(returnValue instanceof PsiPolyadicExpression)) {
                    return false;
                }
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)returnValue;
                IElementType tokenType = polyadicExpression.getOperationTokenType();
                return tokenType == JavaTokenType.ANDAND || tokenType == JavaTokenType.OROR;
            }
        };
        if (psiElementPredicate == null) {
            ConvertToNestedIfIntention.$$$reportNull$$$0(0);
        }
        return psiElementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiReturnStatement returnStatement;
        PsiExpression returnValue;
        if (element == null) {
            ConvertToNestedIfIntention.$$$reportNull$$$0(1);
        }
        if ((returnValue = (returnStatement = (PsiReturnStatement)element).getReturnValue()) == null || ErrorUtil.containsDeepError((PsiElement)returnValue)) {
            return;
        }
        String newStatementText = ConvertToNestedIfIntention.buildIf(returnValue, true, new StringBuilder()).toString();
        Project project2 = returnStatement.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiBlockStatement blockStatement = (PsiBlockStatement)elementFactory.createStatementFromText("{" + newStatementText + "}", (PsiElement)returnStatement);
        PsiElement parent = returnStatement.getParent();
        for (PsiStatement st : blockStatement.getCodeBlock().getStatements()) {
            CodeStyleManager.getInstance((Project)project2).reformat(parent.addBefore((PsiElement)st, (PsiElement)returnStatement));
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)returnStatement, "return false;");
    }

    private static StringBuilder buildIf(@Nullable PsiExpression expression2, boolean top, StringBuilder out) {
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            PsiExpression[] operands2 = polyadicExpression.getOperands();
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.ANDAND.equals(tokenType)) {
                for (PsiExpression operand2 : operands2) {
                    ConvertToNestedIfIntention.buildIf(operand2, false, out);
                }
                if (top && !StringUtil.endsWith((CharSequence)out, (CharSequence)"return true;")) {
                    out.append("return true;");
                }
                return out;
            }
            if (top && JavaTokenType.OROR.equals(tokenType)) {
                for (PsiExpression operand3 : operands2) {
                    ConvertToNestedIfIntention.buildIf(operand3, false, out);
                    if (StringUtil.endsWith((CharSequence)out, (CharSequence)"return true;")) continue;
                    out.append("return true;");
                }
                return out;
            }
        } else if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            ConvertToNestedIfIntention.buildIf(parenthesizedExpression.getExpression(), top, out);
            return out;
        }
        if (expression2 != null) {
            out.append("if(").append(expression2.getText()).append(")");
        }
        return out;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/trivialif/ConvertToNestedIfIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/trivialif/ConvertToNestedIfIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

