/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.trivialif.ExpandBooleanPredicate;
import org.jetbrains.annotations.NotNull;

public class ExpandBooleanIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ExpandBooleanPredicate expandBooleanPredicate = new ExpandBooleanPredicate();
        if (expandBooleanPredicate == null) {
            ExpandBooleanIntention.$$$reportNull$$$0(0);
        }
        return expandBooleanPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        if (element instanceof PsiDeclarationStatement) {
            return IntentionPowerPackBundle.message("expand.boolean.declaration.intention.name", new Object[0]);
        }
        if (element instanceof PsiReturnStatement) {
            return IntentionPowerPackBundle.message("expand.boolean.return.intention.name", new Object[0]);
        }
        return IntentionPowerPackBundle.message("expand.boolean.assignment.intention.name", new Object[0]);
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            ExpandBooleanIntention.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiStatement)) {
            return;
        }
        PsiStatement statement2 = (PsiStatement)element;
        if (ExpandBooleanPredicate.isBooleanAssignment(statement2)) {
            PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)statement2;
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (rhs == null) {
                return;
            }
            String lhsText = assignmentExpression.getLExpression().getText();
            String signText = assignmentExpression.getOperationSign().getText();
            String newStatementText = "if(" + (signText.length() == 2 ? lhsText + signText.charAt(0) : "") + "true)" + lhsText + "=true; else " + lhsText + "=false;";
            PsiIfStatement newIfStatement = (PsiIfStatement)JavaPsiFacade.getElementFactory((Project)element.getProject()).createStatementFromText(newStatementText, element);
            PsiExpression condition2 = newIfStatement.getCondition();
            if (condition2 instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition2;
                PsiExpression operand2 = binaryExpression.getROperand();
                if (operand2 != null) {
                    operand2.replace((PsiElement)rhs);
                }
            } else {
                condition2.replace((PsiElement)rhs);
            }
            statement2.replace((PsiElement)newIfStatement);
        } else if (ExpandBooleanPredicate.isBooleanReturn(statement2)) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) {
                return;
            }
            String newStatementText = "if(true) return true; else return false;";
            PsiIfStatement newIfStatement = (PsiIfStatement)JavaPsiFacade.getElementFactory((Project)element.getProject()).createStatementFromText("if(true) return true; else return false;", element);
            PsiExpression condition3 = newIfStatement.getCondition();
            assert (condition3 != null);
            condition3.replace((PsiElement)returnValue);
            statement2.replace((PsiElement)newIfStatement);
        } else if (ExpandBooleanPredicate.isBooleanDeclaration(statement2)) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement2;
            PsiElement declaredElement = declarationStatement.getDeclaredElements()[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return;
            }
            String name2 = variable.getName();
            String newStatementText = "if(true) " + name2 + "=true; else " + name2 + "=false;";
            Project project2 = statement2.getProject();
            PsiIfStatement newIfStatement = (PsiIfStatement)JavaPsiFacade.getElementFactory((Project)project2).createStatementFromText(newStatementText, (PsiElement)statement2);
            PsiExpression condition4 = newIfStatement.getCondition();
            assert (condition4 != null);
            condition4.replace((PsiElement)initializer);
            PsiElement newElement = declarationStatement.getParent().addAfter((PsiElement)newIfStatement, (PsiElement)declarationStatement);
            CodeStyleManager.getInstance((Project)project2).reformat(newElement);
            initializer.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/trivialif/ExpandBooleanIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/trivialif/ExpandBooleanIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

