/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ipp.base.PsiElementPredicate;

class ExpandBooleanPredicate
implements PsiElementPredicate {
    ExpandBooleanPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiStatement)) {
            return false;
        }
        PsiStatement statement2 = (PsiStatement)element;
        PsiElement lastLeaf = PsiTreeUtil.getDeepestLast((PsiElement)statement2);
        if (PsiUtil.isJavaToken((PsiElement)lastLeaf, (IElementType)JavaTokenType.SEMICOLON) && PsiTreeUtil.prevLeaf((PsiElement)lastLeaf) instanceof PsiErrorElement) {
            return false;
        }
        return ExpandBooleanPredicate.isBooleanReturn(statement2) || ExpandBooleanPredicate.isBooleanAssignment(statement2) || ExpandBooleanPredicate.isBooleanDeclaration(statement2);
    }

    public static boolean isBooleanReturn(PsiStatement statement2) {
        if (!(statement2 instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)statement2;
        PsiExpression returnValue = returnStatement.getReturnValue();
        if (returnValue == null || returnValue instanceof PsiLiteralExpression) {
            return false;
        }
        PsiType returnType = returnValue.getType();
        return PsiType.BOOLEAN.equals((Object)returnType);
    }

    public static boolean isBooleanAssignment(PsiStatement statement2) {
        if (!(statement2 instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
        PsiExpression expression2 = expressionStatement.getExpression();
        if (!(expression2 instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression2;
        PsiExpression rhs = assignment.getRExpression();
        if (rhs == null || rhs instanceof PsiLiteralExpression) {
            return false;
        }
        PsiType assignmentType = rhs.getType();
        return PsiType.BOOLEAN.equals((Object)assignmentType);
    }

    public static boolean isBooleanDeclaration(PsiStatement statement2) {
        if (!(statement2 instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement2;
        PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
        if (declaredElements.length != 1) {
            return false;
        }
        PsiElement element = declaredElements[0];
        if (!(element instanceof PsiLocalVariable)) {
            return false;
        }
        PsiLocalVariable variable = (PsiLocalVariable)element;
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null || initializer instanceof PsiLiteralExpression) {
            return false;
        }
        PsiType type2 = initializer.getType();
        return PsiType.BOOLEAN.equals((Object)type2);
    }
}

