/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.trivialif.ReplaceIfWithConditionalPredicate;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceIfWithConditionalIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ReplaceIfWithConditionalPredicate replaceIfWithConditionalPredicate = new ReplaceIfWithConditionalPredicate();
        if (replaceIfWithConditionalPredicate == null) {
            ReplaceIfWithConditionalIntention.$$$reportNull$$$0(0);
        }
        return replaceIfWithConditionalPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiIfStatement ifStatement;
        if (element == null) {
            ReplaceIfWithConditionalIntention.$$$reportNull$$$0(1);
        }
        if ((ifStatement = (PsiIfStatement)element.getParent()) == null) {
            return;
        }
        if (ReplaceIfWithConditionalPredicate.isReplaceableAssignment(ifStatement)) {
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiExpressionStatement strippedThenBranch = (PsiExpressionStatement)ControlFlowUtils.stripBraces(thenBranch);
            PsiStatement elseBranch = ifStatement.getElseBranch();
            PsiExpressionStatement strippedElseBranch = (PsiExpressionStatement)ControlFlowUtils.stripBraces(elseBranch);
            PsiAssignmentExpression thenAssign = (PsiAssignmentExpression)strippedThenBranch.getExpression();
            PsiAssignmentExpression elseAssign = (PsiAssignmentExpression)strippedElseBranch.getExpression();
            PsiExpression lhs = thenAssign.getLExpression();
            String lhsText = lhs.getText();
            PsiJavaToken sign = thenAssign.getOperationSign();
            String operator2 = sign.getText();
            PsiExpression thenRhs = thenAssign.getRExpression();
            if (thenRhs == null) {
                return;
            }
            PsiExpression elseRhs = elseAssign.getRExpression();
            if (elseRhs == null) {
                return;
            }
            String conditional = ReplaceIfWithConditionalIntention.getConditionalText(condition2, thenRhs, elseRhs, thenAssign.getType());
            ReplaceIfWithConditionalIntention.replaceIfStatement(ifStatement, lhsText + operator2 + conditional + ';');
        } else if (ReplaceIfWithConditionalPredicate.isReplaceableReturn(ifStatement)) {
            PsiExpression condition3 = ifStatement.getCondition();
            if (condition3 == null) {
                return;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiReturnStatement thenReturn = (PsiReturnStatement)ControlFlowUtils.stripBraces(thenBranch);
            PsiStatement elseBranch = ifStatement.getElseBranch();
            PsiReturnStatement elseReturn = (PsiReturnStatement)ControlFlowUtils.stripBraces(elseBranch);
            PsiExpression thenReturnValue = thenReturn.getReturnValue();
            if (thenReturnValue == null) {
                return;
            }
            PsiExpression elseReturnValue = elseReturn.getReturnValue();
            if (elseReturnValue == null) {
                return;
            }
            String conditional = ReplaceIfWithConditionalIntention.getConditional(condition3, (PsiElement)thenReturn, thenReturnValue, elseReturnValue);
            if (conditional == null) {
                return;
            }
            ReplaceIfWithConditionalIntention.replaceIfStatement(ifStatement, "return " + conditional + ';');
        } else if (ReplaceIfWithConditionalPredicate.isReplaceableMethodCall(ifStatement)) {
            PsiExpression condition4 = ifStatement.getCondition();
            if (condition4 == null) {
                return;
            }
            PsiExpressionStatement thenBranch = (PsiExpressionStatement)ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
            PsiExpressionStatement elseBranch = (PsiExpressionStatement)ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
            PsiMethodCallExpression thenMethodCallExpression = (PsiMethodCallExpression)thenBranch.getExpression();
            PsiMethodCallExpression elseMethodCallExpression = (PsiMethodCallExpression)elseBranch.getExpression();
            StringBuilder replacementText = new StringBuilder(thenMethodCallExpression.getMethodExpression().getText());
            replacementText.append('(');
            PsiExpressionList thenArgumentList = thenMethodCallExpression.getArgumentList();
            PsiExpression[] thenArguments = thenArgumentList.getExpressions();
            PsiExpressionList elseArgumentList = elseMethodCallExpression.getArgumentList();
            PsiExpression[] elseArguments = elseArgumentList.getExpressions();
            int length = thenArguments.length;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    replacementText.append(',');
                }
                PsiExpression thenArgument = thenArguments[i];
                PsiExpression elseArgument = elseArguments[i];
                if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenArgument, elseArgument)) {
                    replacementText.append(thenArgument.getText());
                    continue;
                }
                PsiMethod method = thenMethodCallExpression.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiParameterList parameterList = method.getParameterList();
                PsiType requiredType = parameterList.getParameters()[i].getType();
                String conditionalText = ReplaceIfWithConditionalIntention.getConditionalText(condition4, thenArgument, elseArgument, requiredType);
                if (conditionalText == null) {
                    return;
                }
                replacementText.append(conditionalText);
            }
            replacementText.append(");");
            ReplaceIfWithConditionalIntention.replaceIfStatement(ifStatement, replacementText.toString());
        } else if (ReplaceIfWithConditionalPredicate.isReplaceableImplicitReturn(ifStatement)) {
            PsiExpression condition5 = ifStatement.getCondition();
            if (condition5 == null) {
                return;
            }
            PsiReturnStatement thenBranch = (PsiReturnStatement)ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
            PsiExpression thenReturnValue = thenBranch.getReturnValue();
            if (thenReturnValue == null) {
                return;
            }
            PsiReturnStatement elseBranch = (PsiReturnStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)ifStatement, PsiReturnStatement.class);
            if (elseBranch == null) {
                return;
            }
            PsiExpression elseReturnValue = elseBranch.getReturnValue();
            if (elseReturnValue == null) {
                return;
            }
            String conditional = ReplaceIfWithConditionalIntention.getConditional(condition5, (PsiElement)thenBranch, thenReturnValue, elseReturnValue);
            if (conditional == null) {
                return;
            }
            ReplaceIfWithConditionalIntention.replaceIfStatement(ifStatement, "return " + conditional + ';');
            elseBranch.delete();
        }
    }

    @Nullable
    private static String getConditional(PsiExpression condition2, PsiElement thenBranch, PsiExpression thenReturnValue, PsiExpression elseReturnValue) {
        PsiType methodType = PsiTypesUtil.getMethodReturnType((PsiElement)thenBranch);
        return methodType == null ? null : ReplaceIfWithConditionalIntention.getConditionalText(condition2, thenReturnValue, elseReturnValue, methodType);
    }

    private static void replaceIfStatement(PsiIfStatement ifStatement, String text2) {
        PsiElement parent = ifStatement.getParent();
        Collection comments = PsiTreeUtil.findChildrenOfType((PsiElement)ifStatement, PsiComment.class);
        for (PsiComment comment : comments) {
            parent.addBefore((PsiElement)comment, (PsiElement)ifStatement);
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)ifStatement, text2);
    }

    private static String getConditionalText(PsiExpression condition2, PsiExpression thenValue, PsiExpression elseValue, PsiType requiredType) {
        condition2 = ParenthesesUtils.stripParentheses(condition2);
        thenValue = ParenthesesUtils.stripParentheses(thenValue);
        elseValue = ParenthesesUtils.stripParentheses(elseValue);
        if ((thenValue = ReplaceIfWithConditionalIntention.expandDiamondsWhenNeeded(thenValue, requiredType)) == null) {
            return null;
        }
        if ((elseValue = ReplaceIfWithConditionalIntention.expandDiamondsWhenNeeded(elseValue, requiredType)) == null) {
            return null;
        }
        StringBuilder conditional = new StringBuilder();
        String conditionText = ReplaceIfWithConditionalIntention.getExpressionText(condition2, true);
        conditional.append(conditionText).append('?');
        PsiType thenType = thenValue.getType();
        PsiType elseType = elseValue.getType();
        if (thenType instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)thenType) && !(elseType instanceof PsiPrimitiveType) && !(requiredType instanceof PsiPrimitiveType)) {
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)thenType;
            conditional.append(primitiveType.getBoxedTypeName());
            conditional.append(".valueOf(").append(thenValue.getText()).append("):");
            conditional.append(ReplaceIfWithConditionalIntention.getExpressionText(elseValue, false));
        } else if (elseType instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)elseType) && !(thenType instanceof PsiPrimitiveType) && !(requiredType instanceof PsiPrimitiveType)) {
            conditional.append(ReplaceIfWithConditionalIntention.getExpressionText(thenValue, false));
            conditional.append(':');
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)elseType;
            conditional.append(primitiveType.getBoxedTypeName());
            conditional.append(".valueOf(").append(elseValue.getText()).append(')');
        } else {
            conditional.append(ReplaceIfWithConditionalIntention.getExpressionText(thenValue, false));
            conditional.append(':');
            conditional.append(ReplaceIfWithConditionalIntention.getExpressionText(elseValue, false));
        }
        return conditional.toString();
    }

    private static PsiExpression expandDiamondsWhenNeeded(PsiExpression thenValue, PsiType requiredType) {
        if (thenValue instanceof PsiNewExpression && !PsiDiamondTypeUtil.canChangeContextForDiamond((PsiNewExpression)thenValue, requiredType)) {
            return PsiDiamondTypeUtil.expandTopLevelDiamondsInside(thenValue);
        }
        return thenValue;
    }

    private static String getExpressionText(PsiExpression expression2, boolean isCondition) {
        int precedence = ParenthesesUtils.getPrecedence(expression2);
        if (precedence <= 15) {
            if (isCondition && precedence == 15) {
                return '(' + expression2.getText() + ')';
            }
            return expression2.getText();
        }
        return '(' + expression2.getText() + ')';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/trivialif/ReplaceIfWithConditionalIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/trivialif/ReplaceIfWithConditionalIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

