/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpClosure;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReDoSInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Exponential backtracking" == null) {
            ReDoSInspection.$$$reportNull$$$0(0);
        }
        return "Exponential backtracking";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ReDoSInspection.$$$reportNull$$$0(1);
        }
        ReDoSVisitor reDoSVisitor = new ReDoSVisitor(holder);
        if (reDoSVisitor == null) {
            ReDoSInspection.$$$reportNull$$$0(2);
        }
        return reDoSVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/inspection/ReDoSInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/inspection/ReDoSInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReDoSVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        public ReDoSVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpClosure(RegExpClosure closure) {
            if (!ReDoSVisitor.hasSuspiciousQuantifier(closure)) {
                return;
            }
            RegExpClosure parent = (RegExpClosure)PsiTreeUtil.getParentOfType((PsiElement)closure, RegExpClosure.class);
            while (parent != null) {
                if (ReDoSVisitor.hasSuspiciousQuantifier(parent)) {
                    if (ReDoSVisitor.isAtomic(closure)) {
                        return;
                    }
                    this.myHolder.registerProblem((PsiElement)parent, "Potential exponential backtracking", new LocalQuickFix[0]);
                    return;
                }
                parent = (RegExpClosure)PsiTreeUtil.getParentOfType((PsiElement)parent, RegExpClosure.class);
            }
        }

        private static boolean hasSuspiciousQuantifier(RegExpClosure closure) {
            RegExpQuantifier quantifier = closure.getQuantifier();
            if (!quantifier.isCounted()) {
                ASTNode token = quantifier.getToken();
                return token != null && token.getElementType() != RegExpTT.QUEST;
            }
            RegExpNumber max = quantifier.getMax();
            if (max == null) {
                return true;
            }
            Number value2 = max.getValue();
            return value2 == null || value2.doubleValue() >= 10.0;
        }

        private static boolean isAtomic(RegExpAtom element) {
            while (element != null) {
                RegExpGroup group;
                RegExpClosure closure;
                if (element instanceof RegExpClosure ? (closure = (RegExpClosure)element).getQuantifier().isPossessive() : element instanceof RegExpGroup && (group = (RegExpGroup)element).getType() == RegExpGroup.Type.ATOMIC) {
                    return true;
                }
                element = (RegExpAtom)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{RegExpClosure.class, RegExpGroup.class});
            }
            return false;
        }
    }
}

