/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpProperty;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpPropertyImpl
extends RegExpElementImpl
implements RegExpProperty {
    private static final String[] UNICODE_BLOCKS;

    public RegExpPropertyImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public PsiReference getReference() {
        ASTNode lbrace = this.getNode().findChildByType(RegExpTT.LBRACE);
        if (lbrace == null) {
            return null;
        }
        return new MyPsiReference();
    }

    @Override
    public boolean isNegated() {
        ASTNode node1 = this.getNode().findChildByType(RegExpTT.PROPERTY);
        ASTNode node2 = this.getNode().findChildByType(RegExpTT.CARET);
        return (node1 != null && node1.textContains('P')) ^ node2 != null;
    }

    @Override
    @Nullable
    public ASTNode getCategoryNode() {
        return this.getNode().findChildByType(RegExpTT.NAME);
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpProperty(this);
    }

    static {
        Field[] fields = Character.UnicodeBlock.class.getFields();
        ArrayList<String> unicodeBlocks = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            if (!field.getType().equals(Character.UnicodeBlock.class) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
            unicodeBlocks.add("In" + field.getName());
        }
        UNICODE_BLOCKS = ArrayUtil.toStringArray(unicodeBlocks);
    }

    private class MyPsiReference
    implements PsiReference {
        private MyPsiReference() {
        }

        public PsiElement getElement() {
            return RegExpPropertyImpl.this;
        }

        public TextRange getRangeInElement() {
            ASTNode firstNode = RegExpPropertyImpl.this.getNode().findChildByType(RegExpTT.CARET);
            if (firstNode == null) {
                firstNode = RegExpPropertyImpl.this.getNode().findChildByType(RegExpTT.LBRACE);
            }
            assert (firstNode != null);
            ASTNode rbrace = RegExpPropertyImpl.this.getNode().findChildByType(RegExpTT.RBRACE);
            int to = rbrace == null ? RegExpPropertyImpl.this.getTextRange().getEndOffset() : rbrace.getTextRange().getEndOffset() - 1;
            TextRange t = new TextRange(firstNode.getStartOffset() + 1, to);
            return t.shiftRight(-RegExpPropertyImpl.this.getTextRange().getStartOffset());
        }

        @Nullable
        public PsiElement resolve() {
            return RegExpPropertyImpl.this;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.getRangeInElement().substring(this.getElement().getText());
            if (string == null) {
                MyPsiReference.$$$reportNull$$$0(0);
            }
            return string;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            throw new IncorrectOperationException();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                MyPsiReference.$$$reportNull$$$0(1);
            }
            throw new IncorrectOperationException();
        }

        public boolean isReferenceTo(PsiElement element) {
            return false;
        }

        @NotNull
        public Object[] getVariants() {
            ASTNode categoryNode = RegExpPropertyImpl.this.getCategoryNode();
            if (categoryNode != null && categoryNode.getText().startsWith("In") && !categoryNode.getText().startsWith("Intelli")) {
                Object[] objectArray = UNICODE_BLOCKS;
                if (objectArray == null) {
                    MyPsiReference.$$$reportNull$$$0(2);
                }
                return objectArray;
            }
            boolean startsWithIs = categoryNode != null && categoryNode.getText().startsWith("Is");
            ArrayList result2 = ContainerUtil.newArrayList();
            for (Object[] objectArray : RegExpLanguageHosts.getInstance().getAllKnownProperties(this.getElement())) {
                String name2 = (String)ArrayUtil.getFirstElement((Object[])objectArray);
                if (name2 == null) continue;
                Object typeText = objectArray.length > 1 ? objectArray[1] : "Character.is" + name2.substring("java".length()) + "()";
                result2.add(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)name2).withPresentableText(startsWithIs ? "Is" + name2 : name2).withIcon(PlatformIcons.PROPERTY_ICON).withTypeText((String)typeText), (double)this.getPriority(name2)));
            }
            Object[] objectArray = ArrayUtil.toObjectArray((Collection)result2);
            if (objectArray == null) {
                MyPsiReference.$$$reportNull$$$0(3);
            }
            return objectArray;
        }

        private int getPriority(@NotNull String propertyName) {
            if (propertyName == null) {
                MyPsiReference.$$$reportNull$$$0(4);
            }
            if (propertyName.equals("all")) {
                return 3;
            }
            if (propertyName.startsWith("java")) {
                return 1;
            }
            if (propertyName.length() > 2) {
                return 2;
            }
            return 0;
        }

        public boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/psi/impl/RegExpPropertyImpl$MyPsiReference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/psi/impl/RegExpPropertyImpl$MyPsiReference";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getPriority";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

