/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.config;

import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.config.NoNamespaceConfig;

class NoNamespaceConfigPanel
extends HectorComponentPanel {
    private final NoNamespaceConfig myConfig;
    private final PsiFile myFile;
    private final String myMapping;
    private TextFieldWithBrowseButton mySchemaFile;
    private JPanel myRoot;
    private boolean myDialogOpen;

    NoNamespaceConfigPanel(NoNamespaceConfig noNamespaceConfig, PsiFile file2) {
        this.myConfig = noNamespaceConfig;
        this.myFile = file2;
        this.$$$setupUI$$$();
        this.myMapping = this.myConfig.getMapping(file2);
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file2) {
                FileType type2;
                boolean b = super.isFileSelectable(file2);
                if (b && (type2 = file2.getFileType()) != StdFileTypes.XML) {
                    return type2 == RncFileType.getInstance();
                }
                return b;
            }
        };
        Project project2 = file2.getProject();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null) {
            Module module2 = ProjectRootManager.getInstance((Project)project2).getFileIndex().getModuleForFile(virtualFile);
            descriptor2.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)module2);
        }
        ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> actionListener = new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>("Select Schema", "Select a RELAX-NG file to associate with the document", (ComponentWithBrowseButton)this.mySchemaFile, project2, descriptor2, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            public void actionPerformed(ActionEvent e) {
                NoNamespaceConfigPanel.this.myDialogOpen = true;
                try {
                    super.actionPerformed(e);
                }
                finally {
                    NoNamespaceConfigPanel.this.myDialogOpen = false;
                }
            }
        };
        this.mySchemaFile.addActionListener((ActionListener)actionListener);
    }

    public boolean canClose() {
        return super.canClose() && !this.myDialogOpen;
    }

    public JComponent createComponent() {
        return this.myRoot;
    }

    public boolean isModified() {
        String s = this.mySchemaFile.getText();
        String m = this.myMapping != null ? this.myMapping : "";
        return !s.equals(m);
    }

    public void apply() throws ConfigurationException {
        String s = this.getMapping();
        if (s != null) {
            this.myConfig.setMapping(this.myFile, s);
        } else {
            this.myConfig.setMapping(this.myFile, null);
        }
    }

    private String getMapping() {
        String s = this.mySchemaFile.getText().trim();
        return s.length() > 0 ? VfsUtil.pathToUrl((String)s.replace(File.separatorChar, '/')) : null;
    }

    public void reset() {
        this.mySchemaFile.setText(this.myMapping != null ? VfsUtil.urlToPath((String)this.myMapping).replace('/', File.separatorChar) : "");
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"RELAX-NG Schema Association", (int)0, (int)0, null, null));
        this.mySchemaFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, new Dimension(160, -1), null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

