/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.io.CharSequenceBackedByChars;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.debugger.LogEntry;
import org.jetbrains.debugger.MessagingLogger;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\b\u0001\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u001a\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"createDebugLogger", "Lorg/jetbrains/debugger/MessagingLogger;", "key", "", "suffix", "createDebugLoggerWithFile", "debugFile", "script-debugger-backend"})
public final class UtilKt {
    @Nullable
    public static final MessagingLogger createDebugLogger(@PropertyKey(resourceBundle="misc.registry") @NotNull String key2, @NotNull String suffix) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        String debugFile = Registry.stringValue((String)key2);
        CharSequence charSequence = debugFile;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        charSequence = suffix;
        if (!(charSequence.length() == 0)) {
            debugFile = StringsKt.replace$default((String)debugFile, (String)".json", (String)(suffix + ".json"), (boolean)false, (int)4, null);
        }
        String string = debugFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"debugFile");
        return UtilKt.createDebugLoggerWithFile(string);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ MessagingLogger createDebugLogger$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return UtilKt.createDebugLogger(string, string2);
    }

    @Nullable
    public static final MessagingLogger createDebugLoggerWithFile(@NotNull String debugFile) {
        Intrinsics.checkParameterIsNotNull((Object)debugFile, (String)"debugFile");
        ConcurrentLinkedQueue<LogEntry> queue2 = new ConcurrentLinkedQueue<LogEntry>();
        MessagingLogger logger = new MessagingLogger(queue2);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(debugFile, queue2, logger){
            final /* synthetic */ String $debugFile;
            final /* synthetic */ ConcurrentLinkedQueue $queue;
            final /* synthetic */ MessagingLogger $logger;

            public final void run() {
                OutputStreamWriter writer;
                FileOutputStream out;
                block5: {
                    File file2 = new File(FileUtil.expandUserHome((String)this.$debugFile));
                    FileUtilRt.createParentDirs((File)file2);
                    out = new FileOutputStream(file2);
                    OutputStream outputStream = out;
                    Charset charset = Charsets.UTF_8;
                    writer = new OutputStreamWriter(outputStream, charset);
                    writer.write("[\n");
                    writer.flush();
                    FileChannel fileChannel = out.getChannel();
                    SimpleDateFormat dateFormatter = new SimpleDateFormat("HH.mm.ss,SSS");
                    while (true) {
                        Object message2;
                        LogEntry entry;
                        if ((LogEntry)this.$queue.poll() == null) {
                            if (!this.$logger.getClosed$script_debugger_backend()) continue;
                            break block5;
                        }
                        writer.write("{\"timestamp\": \"" + dateFormatter.format(entry.getTime$script_debugger_backend()) + "\", ");
                        Object object = message2 = entry.getMessage();
                        if (object instanceof CharSequence) {
                            writer.write('\"' + entry.getMarker() + "\": ");
                            writer.flush();
                            if (message2 instanceof CharSequenceBackedByChars) {
                                fileChannel.write(((CharSequenceBackedByChars)message2).getByteBuffer());
                            } else {
                                fileChannel.write(Charsets.UTF_8.encode(CharBuffer.wrap((CharSequence)message2)));
                            }
                            writer.write("},\n");
                            writer.flush();
                            continue;
                        }
                        if (!(object instanceof ByteBuf)) break;
                        writer.write('\"' + entry.getMarker() + "\": ");
                        writer.flush();
                        ((ByteBuf)message2).getBytes(((ByteBuf)message2).readerIndex(), (OutputStream)out, ((ByteBuf)message2).readableBytes());
                        ((ByteBuf)message2).release();
                        writer.write("},\n");
                        writer.flush();
                    }
                    throw (Throwable)new RuntimeException("Unknown message type");
                }
                writer.write("]");
                writer.flush();
                out.close();
            }
            {
                this.$debugFile = string;
                this.$queue = concurrentLinkedQueue;
                this.$logger = messagingLogger;
            }
        });
        return logger;
    }
}

