/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.diagnostic.Logger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H$\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/io/DelegatingHttpRequestHandlerBase;", "Lorg/jetbrains/io/SimpleChannelInboundHandlerAdapter;", "Lio/netty/handler/codec/http/FullHttpRequest;", "()V", "exceptionCaught", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "cause", "", "messageReceived", "message", "process", "", "request", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "platform-impl"})
public abstract class DelegatingHttpRequestHandlerBase
extends SimpleChannelInboundHandlerAdapter<FullHttpRequest> {
    @Override
    protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull FullHttpRequest message2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Logger $receiver$iv = Logger.getInstance(BuiltInServer.class);
        Exception e$iv = null;
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "\n\nIN HTTP: " + message2 + "\n\n";
            logger.debug(string, (Throwable)e$iv);
        }
        if (!this.process(context, message2, new QueryStringDecoder(message2.uri()))) {
            Channel channel = context.channel();
            Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"context.channel()");
            Responses.send$default(HttpResponseStatus.NOT_FOUND, channel, (HttpRequest)message2, null, null, 12, null);
        }
    }

    protected abstract boolean process(@NotNull ChannelHandlerContext var1, @NotNull FullHttpRequest var2, @NotNull QueryStringDecoder var3);

    public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        NettyUtil.logAndClose(cause, Logger.getInstance(BuiltInServer.class), context.channel());
    }
}

