/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.generate.tostring.GenerateToStringClassFilter;
import org.jetbrains.java.generate.GenerateToStringActionHandler;
import org.jetbrains.java.generate.GenerateToStringConfigurable;
import org.jetbrains.java.generate.GenerateToStringContext;
import org.jetbrains.java.generate.GenerateToStringUtils;
import org.jetbrains.java.generate.GenerateToStringWorker;
import org.jetbrains.java.generate.GenerationUtil;
import org.jetbrains.java.generate.config.Config;
import org.jetbrains.java.generate.config.ConflictResolutionPolicy;
import org.jetbrains.java.generate.template.TemplateResource;
import org.jetbrains.java.generate.template.toString.ToStringTemplatesManager;
import org.jetbrains.java.generate.view.TemplatesPanel;

public class GenerateToStringActionHandlerImpl
implements GenerateToStringActionHandler,
CodeInsightActionHandler {
    private static final Logger logger = Logger.getInstance((String)"#GenerateToStringActionHandlerImpl");

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            GenerateToStringActionHandlerImpl.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GenerateToStringActionHandlerImpl.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            GenerateToStringActionHandlerImpl.$$$reportNull$$$0(2);
        }
        PsiClass clazz = GenerateToStringActionHandlerImpl.getSubjectClass(editor, file2);
        assert (clazz != null);
        GenerateToStringActionHandlerImpl.doExecuteAction(project2, clazz, editor);
    }

    @Override
    public void executeActionQuickFix(Project project2, PsiClass clazz) {
        GenerateToStringActionHandlerImpl.doExecuteAction(project2, clazz, null);
    }

    private static void doExecuteAction(@NotNull Project project2, @NotNull PsiClass clazz, Editor editor) {
        if (project2 == null) {
            GenerateToStringActionHandlerImpl.$$$reportNull$$$0(3);
        }
        if (clazz == null) {
            GenerateToStringActionHandlerImpl.$$$reportNull$$$0(4);
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{clazz})) {
            return;
        }
        logger.debug("+++ doExecuteAction - START +++");
        if (logger.isDebugEnabled()) {
            logger.debug("Current project " + project2.getName());
        }
        PsiElementClassMember[] dialogMembers = GenerateToStringActionHandlerImpl.buildMembersToShow(clazz);
        MemberChooserHeaderPanel header = new MemberChooserHeaderPanel(clazz);
        logger.debug("Displaying member chooser dialog");
        MemberChooser<PsiElementClassMember> chooser = new MemberChooser<PsiElementClassMember>(dialogMembers, true, true, project2, PsiUtil.isLanguageLevel5OrHigher((PsiElement)clazz), (JComponent)header){

            @Nullable
            protected String getHelpId() {
                return "editing.altInsert.tostring";
            }
        };
        chooser.setTitle("Generate toString()");
        chooser.setCopyJavadocVisible(false);
        chooser.selectElements(GenerateToStringActionHandlerImpl.getPreselection(clazz, dialogMembers));
        header.setChooser(chooser);
        chooser.show();
        if (0 == chooser.getExitCode()) {
            List<PsiMember> selectedMembers = GenerationUtil.convertClassMembersToPsiMembers(chooser.getSelectedElements());
            TemplateResource template = header.getSelectedTemplate();
            ToStringTemplatesManager.getInstance().setDefaultTemplate(template);
            if (template.isValidTemplate()) {
                GenerateToStringWorker worker = new GenerateToStringWorker(clazz, editor, chooser.isInsertOverrideAnnotation());
                ConflictResolutionPolicy resolutionPolicy = worker.exitsMethodDialog(template);
                try {
                    WriteAction.run(() -> worker.execute(selectedMembers, template, resolutionPolicy));
                }
                catch (Exception e) {
                    GenerationUtil.handleException(project2, e);
                }
            } else {
                HintManager.getInstance().showErrorHint(editor, "toString() template '" + template.getFileName() + "' is invalid");
            }
        }
        logger.debug("+++ doExecuteAction - END +++");
    }

    private static PsiElementClassMember[] getPreselection(@NotNull PsiClass clazz, PsiElementClassMember[] dialogMembers) {
        if (clazz == null) {
            GenerateToStringActionHandlerImpl.$$$reportNull$$$0(5);
        }
        return (PsiElementClassMember[])Arrays.stream(dialogMembers).filter(member -> {
            if (clazz == null) {
                GenerateToStringActionHandlerImpl.$$$reportNull$$$0(6);
            }
            return member.getElement().getContainingClass() == clazz;
        }).toArray(PsiElementClassMember[]::new);
    }

    public static void updateDialog(PsiClass clazz, MemberChooser<PsiElementClassMember> dialog2) {
        ClassMember[] members = GenerateToStringActionHandlerImpl.buildMembersToShow(clazz);
        dialog2.resetElements(members);
        dialog2.selectElements(GenerateToStringActionHandlerImpl.getPreselection(clazz, (PsiElementClassMember[])members));
    }

    public static PsiElementClassMember[] buildMembersToShow(PsiClass clazz) {
        PsiMethod[] filteredMethods;
        Config config = GenerateToStringContext.getConfig();
        PsiField[] filteredFields = GenerateToStringUtils.filterAvailableFields(clazz, true, config.getFilterPattern());
        if (logger.isDebugEnabled()) {
            logger.debug("Number of fields after filtering: " + filteredFields.length);
        }
        if (config.enableMethods) {
            filteredMethods = GenerateToStringUtils.filterAvailableMethods(clazz, config.getFilterPattern());
            if (logger.isDebugEnabled()) {
                logger.debug("Number of methods after filtering: " + filteredMethods.length);
            }
        } else {
            filteredMethods = PsiMethod.EMPTY_ARRAY;
        }
        return GenerationUtil.combineToClassMemberList(filteredFields, filteredMethods);
    }

    @Nullable
    private static PsiClass getSubjectClass(Editor editor, PsiFile file2) {
        if (file2 == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement context = file2.findElementAt(offset);
        if (context == null) {
            return null;
        }
        PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class, (boolean)false);
        if (clazz == null) {
            return null;
        }
        for (GenerateToStringClassFilter filter2 : (GenerateToStringClassFilter[])GenerateToStringClassFilter.EP_NAME.getExtensions()) {
            if (filter2.canGenerateToString(clazz)) continue;
            return null;
        }
        return clazz;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/java/generate/GenerateToStringActionHandlerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecuteAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreselection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getPreselection$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MemberChooserHeaderPanel
    extends JPanel {
        private MemberChooser<PsiElementClassMember> chooser;
        private final JComboBox<TemplateResource> comboBox;

        public void setChooser(MemberChooser chooser) {
            this.chooser = chooser;
        }

        public MemberChooserHeaderPanel(final PsiClass clazz) {
            super(new GridBagLayout());
            Collection<TemplateResource> templates = ToStringTemplatesManager.getInstance().getAllTemplates();
            Object[] all = templates.toArray(new TemplateResource[templates.size()]);
            JButton settingsButton = new JButton("Settings");
            settingsButton.setMnemonic(83);
            this.comboBox = new ComboBox(all);
            final JavaPsiFacade instance2 = JavaPsiFacade.getInstance((Project)clazz.getProject());
            final GlobalSearchScope resolveScope = clazz.getResolveScope();
            ListCellRendererWrapper<TemplateResource> renderer = new ListCellRendererWrapper<TemplateResource>(){

                public void customize(JList list2, TemplateResource value2, int index, boolean selected, boolean hasFocus) {
                    this.setText(value2.getName());
                    String className = value2.getClassName();
                    if (className != null && instance2.findClass(className, resolveScope) == null) {
                        this.setForeground((Color)JBColor.RED);
                    }
                }
            };
            this.comboBox.setRenderer((ListCellRenderer<TemplateResource>)renderer);
            settingsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final TemplatesPanel ui = new TemplatesPanel(clazz.getProject());
                    TabbedConfigurable composite = new TabbedConfigurable(){

                        @Override
                        @NotNull
                        protected List<Configurable> createConfigurables() {
                            ArrayList<Configurable> res = new ArrayList<Configurable>();
                            res.add(new GenerateToStringConfigurable(clazz.getProject()));
                            res.add((Configurable)ui);
                            ArrayList<Configurable> arrayList = res;
                            if (arrayList == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return arrayList;
                        }

                        public String getDisplayName() {
                            return "toString() Generation Settings";
                        }

                        public String getHelpTopic() {
                            return "editing.altInsert.tostring.settings";
                        }

                        @Override
                        public void apply() throws ConfigurationException {
                            super.apply();
                            GenerateToStringActionHandlerImpl.updateDialog(clazz, chooser);
                            comboBox.removeAllItems();
                            for (TemplateResource resource : ToStringTemplatesManager.getInstance().getAllTemplates()) {
                                comboBox.addItem(resource);
                            }
                            comboBox.setSelectedItem(ToStringTemplatesManager.getInstance().getDefaultTemplate());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/java/generate/GenerateToStringActionHandlerImpl$MemberChooserHeaderPanel$2$1", "createConfigurables"));
                        }
                    };
                    ShowSettingsUtil.getInstance().editConfigurable((Component)this, (Configurable)composite, () -> ui.selectItem(ToStringTemplatesManager.getInstance().getDefaultTemplate()));
                    composite.disposeUIResources();
                }
            });
            this.comboBox.setSelectedItem(ToStringTemplatesManager.getInstance().getDefaultTemplate());
            JLabel templatesLabel = new JLabel("Template: ");
            templatesLabel.setDisplayedMnemonic('T');
            templatesLabel.setLabelFor(this.comboBox);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 256;
            constraints.gridx = 0;
            this.add((Component)templatesLabel, constraints);
            constraints.gridx = 1;
            constraints.weightx = 1.0;
            constraints.fill = 2;
            this.add(this.comboBox, constraints);
            constraints.gridx = 2;
            constraints.weightx = 0.0;
            this.add((Component)settingsButton, constraints);
        }

        public TemplateResource getSelectedTemplate() {
            return (TemplateResource)this.comboBox.getSelectedItem();
        }
    }
}

