/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.jvm;

import com.jogamp.common.net.Uri;
import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.cache.TempJarCache;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jogamp.common.Debug;
import jogamp.common.os.PlatformPropsImpl;

public class JNILibLoaderBase {
    public static final boolean DEBUG;
    protected static final boolean PERF;
    private static final Object perfSync;
    private static long perfTotal;
    private static long perfCount;
    private static final HashSet<String> loaded;
    private static LoaderAction loaderAction;
    private static final String nativeJarTagPackage = "jogamp.nativetag";
    private static final Method customLoadLibraryMethod;

    public static boolean isLoaded(String string) {
        return loaded.contains(string);
    }

    public static void addLoaded(String string) {
        loaded.add(string);
        if (DEBUG) {
            String string2 = String.valueOf(string);
            System.err.println(string2.length() != 0 ? "JNILibLoaderBase: Loaded Native Library: ".concat(string2) : new String("JNILibLoaderBase: Loaded Native Library: "));
        }
    }

    public static void disableLoading() {
        JNILibLoaderBase.setLoadingAction(null);
    }

    public static void enableLoading() {
        JNILibLoaderBase.setLoadingAction(new DefaultAction());
    }

    public static synchronized void setLoadingAction(LoaderAction loaderAction) {
        JNILibLoaderBase.loaderAction = loaderAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean addNativeJarLibsImpl(Class<?> clazz, Uri uri, Uri.Encoded encoded, Uri.Encoded encoded2) throws IOException, SecurityException, URISyntaxException {
        boolean bl;
        long l;
        block24: {
            Object object;
            String string;
            Uri uri2;
            block22: {
                if (DEBUG) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("JNILibLoaderBase: addNativeJarLibsImpl(").append(PlatformPropsImpl.NEWLINE);
                    stringBuilder.append("  classFromJavaJar  = ").append(clazz).append(PlatformPropsImpl.NEWLINE);
                    stringBuilder.append("  classJarURI       = ").append(uri).append(PlatformPropsImpl.NEWLINE);
                    stringBuilder.append("  jarBasename       = ").append(encoded).append(PlatformPropsImpl.NEWLINE);
                    stringBuilder.append("  os.and.arch       = ").append(PlatformPropsImpl.os_and_arch).append(PlatformPropsImpl.NEWLINE);
                    stringBuilder.append("  nativeJarBasename = ").append(encoded2).append(PlatformPropsImpl.NEWLINE);
                    stringBuilder.append(")");
                    System.err.println(stringBuilder.toString());
                }
                l = PERF ? System.currentTimeMillis() : 0L;
                bl = false;
                Uri uri3 = uri.getContainedUri();
                if (null == uri3) {
                    String string2 = String.valueOf(uri);
                    throw new IllegalArgumentException(new StringBuilder(22 + String.valueOf(string2).length()).append("JarSubURI is null of: ").append(string2).toString());
                }
                uri2 = uri3.getDirectory();
                if (DEBUG) {
                    System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl: initial: %s -> %s%n", uri3, uri2);
                }
                string = String.format("natives/%s/", PlatformPropsImpl.os_and_arch);
                if (DEBUG) {
                    System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl: nativeLibraryPath: %s%n", string);
                }
                object = JarUtil.getJarFileUri(uri2.getEncoded().concat(encoded2));
                if (DEBUG) {
                    System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl: module: %s -> %s%n", encoded2, object);
                }
                try {
                    bl = TempJarCache.addNativeLibs(clazz, (Uri)object, string);
                }
                catch (Exception exception) {
                    if (!DEBUG) break block22;
                    System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl: Caught %s%n", exception.getMessage());
                    exception.printStackTrace();
                }
            }
            if (!bl) {
                Object object2;
                Object object3;
                block23: {
                    object = clazz.getClassLoader();
                    object3 = ((ClassLoader)object).getResource(string);
                    if (null != object3) {
                        object2 = JarUtil.getJarFileUri(uri2.getEncoded().concat(encoded));
                        try {
                            if (TempJarCache.addNativeLibs(clazz, (Uri)object2, string)) {
                                bl = true;
                                if (DEBUG) {
                                    System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl: fat: %s -> %s%n", encoded, object2);
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (!DEBUG) break block23;
                            System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl: Caught %s%n", exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                }
                if (!bl) {
                    object2 = clazz.getPackage().getName();
                    int n = ((String)object2).lastIndexOf(46);
                    object3 = 0 <= n ? ((String)object2).substring(n + 1) : object2;
                    object2 = PlatformPropsImpl.os_and_arch.replace('-', '.');
                    Object object4 = String.valueOf("jogamp.nativetag.");
                    String string3 = new StringBuilder(5 + String.valueOf(object4).length() + String.valueOf(object3).length() + String.valueOf(object2).length()).append((String)object4).append((String)object3).append(".").append((String)object2).append(".TAG").toString();
                    try {
                        if (DEBUG) {
                            System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl: ClassLoader/TAG: Locating module %s, os.and.arch %s: %s%n", object3, object2, string3);
                        }
                        object4 = JarUtil.getJarUri(string3, (ClassLoader)object);
                        if (DEBUG) {
                            System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl: ClassLoader/TAG: %s -> %s%n", string3, object4);
                        }
                        bl = TempJarCache.addNativeLibs(clazz, (Uri)object4, string);
                    }
                    catch (Exception exception) {
                        if (!DEBUG) break block24;
                        System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl: Caught %s%n", exception.getMessage());
                        exception.printStackTrace();
                    }
                }
            }
        }
        if (DEBUG || PERF) {
            long l2;
            long l3;
            long l4 = System.currentTimeMillis() - l;
            Object object = perfSync;
            synchronized (object) {
                l3 = perfCount + 1L;
                perfTotal = l2 = perfTotal + l4;
                perfCount = l3;
            }
            double d = (double)l2 / (double)l3;
            System.err.printf("JNILibLoaderBase: addNativeJarLibsImpl.X: %s / %s -> ok: %b; duration: now %d ms, total %d ms (count %d, avrg %.3f ms)%n", encoded, encoded2, bl, l4, l2, l3, d);
        }
        return bl;
    }

    public static final boolean addNativeJarLibsJoglCfg(Class<?>[] classArray) {
        return JNILibLoaderBase.addNativeJarLibs(classArray, "-all");
    }

    public static boolean addNativeJarLibs(Class<?>[] classArray, String string) {
        if (DEBUG) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("JNILibLoaderBase: addNativeJarLibs(").append(PlatformPropsImpl.NEWLINE);
            stringBuilder.append("  classesFromJavaJars   = ").append(Arrays.asList(classArray)).append(PlatformPropsImpl.NEWLINE);
            stringBuilder.append("  singleJarMarker       = ").append(string).append(PlatformPropsImpl.NEWLINE);
            stringBuilder.append(")");
            System.err.println(stringBuilder.toString());
        }
        boolean bl = false;
        if (TempJarCache.isInitialized()) {
            bl = JNILibLoaderBase.addNativeJarLibsWithTempJarCache(classArray, string);
        } else if (DEBUG) {
            System.err.println("JNILibLoaderBase: addNativeJarLibs0: disabled due to uninitialized TempJarCache");
        }
        return bl;
    }

    private static boolean addNativeJarLibsWithTempJarCache(Class<?>[] classArray, String string) {
        boolean bl;
        int n = 0;
        try {
            boolean bl2 = false;
            bl = true;
            for (int i = 0; i < classArray.length; ++i) {
                Uri.Encoded encoded;
                Class<?> clazz = classArray[i];
                if (clazz == null) continue;
                ClassLoader classLoader = clazz.getClassLoader();
                Uri uri = JarUtil.getJarUri(clazz.getName(), classLoader);
                Uri.Encoded encoded2 = JarUtil.getJarBasename(uri);
                if (encoded2 == null) continue;
                Uri.Encoded encoded3 = encoded2.substring(0, encoded2.indexOf(".jar"));
                if (DEBUG) {
                    System.err.printf("JNILibLoaderBase: jarBasename: %s%n", encoded3);
                }
                if (string != null && encoded3.indexOf(string) >= 0) {
                    bl2 = true;
                }
                if (bl = JNILibLoaderBase.addNativeJarLibsImpl(clazz, uri, encoded2, encoded = Uri.Encoded.cast(String.format("%s-natives-%s.jar", encoded3.get(), PlatformPropsImpl.os_and_arch)))) {
                    ++n;
                }
                if (!DEBUG || !bl2) continue;
                System.err.printf("JNILibLoaderBase: addNativeJarLibs0: done: %s%n", encoded3);
            }
        }
        catch (Exception exception) {
            System.err.printf("JNILibLoaderBase: Caught %s: %s%n", exception.getClass().getSimpleName(), exception.getMessage());
            if (DEBUG) {
                exception.printStackTrace();
            }
            bl = false;
        }
        if (DEBUG) {
            System.err.printf("JNILibLoaderBase: addNativeJarLibsWhenInitialized: count %d, ok %b%n", n, bl);
        }
        return bl;
    }

    protected static synchronized boolean loadLibrary(String string, boolean bl, ClassLoader classLoader) {
        if (loaderAction != null) {
            return loaderAction.loadLibrary(string, bl, classLoader);
        }
        return false;
    }

    protected static synchronized void loadLibrary(String string, String[] stringArray, boolean bl, ClassLoader classLoader) {
        if (loaderAction != null) {
            loaderAction.loadLibrary(string, stringArray, bl, classLoader);
        }
    }

    private static void loadLibraryInternal(String string, ClassLoader classLoader) {
        int n = 0;
        if (null != customLoadLibraryMethod && !string.equals("jawt")) {
            if (DEBUG) {
                System.err.println(new StringBuilder(39 + String.valueOf(string).length()).append("JNILibLoaderBase: customLoad(").append(string).append(") - mode 1").toString());
            }
            try {
                customLoadLibraryMethod.invoke(null, string);
                n = 1;
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (throwable instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)throwable).getTargetException();
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                String string2 = String.valueOf(string);
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError(string2.length() != 0 ? "can not load library ".concat(string2) : new String("can not load library ")).initCause(exception);
            }
        }
        String string3 = NativeLibrary.findLibrary(string, classLoader);
        if (DEBUG) {
            System.err.println(new StringBuilder(55 + String.valueOf(string).length() + String.valueOf(string3).length()).append("JNILibLoaderBase: loadLibraryInternal(").append(string).append("), TempJarCache: ").append(string3).toString());
        }
        if (null != string3) {
            if (DEBUG) {
                System.err.println(new StringBuilder(40 + String.valueOf(string3).length()).append("JNILibLoaderBase: System.load(").append(string3).append(") - mode 2").toString());
            }
            System.load(string3);
            n = 2;
        } else {
            if (DEBUG) {
                System.err.println(new StringBuilder(47 + String.valueOf(string).length()).append("JNILibLoaderBase: System.loadLibrary(").append(string).append(") - mode 3").toString());
            }
            try {
                System.loadLibrary(string);
                n = 3;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (DEBUG) {
                    String string4 = String.valueOf(unsatisfiedLinkError.getMessage());
                    System.err.println(string4.length() != 0 ? "ERROR (retry w/ enumLibPath) - ".concat(string4) : new String("ERROR (retry w/ enumLibPath) - "));
                }
                List<String> list = NativeLibrary.enumerateLibraryPaths(string, string, string, classLoader);
                Iterator<String> iterator = list.iterator();
                while (0 == n && iterator.hasNext()) {
                    String string5 = iterator.next();
                    if (DEBUG) {
                        System.err.println(new StringBuilder(40 + String.valueOf(string5).length()).append("JNILibLoaderBase: System.load(").append(string5).append(") - mode 4").toString());
                    }
                    try {
                        System.load(string5);
                        n = 4;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                        if (DEBUG) {
                            String string6 = String.valueOf(unsatisfiedLinkError2.getMessage());
                            System.err.println(string6.length() != 0 ? "n/a - ".concat(string6) : new String("n/a - "));
                        }
                        if (iterator.hasNext()) continue;
                        throw unsatisfiedLinkError2;
                    }
                }
            }
        }
        if (DEBUG) {
            int n2 = n;
            System.err.println(new StringBuilder(62 + String.valueOf(string).length()).append("JNILibLoaderBase: loadLibraryInternal(").append(string).append("): OK - mode ").append(n2).toString());
        }
    }

    static {
        Method method;
        Debug.initSingleton();
        DEBUG = Debug.debug("JNILibLoader");
        PERF = DEBUG || PropertyAccess.isPropertyDefined("jogamp.debug.JNILibLoader.Perf", true);
        perfSync = new Object();
        perfTotal = 0L;
        perfCount = 0L;
        loaded = new HashSet();
        loaderAction = new DefaultAction();
        customLoadLibraryMethod = method = AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                String string;
                boolean bl = PropertyAccess.getBooleanProperty("sun.jnlp.applet.launcher", true);
                Class<?> clazz = null;
                Method method = null;
                if (bl) {
                    try {
                        clazz = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.err.println("JNILibLoaderBase: <org.jdesktop.applet.util.JNLPAppletLauncher> not found, despite enabled property <sun.jnlp.applet.launcher>, JNLPAppletLauncher was probably used before");
                        System.setProperty("sun.jnlp.applet.launcher", Boolean.FALSE.toString());
                    }
                    catch (LinkageError linkageError) {
                        throw linkageError;
                    }
                    if (null != clazz) {
                        try {
                            method = clazz.getDeclaredMethod("loadLibrary", String.class);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            if (DEBUG) {
                                noSuchMethodException.printStackTrace();
                            }
                            clazz = null;
                        }
                    }
                }
                if (null == clazz && null != (string = PropertyAccess.getProperty("jnlp.launcher.class", false))) {
                    try {
                        clazz = Class.forName(string);
                        method = clazz.getDeclaredMethod("loadLibrary", String.class);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (DEBUG) {
                            classNotFoundException.printStackTrace();
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (DEBUG) {
                            noSuchMethodException.printStackTrace();
                        }
                        clazz = null;
                    }
                }
                return method;
            }
        });
    }

    private static class DefaultAction
    implements LoaderAction {
        private DefaultAction() {
        }

        @Override
        public boolean loadLibrary(String string, boolean bl, ClassLoader classLoader) {
            boolean bl2;
            block5: {
                bl2 = true;
                if (!JNILibLoaderBase.isLoaded(string)) {
                    try {
                        JNILibLoaderBase.loadLibraryInternal(string, classLoader);
                        JNILibLoaderBase.addLoaded(string);
                        if (DEBUG) {
                            String string2 = String.valueOf(string);
                            System.err.println(string2.length() != 0 ? "JNILibLoaderBase: loaded ".concat(string2) : new String("JNILibLoaderBase: loaded "));
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        bl2 = false;
                        if (DEBUG) {
                            unsatisfiedLinkError.printStackTrace();
                        }
                        if (bl || unsatisfiedLinkError.getMessage().indexOf("already loaded") >= 0) break block5;
                        throw unsatisfiedLinkError;
                    }
                }
            }
            return bl2;
        }

        @Override
        public void loadLibrary(String string, String[] stringArray, boolean bl, ClassLoader classLoader) {
            if (!JNILibLoaderBase.isLoaded(string)) {
                if (null != stringArray) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.loadLibrary(stringArray[i], bl, classLoader);
                    }
                }
                this.loadLibrary(string, false, classLoader);
            }
        }
    }

    public static interface LoaderAction {
        public boolean loadLibrary(String var1, boolean var2, ClassLoader var3);

        public void loadLibrary(String var1, String[] var2, boolean var3, ClassLoader var4);
    }
}

