/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions.service;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateInDirectoryActionBase;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteActionAware;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.xml.util.IncludedXmlTag;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.DevkitActionsUtil;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

abstract class NewServiceActionBase
extends CreateInDirectoryActionBase
implements WriteActionAware {
    NewServiceActionBase(String text, String description) {
        super(text, description, null);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public final void actionPerformed(AnActionEvent e) {
        IdeView view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        if (view == null) {
            return;
        }
        Project project = e.getProject();
        PsiDirectory dir = view.getOrChooseDirectory();
        if (dir == null) {
            return;
        }
        ServiceCreator serviceCreator = new ServiceCreator(dir, this.getInterfaceTemplateName(), this.getImplementationTemplateName(), this.getOnlyImplementationTemplateName(), this.getTagName());
        PsiClass[] createdClasses = this.invokeDialog(project, serviceCreator, dir);
        if (createdClasses == null) {
            return;
        }
        for (PsiClass createdClass : createdClasses) {
            view.selectElement((PsiElement)createdClass);
        }
    }

    @Nullable
    private PsiClass[] invokeDialog(Project project, ServiceCreator serviceCreator, PsiDirectory dir) {
        NewServiceDialog dialog = new NewServiceDialog(project, serviceCreator, dir);
        dialog.show();
        return serviceCreator.getCreatedClasses();
    }

    protected abstract String getTagName();

    protected abstract String getOnlyImplementationTemplateName();

    protected abstract String getInterfaceTemplateName();

    protected abstract String getImplementationTemplateName();

    protected abstract String getDialogTitle();

    static class ServiceCreator {
        private static final Logger LOG = Logger.getInstance(ServiceCreator.class);
        private static final String INTERFACE_NAME_PROPERTY = "INTERFACE_NAME";
        private static final String INTERFACE_PACKAGE_PROPERTY = "INTERFACE_PACKAGE_NAME";
        private final PsiDirectory myDirectory;
        private final String myServiceInterfaceTemplateName;
        private final String myServiceImplementationTemplateName;
        private final String myServiceOnlyImplementationTemplateName;
        private final String myTagName;
        private PsiClass[] createdClasses = null;

        ServiceCreator(PsiDirectory directory, String serviceInterfaceTemplateName, String serviceImplementationTemplateName, String serviceOnlyImplementationTemplateName, String tagName) {
            this.myDirectory = directory;
            this.myServiceInterfaceTemplateName = serviceInterfaceTemplateName;
            this.myServiceImplementationTemplateName = serviceImplementationTemplateName;
            this.myServiceOnlyImplementationTemplateName = serviceOnlyImplementationTemplateName;
            this.myTagName = tagName;
        }

        PsiClass[] getCreatedClasses() {
            return this.createdClasses;
        }

        boolean createInterfaceAndImplementation(String interfaceName, String implementationName, XmlFile pluginXml) {
            return this.doCreateService(() -> {
                PsiClass createdInterface = DevkitActionsUtil.createSingleClass(interfaceName, this.myServiceInterfaceTemplateName, this.myDirectory);
                String interfaceShortName = createdInterface.getName();
                String implementationDirRelativePackage = StringUtil.getPackageName((String)implementationName);
                String interfacePackage = implementationDirRelativePackage.isEmpty() ? "" : StringUtil.getPackageName((String)createdInterface.getQualifiedName());
                PsiClass createdImplementation = DevkitActionsUtil.createSingleClass(implementationName, this.myServiceImplementationTemplateName, this.myDirectory, ContainerUtil.stringMap((String[])new String[]{INTERFACE_NAME_PROPERTY, interfaceShortName, INTERFACE_PACKAGE_PROPERTY, interfacePackage}));
                this.patchPluginXml(createdInterface, createdImplementation, pluginXml);
                this.createdClasses = new PsiClass[]{createdInterface, createdImplementation};
                return true;
            });
        }

        boolean createOnlyImplementation(String onlyImplementationName, XmlFile pluginXml) {
            return this.doCreateService(() -> {
                PsiClass createdOnlyImplementation = DevkitActionsUtil.createSingleClass(onlyImplementationName, this.myServiceOnlyImplementationTemplateName, this.myDirectory);
                this.patchPluginXml(null, createdOnlyImplementation, pluginXml);
                this.createdClasses = new PsiClass[]{createdOnlyImplementation};
                return true;
            });
        }

        private boolean doCreateService(final Callable<Boolean> action) {
            RunResult result = new WriteCommandAction<Boolean>(this.getProject(), DevKitBundle.message("new.service.class.action.name", new Object[0]), new PsiFile[0]){

                protected void run(@NotNull Result<Boolean> result) throws Throwable {
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    result.setResult(action.call());
                }

                protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                    return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/devkit/actions/service/NewServiceActionBase$ServiceCreator$1", "run"));
                }
            }.execute();
            if (result.hasException()) {
                this.handleException(result.getThrowable());
                return false;
            }
            return (Boolean)result.getResultObject();
        }

        private void patchPluginXml(@Nullable PsiClass createdInterface, @NotNull PsiClass createdImplementation, XmlFile pluginXml) {
            if (createdImplementation == null) {
                ServiceCreator.$$$reportNull$$$0(0);
            }
            DescriptorUtil.checkPluginXmlsWritable(this.getProject(), pluginXml);
            DomFileElement fileElement = DomManager.getDomManager((Project)this.getProject()).getFileElement(pluginXml, IdeaPlugin.class);
            if (fileElement == null) {
                throw new IncorrectOperationException(DevKitBundle.message("error.cannot.process.plugin.xml", pluginXml));
            }
            IdeaPlugin ideaPlugin = (IdeaPlugin)fileElement.getRootElement();
            Extensions targetExtensions = ideaPlugin.getExtensions().stream().filter(extensions -> !(extensions instanceof IncludedXmlTag)).filter(extensions -> "com.intellij".equals(extensions.getDefaultExtensionNs().getStringValue())).findAny().orElseGet(() -> ideaPlugin.addExtensions());
            XmlTag serviceTag = targetExtensions.addExtension("com.intellij." + this.myTagName).getXmlTag();
            if (createdInterface != null) {
                serviceTag.setAttribute("serviceInterface", createdInterface.getQualifiedName());
            }
            serviceTag.setAttribute("serviceImplementation", createdImplementation.getQualifiedName());
        }

        private void handleException(Throwable t) {
            LOG.info(t);
            String errorMessage = ElementCreator.getErrorMessage((Throwable)t);
            Messages.showMessageDialog((Project)this.getProject(), (String)errorMessage, (String)DevKitBundle.message("error.cannot.create.service.class", new Object[0]), (Icon)Messages.getErrorIcon());
        }

        private Project getProject() {
            return this.myDirectory.getProject();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createdImplementation", "org/jetbrains/idea/devkit/actions/service/NewServiceActionBase$ServiceCreator", "patchPluginXml"));
        }
    }

    private class NewServiceDialog
    extends DialogWrapper {
        private final ServiceCreator myServiceCreator;
        private final PsiDirectory myDirectory;
        private JPanel myTopPanel;
        private JTextField myServiceNameTextField;
        private JCheckBox mySeparateServiceInterfaceCheckbox;
        private JTextField myServiceImplementationTextField;
        private JLabel myServiceNameLabel;
        private boolean myAdjusting;
        private boolean myNeedAdjust;

        NewServiceDialog(Project project, ServiceCreator serviceCreator, PsiDirectory directory) {
            super(project);
            this.myAdjusting = false;
            this.myNeedAdjust = true;
            this.$$$setupUI$$$();
            this.setOKActionEnabled(false);
            this.setTitle(NewServiceActionBase.this.getDialogTitle());
            this.myServiceCreator = serviceCreator;
            this.myDirectory = directory;
            this.mySeparateServiceInterfaceCheckbox.addActionListener(e -> {
                if (this.mySeparateServiceInterfaceCheckbox.isSelected()) {
                    this.myServiceImplementationTextField.setEnabled(true);
                    this.myServiceNameLabel.setText(DevKitBundle.message("new.service.dialog.interface", new Object[0]));
                } else {
                    this.myServiceImplementationTextField.setEnabled(false);
                    this.myServiceNameLabel.setText(DevKitBundle.message("new.service.dialog.class", new Object[0]));
                }
                this.adjustServiceImplementationTextField();
            });
            this.myServiceNameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    NewServiceDialog.this.setOKActionEnabled(NewServiceDialog.this.myServiceNameTextField.getText().length() > 0);
                    NewServiceDialog.this.adjustServiceImplementationTextField();
                }
            });
            this.myServiceImplementationTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    if (!NewServiceDialog.this.myAdjusting) {
                        NewServiceDialog.this.myNeedAdjust = false;
                    }
                }
            });
            this.init();
        }

        private void adjustServiceImplementationTextField() {
            if (!this.mySeparateServiceInterfaceCheckbox.isSelected()) {
                this.myAdjusting = true;
                this.myServiceImplementationTextField.setText("");
                this.myAdjusting = false;
            } else if (this.myNeedAdjust) {
                this.myAdjusting = true;
                this.myServiceImplementationTextField.setText("impl." + this.myServiceNameTextField.getText() + "Impl");
                this.myAdjusting = false;
            }
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myServiceNameTextField;
        }

        protected void doOKAction() {
            XmlFile pluginDescriptorToPatch = DevkitActionsUtil.choosePluginModuleDescriptor(this.myDirectory);
            if (pluginDescriptorToPatch == null) {
                return;
            }
            if (this.mySeparateServiceInterfaceCheckbox.isSelected()) {
                String serviceInterface = this.myServiceNameTextField.getText().trim();
                String serviceImplementation = this.myServiceImplementationTextField.getText().trim();
                if (this.checkInput(serviceInterface) && this.checkInput(serviceImplementation) && this.myServiceCreator.createInterfaceAndImplementation(serviceInterface, serviceImplementation, pluginDescriptorToPatch)) {
                    this.close(0);
                }
            } else {
                String serviceOnlyImplementation = this.myServiceNameTextField.getText().trim();
                if (this.checkInput(serviceOnlyImplementation) && this.myServiceCreator.createOnlyImplementation(serviceOnlyImplementation, pluginDescriptorToPatch)) {
                    this.close(0);
                }
            }
        }

        private boolean checkInput(String input) {
            if (StringUtil.isEmpty((String)input)) {
                Messages.showMessageDialog((Component)this.getContentPane(), (String)IdeBundle.message((String)"error.name.should.be.specified", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return false;
            }
            return true;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myTopPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JTextField jTextField;
            JCheckBox jCheckBox;
            JTextField jTextField2;
            JLabel jLabel;
            JPanel jPanel;
            this.myTopPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myServiceNameLabel = jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.service.dialog.interface"));
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myServiceNameTextField = jTextField2 = new JTextField();
            jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
            this.mySeparateServiceInterfaceCheckbox = jCheckBox = new JCheckBox();
            jCheckBox.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.service.dialog.separate"));
            jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            JLabel jLabel2 = new JLabel();
            this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/jetbrains/idea/devkit/DevKitBundle").getString("new.service.dialog.implementation"));
            jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myServiceImplementationTextField = jTextField = new JTextField();
            jTextField.setText("impl.");
            jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
            jLabel.setLabelFor(jTextField2);
            jLabel2.setLabelFor(jTextField);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myTopPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

