/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.reference.SoftReference;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.testAssistant.vfs.TestDataGroupVirtualFile;

public class TestDataGroupFileEditor
extends UserDataHolderBase
implements TextEditor {
    private WeakReference<Splitter> myComponent;
    private final TestDataGroupVirtualFile myFile;
    private final Project myProject;
    private final TextEditor myBeforeEditor;
    private final TextEditor myAfterEditor;

    public TestDataGroupFileEditor(Project project, TestDataGroupVirtualFile file) {
        this.myFile = file;
        this.myProject = project;
        this.myBeforeEditor = (TextEditor)TextEditorProvider.getInstance().createEditor(project, file.getBeforeFile());
        this.myAfterEditor = (TextEditor)TextEditorProvider.getInstance().createEditor(project, file.getAfterFile());
    }

    @NotNull
    public JComponent getComponent() {
        Splitter result = (Splitter)SoftReference.dereference(this.myComponent);
        if (result == null) {
            result = this.createComponent();
            this.myComponent = new WeakReference<Splitter>(result);
        }
        Splitter splitter = result;
        if (splitter == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(0);
        }
        return splitter;
    }

    private Splitter createComponent() {
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.5f, 0.1f, 0.9f);
        splitter.setFirstComponent(TestDataGroupFileEditor.wrapWithTitle(this.myFile.getBeforeFile().getName(), (FileEditor)this.myBeforeEditor));
        splitter.setSecondComponent(TestDataGroupFileEditor.wrapWithTitle(this.myFile.getAfterFile().getName(), (FileEditor)this.myAfterEditor));
        return splitter;
    }

    @NotNull
    public Editor getEditor() {
        if (SwingUtilities.isEventDispatchThread() && this.isBeforeEditorFocused()) {
            Editor editor = this.myBeforeEditor.getEditor();
            if (editor == null) {
                TestDataGroupFileEditor.$$$reportNull$$$0(1);
            }
            return editor;
        }
        Editor editor = this.myAfterEditor.getEditor();
        if (editor == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(2);
        }
        return editor;
    }

    private boolean isBeforeEditorFocused() {
        IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
        Component focusOwner = focusManager.getFocusOwner();
        Splitter splitter = (Splitter)this.getComponent();
        return UIUtil.isDescendingFrom((Component)focusOwner, (Component)splitter.getFirstComponent());
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(3);
        }
        return false;
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(4);
        }
    }

    private static JComponent wrapWithTitle(String name, FileEditor beforeEditor) {
        JPanel panel = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel(name, UIUtil.ComponentStyle.SMALL);
        label.setBorder((Border)JBUI.Borders.empty((int)1, (int)4, (int)2, (int)0));
        panel.add("North", (Component)label);
        panel.add("Center", beforeEditor.getComponent());
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        String string = this.myFile.getName();
        if (string == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(6);
        }
    }

    public boolean isModified() {
        return this.myBeforeEditor.isModified() || this.myAfterEditor.isModified();
    }

    public boolean isValid() {
        return this.myBeforeEditor.isValid() && this.myAfterEditor.isValid();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(7);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            TestDataGroupFileEditor.$$$reportNull$$$0(8);
        }
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        TextEditorProvider.getInstance().disposeEditor((FileEditor)this.myBeforeEditor);
        TextEditorProvider.getInstance().disposeEditor((FileEditor)this.myAfterEditor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataGroupFileEditor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataGroupFileEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canNavigateTo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

