/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceType;
import com.android.tools.klint.client.api.AndroidReference;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.client.api.UastLintUtils;
import com.android.tools.klint.detector.api.ConstantEvaluator;
import com.android.tools.klint.detector.api.JavaContext;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastUtils;

public class ResourceEvaluator {
    public static final ResourceType COLOR_INT_MARKER_TYPE = ResourceType.PUBLIC;
    public static final ResourceType PX_MARKER_TYPE = ResourceType.DECLARE_STYLEABLE;
    public static final String COLOR_INT_ANNOTATION = "android.support.annotation.ColorInt";
    public static final String PX_ANNOTATION = "android.support.annotation.Px";
    public static final String RES_SUFFIX = "Res";
    public static final String CLS_TYPED_ARRAY = "android.content.res.TypedArray";
    private final JavaContext mContext;
    private final JavaEvaluator mEvaluator;
    private boolean mAllowDereference = true;

    public ResourceEvaluator(JavaContext context) {
        this.mContext = context;
        this.mEvaluator = context.getEvaluator();
    }

    public ResourceEvaluator allowDereference(boolean allow) {
        this.mAllowDereference = allow;
        return this;
    }

    @Nullable
    public static ResourceUrl getResource(@NonNull JavaContext context, @NonNull PsiElement element) {
        return new ResourceEvaluator(context).getResource(element);
    }

    @Nullable
    public static ResourceUrl getResource(@NonNull JavaContext context, @NonNull UElement element) {
        return new ResourceEvaluator(context).getResource(element);
    }

    @Nullable
    public static EnumSet<ResourceType> getResourceTypes(@NonNull JavaContext context, @NonNull PsiElement element) {
        return new ResourceEvaluator(context).getResourceTypes(element);
    }

    @Nullable
    public static EnumSet<ResourceType> getResourceTypes(@NonNull JavaContext context, @NonNull UElement element) {
        return new ResourceEvaluator(context).getResourceTypes(element);
    }

    @Nullable
    public ResourceUrl getResource(@Nullable UElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof UIfExpression) {
            UIfExpression expression2 = (UIfExpression)element;
            Object known = ConstantEvaluator.evaluate(null, (UElement)expression2.getCondition());
            if (known == Boolean.TRUE && expression2.getThenExpression() != null) {
                return this.getResource((UElement)expression2.getThenExpression());
            }
            if (known == Boolean.FALSE && expression2.getElseExpression() != null) {
                return this.getResource((UElement)expression2.getElseExpression());
            }
        } else {
            UQualifiedReferenceExpression qualifiedExpression;
            UExpression selector2;
            if (element instanceof UParenthesizedExpression) {
                UParenthesizedExpression parenthesizedExpression = (UParenthesizedExpression)element;
                return this.getResource((UElement)parenthesizedExpression.getExpression());
            }
            if (this.mAllowDereference && element instanceof UQualifiedReferenceExpression && (selector2 = (qualifiedExpression = (UQualifiedReferenceExpression)element).getSelector()) instanceof UCallExpression) {
                UCallExpression call = (UCallExpression)selector2;
                PsiMethod function = call.resolve();
                PsiClass containingClass = UastUtils.getContainingClass((PsiElement)function);
                if (function != null && containingClass != null) {
                    List args;
                    String qualifiedName = containingClass.getQualifiedName();
                    String name = call.getMethodName();
                    if (("android.content.res.Resources".equals(qualifiedName) || "android.content.Context".equals(qualifiedName) || "android.app.Fragment".equals(qualifiedName) || "android.support.v4.app.Fragment".equals(qualifiedName) || CLS_TYPED_ARRAY.equals(qualifiedName)) && name != null && name.startsWith("get") && !(args = call.getValueArguments()).isEmpty()) {
                        return this.getResource((UElement)args.get(0));
                    }
                }
            }
        }
        if (element instanceof UReferenceExpression) {
            ResourceUrl url = ResourceEvaluator.getResourceConstant(element);
            if (url != null) {
                return url;
            }
            PsiElement resolved = ((UReferenceExpression)element).resolve();
            if (resolved instanceof PsiVariable) {
                PsiVariable variable2 = (PsiVariable)resolved;
                UExpression lastAssignment = UastLintUtils.findLastAssignment(variable2, element, this.mContext);
                if (lastAssignment != null) {
                    return this.getResource((UElement)lastAssignment);
                }
                return null;
            }
        }
        return null;
    }

    @Nullable
    public ResourceUrl getResource(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PsiConditionalExpression) {
            PsiConditionalExpression expression2 = (PsiConditionalExpression)element;
            Object known = ConstantEvaluator.evaluate(null, (PsiElement)expression2.getCondition());
            if (known == Boolean.TRUE && expression2.getThenExpression() != null) {
                return this.getResource((PsiElement)expression2.getThenExpression());
            }
            if (known == Boolean.FALSE && expression2.getElseExpression() != null) {
                return this.getResource((PsiElement)expression2.getElseExpression());
            }
        } else {
            if (element instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)element;
                return this.getResource((PsiElement)parenthesizedExpression.getExpression());
            }
            if (element instanceof PsiMethodCallExpression && this.mAllowDereference) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)element;
                PsiReferenceExpression expression3 = call.getMethodExpression();
                PsiMethod method = call.resolveMethod();
                if (method != null && method.getContainingClass() != null) {
                    PsiExpression[] args;
                    String qualifiedName = method.getContainingClass().getQualifiedName();
                    String name = expression3.getReferenceName();
                    if (("android.content.res.Resources".equals(qualifiedName) || "android.content.Context".equals(qualifiedName) || "android.app.Fragment".equals(qualifiedName) || "android.support.v4.app.Fragment".equals(qualifiedName) || CLS_TYPED_ARRAY.equals(qualifiedName)) && name != null && name.startsWith("get") && (args = call.getArgumentList().getExpressions()).length > 0) {
                        return this.getResource((PsiElement)args[0]);
                    }
                }
            } else if (element instanceof PsiReference) {
                ResourceUrl url = ResourceEvaluator.getResourceConstant(element);
                if (url != null) {
                    return url;
                }
                PsiElement resolved = ((PsiReference)element).resolve();
                if (resolved instanceof PsiField) {
                    url = ResourceEvaluator.getResourceConstant(resolved);
                    if (url != null) {
                        return url;
                    }
                    PsiField field = (PsiField)resolved;
                    if (field.getInitializer() != null) {
                        return this.getResource((PsiElement)field.getInitializer());
                    }
                    return null;
                }
                if (resolved instanceof PsiLocalVariable) {
                    PsiLocalVariable variable2 = (PsiLocalVariable)resolved;
                    PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class, (boolean)false);
                    if (statement != null) {
                        PsiStatement prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
                        String targetName = variable2.getName();
                        if (targetName == null) {
                            return null;
                        }
                        while (prev != null) {
                            PsiReferenceExpression reference;
                            PsiAssignmentExpression assign;
                            PsiExpression lhs;
                            PsiExpression expression4;
                            if (prev instanceof PsiDeclarationStatement) {
                                PsiDeclarationStatement prevStatement = (PsiDeclarationStatement)prev;
                                for (PsiElement e : prevStatement.getDeclaredElements()) {
                                    if (!variable2.equals(e)) continue;
                                    return this.getResource((PsiElement)variable2.getInitializer());
                                }
                            } else if (prev instanceof PsiExpressionStatement && (expression4 = ((PsiExpressionStatement)prev).getExpression()) instanceof PsiAssignmentExpression && (lhs = (assign = (PsiAssignmentExpression)expression4).getLExpression()) instanceof PsiReferenceExpression && targetName.equals((reference = (PsiReferenceExpression)lhs).getReferenceName()) && reference.getQualifier() == null) {
                                return this.getResource((PsiElement)assign.getRExpression());
                            }
                            prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiStatement.class);
                        }
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    public EnumSet<ResourceType> getResourceTypes(@Nullable UElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof UIfExpression) {
            UIfExpression expression2 = (UIfExpression)element;
            Object known = ConstantEvaluator.evaluate(null, (UElement)expression2.getCondition());
            if (known == Boolean.TRUE && expression2.getThenExpression() != null) {
                return this.getResourceTypes((UElement)expression2.getThenExpression());
            }
            if (known == Boolean.FALSE && expression2.getElseExpression() != null) {
                return this.getResourceTypes((UElement)expression2.getElseExpression());
            }
            EnumSet<ResourceType> left = this.getResourceTypes((UElement)expression2.getThenExpression());
            EnumSet<ResourceType> right = this.getResourceTypes((UElement)expression2.getElseExpression());
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            EnumSet<ResourceType> copy = EnumSet.copyOf(left);
            copy.addAll(right);
            return copy;
        }
        if (element instanceof UParenthesizedExpression) {
            UParenthesizedExpression parenthesizedExpression = (UParenthesizedExpression)element;
            return this.getResourceTypes((UElement)parenthesizedExpression.getExpression());
        }
        if (element instanceof UQualifiedReferenceExpression && this.mAllowDereference || element instanceof UCallExpression) {
            UElement probablyCallExpression = element;
            if (element instanceof UQualifiedReferenceExpression) {
                UQualifiedReferenceExpression qualifiedExpression = (UQualifiedReferenceExpression)element;
                probablyCallExpression = qualifiedExpression.getSelector();
            }
            if (probablyCallExpression instanceof UCallExpression) {
                UCallExpression call = (UCallExpression)probablyCallExpression;
                PsiMethod method = call.resolve();
                PsiClass containingClass = UastUtils.getContainingClass((PsiElement)method);
                if (method != null && containingClass != null) {
                    List args;
                    EnumSet<ResourceType> types = this.getTypesFromAnnotations((PsiModifierListOwner)method);
                    if (types != null) {
                        return types;
                    }
                    String qualifiedName = containingClass.getQualifiedName();
                    String name = call.getMethodName();
                    if (("android.content.res.Resources".equals(qualifiedName) || "android.content.Context".equals(qualifiedName) || "android.app.Fragment".equals(qualifiedName) || "android.support.v4.app.Fragment".equals(qualifiedName) || CLS_TYPED_ARRAY.equals(qualifiedName)) && name != null && name.startsWith("get") && !(args = call.getValueArguments()).isEmpty() && (types = this.getResourceTypes((UElement)args.get(0))) != null) {
                        return types;
                    }
                }
            }
        }
        if (element instanceof UReferenceExpression) {
            ResourceUrl url = ResourceEvaluator.getResourceConstant(element);
            if (url != null) {
                return EnumSet.of(url.type);
            }
            PsiElement resolved = ((UReferenceExpression)element).resolve();
            if (resolved instanceof PsiVariable) {
                PsiVariable variable2 = (PsiVariable)resolved;
                UExpression lastAssignment = UastLintUtils.findLastAssignment(variable2, element, this.mContext);
                if (lastAssignment != null) {
                    return this.getResourceTypes((UElement)lastAssignment);
                }
                return null;
            }
        }
        return null;
    }

    @Nullable
    public EnumSet<ResourceType> getResourceTypes(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PsiConditionalExpression) {
            PsiConditionalExpression expression2 = (PsiConditionalExpression)element;
            Object known = ConstantEvaluator.evaluate(null, (PsiElement)expression2.getCondition());
            if (known == Boolean.TRUE && expression2.getThenExpression() != null) {
                return this.getResourceTypes((PsiElement)expression2.getThenExpression());
            }
            if (known == Boolean.FALSE && expression2.getElseExpression() != null) {
                return this.getResourceTypes((PsiElement)expression2.getElseExpression());
            }
            EnumSet<ResourceType> left = this.getResourceTypes((PsiElement)expression2.getThenExpression());
            EnumSet<ResourceType> right = this.getResourceTypes((PsiElement)expression2.getElseExpression());
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            EnumSet<ResourceType> copy = EnumSet.copyOf(left);
            copy.addAll(right);
            return copy;
        }
        if (element instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)element;
            return this.getResourceTypes((PsiElement)parenthesizedExpression.getExpression());
        }
        if (element instanceof PsiMethodCallExpression && this.mAllowDereference) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)element;
            PsiReferenceExpression expression3 = call.getMethodExpression();
            PsiMethod method = call.resolveMethod();
            if (method != null && method.getContainingClass() != null) {
                PsiExpression[] args;
                EnumSet<ResourceType> types = this.getTypesFromAnnotations((PsiModifierListOwner)method);
                if (types != null) {
                    return types;
                }
                String qualifiedName = method.getContainingClass().getQualifiedName();
                String name = expression3.getReferenceName();
                if (("android.content.res.Resources".equals(qualifiedName) || "android.content.Context".equals(qualifiedName) || "android.app.Fragment".equals(qualifiedName) || "android.support.v4.app.Fragment".equals(qualifiedName) || CLS_TYPED_ARRAY.equals(qualifiedName)) && name != null && name.startsWith("get") && (args = call.getArgumentList().getExpressions()).length > 0 && (types = this.getResourceTypes((PsiElement)args[0])) != null) {
                    return types;
                }
            }
        } else if (element instanceof PsiReference) {
            ResourceUrl url = ResourceEvaluator.getResourceConstant(element);
            if (url != null) {
                return EnumSet.of(url.type);
            }
            PsiElement resolved = ((PsiReference)element).resolve();
            if (resolved instanceof PsiField) {
                url = ResourceEvaluator.getResourceConstant(resolved);
                if (url != null) {
                    return EnumSet.of(url.type);
                }
                PsiField field = (PsiField)resolved;
                if (field.getInitializer() != null) {
                    return this.getResourceTypes((PsiElement)field.getInitializer());
                }
                return null;
            }
            if (resolved instanceof PsiParameter) {
                return this.getTypesFromAnnotations((PsiModifierListOwner)((PsiParameter)resolved));
            }
            if (resolved instanceof PsiLocalVariable) {
                PsiLocalVariable variable2 = (PsiLocalVariable)resolved;
                PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class, (boolean)false);
                if (statement != null) {
                    PsiStatement prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
                    String targetName = variable2.getName();
                    if (targetName == null) {
                        return null;
                    }
                    while (prev != null) {
                        PsiReferenceExpression reference;
                        PsiAssignmentExpression assign;
                        PsiExpression lhs;
                        PsiExpression expression4;
                        if (prev instanceof PsiDeclarationStatement) {
                            PsiDeclarationStatement prevStatement = (PsiDeclarationStatement)prev;
                            for (PsiElement e : prevStatement.getDeclaredElements()) {
                                if (!variable2.equals(e)) continue;
                                return this.getResourceTypes((PsiElement)variable2.getInitializer());
                            }
                        } else if (prev instanceof PsiExpressionStatement && (expression4 = ((PsiExpressionStatement)prev).getExpression()) instanceof PsiAssignmentExpression && (lhs = (assign = (PsiAssignmentExpression)expression4).getLExpression()) instanceof PsiReferenceExpression && targetName.equals((reference = (PsiReferenceExpression)lhs).getReferenceName()) && reference.getQualifier() == null) {
                            return this.getResourceTypes((PsiElement)assign.getRExpression());
                        }
                        prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiStatement.class);
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private EnumSet<ResourceType> getTypesFromAnnotations(PsiModifierListOwner owner) {
        if (this.mEvaluator == null) {
            return null;
        }
        for (PsiAnnotation annotation : this.mEvaluator.getAllAnnotations(owner)) {
            String signature = annotation.getQualifiedName();
            if (signature == null) continue;
            if (signature.equals(COLOR_INT_ANNOTATION)) {
                return EnumSet.of(COLOR_INT_MARKER_TYPE);
            }
            if (signature.equals(PX_ANNOTATION)) {
                return EnumSet.of(PX_MARKER_TYPE);
            }
            if (!signature.endsWith(RES_SUFFIX) || !signature.startsWith("android.support.annotation.")) continue;
            String typeString = signature.substring("android.support.annotation.".length(), signature.length() - RES_SUFFIX.length()).toLowerCase(Locale.US);
            ResourceType type2 = ResourceType.getEnum((String)typeString);
            if (type2 != null) {
                return EnumSet.of(type2);
            }
            if (!typeString.equals("any")) continue;
            return ResourceEvaluator.getAnyRes();
        }
        return null;
    }

    @Nullable
    public static ResourceUrl getResourceConstant(@NonNull PsiElement node) {
        PsiClass rClass;
        PsiField field;
        PsiClass typeClass;
        if (node instanceof PsiReferenceExpression) {
            PsiReferenceExpression reference;
            PsiReferenceExpression select;
            PsiReferenceExpression expression2 = (PsiReferenceExpression)node;
            if (expression2.getQualifier() instanceof PsiReferenceExpression && (select = (PsiReferenceExpression)expression2.getQualifier()).getQualifier() instanceof PsiReferenceExpression && "R".equals((reference = (PsiReferenceExpression)select.getQualifier()).getReferenceName())) {
                String typeName = select.getReferenceName();
                String name = expression2.getReferenceName();
                ResourceType type2 = ResourceType.getEnum((String)typeName);
                if (type2 != null && name != null) {
                    boolean isFramework = reference.getQualifier() instanceof PsiReferenceExpression && "android".equals(((PsiReferenceExpression)reference.getQualifier()).getReferenceName());
                    return ResourceUrl.create((ResourceType)type2, (String)name, (boolean)isFramework, (boolean)false);
                }
            }
        } else if (node instanceof PsiField && (typeClass = (field = (PsiField)node).getContainingClass()) != null && (rClass = typeClass.getContainingClass()) != null && "R".equals(rClass.getName())) {
            String name = field.getName();
            ResourceType type3 = ResourceType.getEnum((String)typeClass.getName());
            if (type3 != null && name != null) {
                String qualifiedName = rClass.getQualifiedName();
                boolean isFramework = qualifiedName != null && qualifiedName.startsWith("android.");
                return ResourceUrl.create((ResourceType)type3, (String)name, (boolean)isFramework, (boolean)false);
            }
        }
        return null;
    }

    @Nullable
    public static ResourceUrl getResourceConstant(@NonNull UElement node) {
        AndroidReference androidReference = UastLintUtils.toAndroidReferenceViaResolve(node);
        if (androidReference == null) {
            return null;
        }
        String name = androidReference.getName();
        ResourceType type2 = androidReference.getType();
        boolean isFramework = androidReference.getPackage().equals("android");
        return ResourceUrl.create((ResourceType)type2, (String)name, (boolean)isFramework, (boolean)false);
    }

    private static EnumSet<ResourceType> getAnyRes() {
        EnumSet<ResourceType> types = EnumSet.allOf(ResourceType.class);
        types.remove(COLOR_INT_MARKER_TYPE);
        types.remove(PX_MARKER_TYPE);
        return types;
    }
}

