/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions.license;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class LicensesLocator {
    private final Path myIdeHome;
    private final boolean myOnMac;
    private final List<String> myGooglePlugins;

    public LicensesLocator(@NotNull Path ideHome, boolean isMacLayout) {
        if (ideHome == null) {
            LicensesLocator.$$$reportNull$$$0(0);
        }
        this.myGooglePlugins = Arrays.asList("android", "firebase", "firebase-testing", "google-appindexing", "google-cloud-tools", "google-cloud-tools-core", "google-login", "google-services", "test-recorder");
        this.myIdeHome = ideHome;
        this.myOnMac = isMacLayout;
    }

    @NotNull
    public List<Path> getLicenseFiles() {
        ArrayList<Path> licenses = new ArrayList<Path>();
        licenses.addAll(this.getIdeLicenseAndNotice());
        licenses.addAll(this.getIdeWideThirdPartyLibLicenses());
        for (String plugin : this.myGooglePlugins) {
            licenses.addAll(this.getThirdPartyLibrariesForPlugin(plugin));
        }
        ArrayList<Path> arrayList = licenses;
        if (arrayList == null) {
            LicensesLocator.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private List<Path> getIdeLicenseAndNotice() {
        Path root = this.myIdeHome;
        if (this.myOnMac) {
            root = root.resolve("Resources");
        }
        ImmutableList immutableList = ImmutableList.of((Object)root.resolve("NOTICE.txt"), (Object)root.resolve("LICENSE.txt"));
        if (immutableList == null) {
            LicensesLocator.$$$reportNull$$$0(2);
        }
        return immutableList;
    }

    @NotNull
    private List<Path> getIdeWideThirdPartyLibLicenses() {
        List<Path> list;
        try {
            list = Files.list(this.myIdeHome.resolve("license")).collect(Collectors.toList());
        }
        catch (IOException e) {
            Logger.getInstance(LicensesLocator.class).error((Throwable)e);
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                LicensesLocator.$$$reportNull$$$0(4);
            }
            return immutableList;
        }
        if (list == null) {
            LicensesLocator.$$$reportNull$$$0(3);
        }
        return list;
    }

    private List<Path> getThirdPartyLibrariesForPlugin(String plugin) {
        Path pluginLicenseFolder = Paths.get(this.myIdeHome.toString(), "plugins", plugin, "lib", "licenses");
        if (Files.isDirectory(pluginLicenseFolder, new LinkOption[0])) {
            try {
                List<Path> paths = Files.list(pluginLicenseFolder).collect(Collectors.toList());
                paths.sort(Comparator.naturalOrder());
                return paths;
            }
            catch (IOException e) {
                Logger.getInstance(LicensesLocator.class).warn((Throwable)e);
                return ImmutableList.of();
            }
        }
        return ImmutableList.of();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideHome";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/actions/license/LicensesLocator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/actions/license/LicensesLocator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLicenseFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeLicenseAndNotice";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeWideThirdPartyLibLicenses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

