/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.dex;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.idea.apk.viewer.ApkFileEditorComponent;
import com.android.tools.idea.apk.viewer.dex.DexParser;
import com.android.tools.idea.apk.viewer.dex.PackageTreeNode;
import com.android.tools.idea.ddms.EdtExecutor;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class DexFileViewer
implements ApkFileEditorComponent {
    private final Disposable myDisposable;
    private final JBLoadingPanel myLoadingPanel;
    private final Tree myTree;

    public DexFileViewer(@NotNull VirtualFile dexFile) {
        if (dexFile == null) {
            DexFileViewer.$$$reportNull$$$0(0);
        }
        this.myDisposable = new Disposable(){

            public void dispose() {
            }
        };
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.myDisposable);
        this.myLoadingPanel.startLoading();
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)new LoadingNode());
        this.myTree = new Tree((TreeModel)treeModel);
        this.myTree.setRootVisible(true);
        this.myTree.setShowsRootHandles(true);
        new TreeSpeedSearch(this.myTree, path -> {
            Object o = path.getLastPathComponent();
            if (!(o instanceof PackageTreeNode)) {
                return "";
            }
            PackageTreeNode node = (PackageTreeNode)o;
            return node.getName();
        });
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Class").setPreferredWidth(500).setHeaderAlignment(2).setRenderer((ColoredTreeCellRenderer)new PackageTreeNodeRenderer())).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Defined Methods").setPreferredWidth(100).setHeaderAlignment(2).setRenderer((ColoredTreeCellRenderer)new MethodCountRenderer(true))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Referenced Methods").setPreferredWidth(100).setHeaderAlignment(2).setRenderer((ColoredTreeCellRenderer)new MethodCountRenderer(false)));
        JComponent columnTree = builder.build();
        this.myLoadingPanel.add((Component)columnTree, (Object)"Center");
        DexParser dexParser = new DexParser(MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE), dexFile);
        ListenableFuture<PackageTreeNode> future = dexParser.constructMethodRefCountTree();
        Futures.addCallback(future, (FutureCallback)new FutureCallback<PackageTreeNode>(){

            public void onSuccess(PackageTreeNode result) {
                DexFileViewer.this.myTree.setModel((TreeModel)new DefaultTreeModel(result));
                DexFileViewer.this.myTree.setRootVisible(false);
                DexFileViewer.this.myLoadingPanel.stopLoading();
            }

            public void onFailure(Throwable t) {
            }
        }, (Executor)EdtExecutor.INSTANCE);
        final SimpleColoredComponent titleComponent = new SimpleColoredComponent();
        Futures.addCallback(dexParser.getDexFileStats(), (FutureCallback)new FutureCallback<DexParser.DexFileStats>(){

            public void onSuccess(DexParser.DexFileStats result) {
                titleComponent.setIcon(AllIcons.General.Information);
                titleComponent.append("This dex file defines ");
                titleComponent.append(Integer.toString(result.classCount), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                titleComponent.append(" classes with ");
                titleComponent.append(Integer.toString(result.definedMethodCount), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                titleComponent.append(" methods, and references ");
                titleComponent.append(Integer.toString(result.referencedMethodCount), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                titleComponent.append(" methods.");
            }

            public void onFailure(Throwable t) {
            }
        });
        this.myLoadingPanel.add((Component)titleComponent, (Object)"North");
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JBLoadingPanel jBLoadingPanel = this.myLoadingPanel;
        if (jBLoadingPanel == null) {
            DexFileViewer.$$$reportNull$$$0(1);
        }
        return jBLoadingPanel;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/viewer/dex/DexFileViewer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/viewer/dex/DexFileViewer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MethodCountRenderer
    extends ColoredTreeCellRenderer {
        private final boolean myShowDefinedCount;

        public MethodCountRenderer(boolean showDefinedCount) {
            this.myShowDefinedCount = showDefinedCount;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MethodCountRenderer.$$$reportNull$$$0(0);
            }
            if (value instanceof PackageTreeNode) {
                PackageTreeNode node = (PackageTreeNode)value;
                int count = this.myShowDefinedCount ? node.getDefinedMethodsCount() : node.getMethodRefCount();
                this.append(Integer.toString(count));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/apk/viewer/dex/DexFileViewer$MethodCountRenderer", "customizeCellRenderer"));
        }
    }

    private static class PackageTreeNodeRenderer
    extends ColoredTreeCellRenderer {
        private PackageTreeNodeRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                PackageTreeNodeRenderer.$$$reportNull$$$0(0);
            }
            if (!(value instanceof PackageTreeNode)) {
                return;
            }
            PackageTreeNode node = (PackageTreeNode)value;
            this.append(node.getName());
            switch (node.getNodeType()) {
                case PACKAGE: {
                    this.setIcon(PlatformIcons.PACKAGE_ICON);
                    break;
                }
                case CLASS: {
                    this.setIcon(PlatformIcons.CLASS_ICON);
                    break;
                }
                case METHOD: {
                    this.setIcon(PlatformIcons.METHOD_ICON);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/apk/viewer/dex/DexFileViewer$PackageTreeNodeRenderer", "customizeCellRenderer"));
        }
    }
}

