/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.avdmanager.EmulatorProcessHandler;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmulatorRunner {
    private final GeneralCommandLine myCommandLine;
    private ProcessHandler myProcessHandler;
    private final List<ProcessListener> myExtraListeners;

    public EmulatorRunner(@NotNull GeneralCommandLine commandLine, @Nullable AvdInfo avdInfo) {
        if (commandLine == null) {
            EmulatorRunner.$$$reportNull$$$0(0);
        }
        this.myExtraListeners = new ArrayList<ProcessListener>();
        this.myCommandLine = commandLine;
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.DEPLOYMENT).setKind(AndroidStudioEvent.EventKind.DEPLOYMENT_TO_EMULATOR);
        if (avdInfo != null) {
            event.setDeviceInfo(DeviceInfo.newBuilder().setCpuAbi(CommonMetricsData.applicationBinaryInterfaceFromString((String)avdInfo.getAbiType())).setBuildApiLevelFull(avdInfo.getAndroidVersion().toString()));
        }
        UsageTracker.getInstance().log(event);
    }

    public ProcessHandler start() throws ExecutionException {
        Process process = this.myCommandLine.createProcess();
        this.myProcessHandler = new EmulatorProcessHandler(process, this.myCommandLine);
        this.myExtraListeners.forEach(arg_0 -> ((ProcessHandler)this.myProcessHandler).addProcessListener(arg_0));
        return this.myProcessHandler;
    }

    public void addProcessListener(@NotNull ProcessListener listener) {
        if (listener == null) {
            EmulatorRunner.$$$reportNull$$$0(1);
        }
        if (this.myProcessHandler != null) {
            this.myProcessHandler.addProcessListener(listener);
        } else {
            this.myExtraListeners.add(listener);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/avdmanager/EmulatorRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addProcessListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ProcessOutputCollector
    extends ProcessAdapter {
        private final StringBuilder sb = new StringBuilder();

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (event == null) {
                ProcessOutputCollector.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                ProcessOutputCollector.$$$reportNull$$$0(1);
            }
            this.sb.append(event.getText());
        }

        public String getText() {
            return this.sb.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputType";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/avdmanager/EmulatorRunner$ProcessOutputCollector";
            objectArray[2] = "onTextAvailable";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

