/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.intellij.ide.GeneratedSourceFileChangeTracker;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratedFileNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.generated.file.ro");
    private final Project myProject;
    private final GeneratedSourceFileChangeTracker myGeneratedSourceFileChangeTracker;

    public GeneratedFileNotificationProvider(Project project, GeneratedSourceFileChangeTracker changeTracker) {
        this.myProject = project;
        this.myGeneratedSourceFileChangeTracker = changeTracker;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            GeneratedFileNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        AndroidModuleModel androidModel;
        if (file == null) {
            GeneratedFileNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            GeneratedFileNotificationProvider.$$$reportNull$$$0(2);
        }
        if ((androidModel = GradleProjectInfo.getInstance(this.myProject).findAndroidModelInModule(file)) == null) {
            return null;
        }
        VirtualFile buildFolder = VfsUtil.findFileByIoFile((File)androidModel.getAndroidProject().getBuildFolder(), (boolean)false);
        if (buildFolder == null || !buildFolder.isDirectory()) {
            return null;
        }
        if (VfsUtilCore.isAncestor((VirtualFile)buildFolder, (VirtualFile)file, (boolean)false)) {
            if (this.myGeneratedSourceFileChangeTracker.isEditedGeneratedFile(file)) {
                return null;
            }
            VirtualFile explodedBundled = buildFolder.findChild("exploded-aar");
            boolean inAar = explodedBundled != null && VfsUtilCore.isAncestor((VirtualFile)explodedBundled, (VirtualFile)file, (boolean)true);
            String text = inAar ? "Resource files inside Android library archive files (.aar) should not be edited" : "Files under the build folder are generated and should not be edited.";
            EditorNotificationPanel panel = new EditorNotificationPanel();
            panel.setText(text);
            return panel;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/GeneratedFileNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/GeneratedFileNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

