/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hierarchyview.model;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.HandleViewDebug;
import com.android.tools.idea.editors.hierarchyview.model.ViewNode;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientWindow {
    public final String title;
    public final Client client;

    public ClientWindow(@NotNull String title, @NotNull Client client) {
        if (title == null) {
            ClientWindow.$$$reportNull$$$0(0);
        }
        if (client == null) {
            ClientWindow.$$$reportNull$$$0(1);
        }
        this.title = title;
        this.client = client;
    }

    @NotNull
    public String getDisplayName() {
        String appName = this.client.getClientData().getClientDescription();
        ArrayList parts = Lists.newArrayList((Object[])this.title.split("/"));
        parts.remove("");
        parts.remove(appName);
        if (parts.isEmpty()) {
            String string = appName;
            if (string == null) {
                ClientWindow.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = (String)parts.get(parts.size() > 2 ? 1 : 0);
        if (string == null) {
            ClientWindow.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public byte[] loadWindowData(long timeout, TimeUnit unit) {
        CaptureByteArrayHandler handler = new CaptureByteArrayHandler(HandleViewDebug.CHUNK_VURT);
        try {
            HandleViewDebug.dumpViewHierarchy((Client)this.client, (String)this.title, (boolean)false, (boolean)true, (HandleViewDebug.ViewDumpHandler)handler);
        }
        catch (IOException e) {
            return null;
        }
        return handler.getData(timeout, unit);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public byte[] loadViewImage(@NotNull ViewNode node, long timeout, TimeUnit timeUnit) {
        void unit;
        if (node == null) {
            ClientWindow.$$$reportNull$$$0(4);
        }
        CaptureByteArrayHandler handler = new CaptureByteArrayHandler(HandleViewDebug.CHUNK_VUOP);
        try {
            HandleViewDebug.captureView((Client)this.client, (String)this.title, (String)node.toString(), (HandleViewDebug.ViewDumpHandler)handler);
        }
        catch (IOException e) {
            return null;
        }
        return handler.getData(timeout, (TimeUnit)unit);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static List<ClientWindow> getAll(@NotNull Client client, long timeout, @NotNull TimeUnit timeUnit) {
        ClientData cd;
        if (client == null) {
            ClientWindow.$$$reportNull$$$0(5);
        }
        if (timeUnit == null) {
            ClientWindow.$$$reportNull$$$0(6);
        }
        if ((cd = client.getClientData()).hasFeature("view-hierarchy")) {
            try {
                void unit;
                return new ListViewRootsHandler().getWindows(client, timeout, (TimeUnit)unit);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/hierarchyview/model/ClientWindow";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/hierarchyview/model/ClientWindow";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadViewImage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CaptureByteArrayHandler
    extends HandleViewDebug.ViewDumpHandler {
        private AtomicReference<byte[]> mData = new AtomicReference();

        public CaptureByteArrayHandler(int type) {
            super(type);
        }

        protected void handleViewDebugResult(ByteBuffer data) {
            byte[] b = new byte[data.remaining()];
            data.get(b);
            this.mData.set(b);
        }

        public byte[] getData(long timeout, TimeUnit unit) {
            this.waitForResult(timeout, unit);
            return this.mData.get();
        }
    }

    private static class ListViewRootsHandler
    extends HandleViewDebug.ViewDumpHandler {
        private final List<String> myViewRoots = Lists.newCopyOnWriteArrayList();

        public ListViewRootsHandler() {
            super(HandleViewDebug.CHUNK_VULW);
        }

        protected void handleViewDebugResult(ByteBuffer data) {
            int nWindows = data.getInt();
            for (int i = 0; i < nWindows; ++i) {
                int len = data.getInt();
                this.myViewRoots.add(ListViewRootsHandler.getString((ByteBuffer)data, (int)len));
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<ClientWindow> getWindows(@NotNull Client c, long timeout, TimeUnit timeUnit) throws IOException {
            void unit;
            if (c == null) {
                ListViewRootsHandler.$$$reportNull$$$0(0);
            }
            HandleViewDebug.listViewRoots((Client)c, (HandleViewDebug.ViewDumpHandler)this);
            this.waitForResult(timeout, (TimeUnit)unit);
            ArrayList windows = Lists.newArrayList();
            for (String root : this.myViewRoots) {
                windows.add(new ClientWindow(root, c));
            }
            ArrayList arrayList = windows;
            if (arrayList == null) {
                ListViewRootsHandler.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/editors/hierarchyview/model/ClientWindow$ListViewRootsHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/editors/hierarchyview/model/ClientWindow$ListViewRootsHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWindows";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getWindows";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

