/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.table.LocaleRenderer;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.StringsCellEditor;
import com.android.tools.idea.editors.strings.table.StringsCellRenderer;
import com.android.tools.idea.ui.TableUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.table.JBTable;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import javax.swing.DefaultRowSorter;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringResourceTable
extends JBTable
implements DataProvider,
PasteProvider {
    public StringResourceTable() {
        super((TableModel)new StringResourceTableModel());
        CellEditorListener editorListener = new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent event) {
                StringResourceTable.this.refilter();
            }

            @Override
            public void editingCanceled(ChangeEvent event) {
            }
        };
        this.getDefaultEditor(Boolean.class).addCellEditorListener(editorListener);
        this.tableHeader.setReorderingAllowed(false);
        StringsCellEditor editor = new StringsCellEditor();
        editor.addCellEditorListener(editorListener);
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        this.setDefaultEditor(String.class, (TableCellEditor)((Object)editor));
        this.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new StringsCellRenderer()));
        new TableSpeedSearch((JTable)((Object)this));
    }

    public void refilter() {
        DefaultRowSorter rowSorter = (DefaultRowSorter)this.getRowSorter();
        if (rowSorter != null) {
            rowSorter.sort();
        }
    }

    @Nullable
    public StringResourceData getData() {
        return ((StringResourceTableModel)this.getModel()).getData();
    }

    public int getSelectedRowModelIndex() {
        return this.convertRowIndexToModel(this.getSelectedRow());
    }

    @NotNull
    public int[] getSelectedRowModelIndices() {
        int[] nArray = Arrays.stream(this.getSelectedRows()).map(arg_0 -> this.convertRowIndexToModel(arg_0)).toArray();
        if (nArray == null) {
            StringResourceTable.$$$reportNull$$$0(0);
        }
        return nArray;
    }

    public int getSelectedColumnModelIndex() {
        return this.convertColumnIndexToModel(this.getSelectedColumn());
    }

    public void setShowingOnlyKeysNeedingTranslations(boolean showingOnlyKeysNeedingTranslations) {
        TableRowSorter<TableModel> rowSorter;
        if (showingOnlyKeysNeedingTranslations) {
            rowSorter = new TableRowSorter<TableModel>(this.getModel());
            rowSorter.setRowFilter(new NeedsTranslationsRowFilter());
        } else {
            rowSorter = null;
        }
        this.setRowSorter(rowSorter);
    }

    public void setModel(@NotNull TableModel model) {
        if (model == null) {
            StringResourceTable.$$$reportNull$$$0(1);
        }
        super.setModel(model);
        OptionalInt optionalWidth = this.getKeyColumnPreferredWidth();
        if (optionalWidth.isPresent()) {
            this.columnModel.getColumn(0).setPreferredWidth(optionalWidth.getAsInt());
        }
        if (this.tableHeader == null) {
            return;
        }
        this.setLocaleColumnHeaderRenderers();
        optionalWidth = this.getDefaultValueAndLocaleColumnPreferredWidths();
        if (optionalWidth.isPresent()) {
            int width = optionalWidth.getAsInt();
            IntStream.range(2, this.getColumnCount()).mapToObj(this.columnModel::getColumn).forEach(column -> column.setPreferredWidth(width));
        }
    }

    @NotNull
    @VisibleForTesting
    public OptionalInt getKeyColumnPreferredWidth() {
        OptionalInt optionalInt = IntStream.range(0, this.getRowCount()).map(row -> this.getPreferredWidth(this.getCellRenderer(row, 0), this.getValueAt(row, 0), row, 0)).max();
        if (optionalInt == null) {
            StringResourceTable.$$$reportNull$$$0(2);
        }
        return optionalInt;
    }

    private void setLocaleColumnHeaderRenderers() {
        LocaleRenderer renderer = new LocaleRenderer(this.tableHeader.getDefaultRenderer(), (StringResourceTableModel)this.getModel());
        IntStream.range(3, this.getColumnCount()).mapToObj(this.columnModel::getColumn).forEach(column -> column.setHeaderRenderer(renderer));
    }

    @NotNull
    @VisibleForTesting
    public OptionalInt getDefaultValueAndLocaleColumnPreferredWidths() {
        OptionalInt optionalInt = IntStream.range(2, this.getColumnCount()).map(column -> this.getPreferredWidth(this.getHeaderRenderer(column), this.getColumnName(column), -1, column)).max();
        if (optionalInt == null) {
            StringResourceTable.$$$reportNull$$$0(3);
        }
        return optionalInt;
    }

    @NotNull
    private TableCellRenderer getHeaderRenderer(int column) {
        TableCellRenderer renderer = this.columnModel.getColumn(column).getHeaderRenderer();
        TableCellRenderer tableCellRenderer = renderer == null ? this.tableHeader.getDefaultRenderer() : renderer;
        if (tableCellRenderer == null) {
            StringResourceTable.$$$reportNull$$$0(4);
        }
        return tableCellRenderer;
    }

    private int getPreferredWidth(@NotNull TableCellRenderer renderer, @NotNull Object value, int row, int column) {
        if (renderer == null) {
            StringResourceTable.$$$reportNull$$$0(5);
        }
        if (value == null) {
            StringResourceTable.$$$reportNull$$$0(6);
        }
        return renderer.getTableCellRendererComponent((JTable)((Object)this), (Object)value, (boolean)false, (boolean)false, (int)row, (int)column).getPreferredSize().width + 2;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            StringResourceTable.$$$reportNull$$$0(7);
        }
        return dataId.equals(PlatformDataKeys.PASTE_PROVIDER.getName()) ? this : null;
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            StringResourceTable.$$$reportNull$$$0(8);
        }
        if (this.getSelectedRowCount() != 1 || this.getSelectedColumnCount() != 1) {
            return false;
        }
        int column = this.getSelectedColumn();
        return column != 0 && column != 1;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            StringResourceTable.$$$reportNull$$$0(9);
        }
        return this.isPastePossible(dataContext);
    }

    public void performPaste(@NotNull DataContext dataContext) {
        Transferable transferable;
        if (dataContext == null) {
            StringResourceTable.$$$reportNull$$$0(10);
        }
        if ((transferable = CopyPasteManager.getInstance().getContents()) != null) {
            TableUtils.paste((JTable)((Object)this), transferable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/table/StringResourceTable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRowModelIndices";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/table/StringResourceTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyColumnPreferredWidth";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueAndLocaleColumnPreferredWidths";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredWidth";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPastePossible";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPasteEnabled";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performPaste";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class NeedsTranslationsRowFilter
    extends RowFilter<TableModel, Integer> {
        private NeedsTranslationsRowFilter() {
        }

        @Override
        public boolean include(@NotNull RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            if (entry == null) {
                NeedsTranslationsRowFilter.$$$reportNull$$$0(0);
            }
            if (((Boolean)entry.getValue(1)).booleanValue()) {
                return false;
            }
            for (int i = 3; i < entry.getValueCount(); ++i) {
                if (!entry.getValue(i).equals("")) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/android/tools/idea/editors/strings/table/StringResourceTable$NeedsTranslationsRowFilter", "include"));
        }
    }
}

