/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.fd.InstantRunConfiguration;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.gradle.plugin.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunConfigurable
implements SearchableConfigurable,
Configurable.NoScroll,
HyperlinkListener,
GradleSyncListener,
Disposable {
    private final InstantRunConfiguration myBuildConfiguration;
    private JPanel myContentPanel;
    private JBCheckBox myInstantRunCheckBox;
    private JBCheckBox myRestartActivityCheckBox;
    private JBLabel myGradleLabel;
    private HyperlinkLabel myOldVersionLabel;
    private JBCheckBox myShowToastCheckBox;
    private JBCheckBox myShowIrStatusNotifications;
    private JBCheckBox myEnableRecorder;
    private HyperlinkLabel myExtraInfoHyperlink;
    private HyperlinkLabel myPrivacyPolicyLink;
    private HyperlinkLabel myReenableLink;
    private JPanel myHelpGooglePanel;
    private JBLabel myHavingTroubleLabel;

    public InstantRunConfigurable() {
        this.$$$setupUI$$$();
        this.myExtraInfoHyperlink.setHtmlText("Learn more about <a href=\"more\">what is logged</a>,");
        this.myExtraInfoHyperlink.addHyperlinkListener(e -> BrowserUtil.browse((String)"https://developer.android.com/r/studio-ui/ir-flight-recorder.html"));
        this.myPrivacyPolicyLink.setHtmlText("and our <a href=\"privacy\">privacy policy.</a>");
        this.myPrivacyPolicyLink.addHyperlinkListener(e -> BrowserUtil.browse((String)"https://www.google.com/policies/privacy/"));
        this.myHelpGooglePanel.setBackground(UIUtil.getPanelBackground().brighter());
        this.myHelpGooglePanel.setBorder(BorderFactory.createLineBorder((Color)JBColor.GRAY));
        this.myHavingTroubleLabel.setFont((Font)JBUI.Fonts.label().asBold().biggerOn(1.2f));
        this.myReenableLink.setHtmlText("<a href=\"reenable\">Re-enable and activate extra logging</a>");
        this.myReenableLink.addHyperlinkListener(e -> {
            this.myInstantRunCheckBox.setSelected(true);
            this.enableIrOptions(true);
            this.myEnableRecorder.setSelected(true);
        });
        this.myInstantRunCheckBox.addActionListener(e -> this.enableIrOptions(this.myInstantRunCheckBox.isSelected()));
        this.myBuildConfiguration = InstantRunConfiguration.getInstance();
        this.updateLinkState();
        this.enableIrOptions(this.myBuildConfiguration.INSTANT_RUN);
    }

    @NotNull
    public String getId() {
        if ("instant.run" == null) {
            InstantRunConfigurable.$$$reportNull$$$0(0);
        }
        return "instant.run";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Instant Run";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myContentPanel;
    }

    public boolean isModified() {
        return this.myBuildConfiguration.INSTANT_RUN != this.isInstantRunEnabled() || this.myBuildConfiguration.RESTART_ACTIVITY != this.isRestartActivity() || this.myBuildConfiguration.SHOW_TOAST != this.isShowToast() || this.myBuildConfiguration.SHOW_IR_STATUS_NOTIFICATIONS != this.isShowStatusNotifications() || this.myBuildConfiguration.ENABLE_RECORDER != this.isEnableRecorder();
    }

    public void apply() throws ConfigurationException {
        this.myBuildConfiguration.INSTANT_RUN = this.isInstantRunEnabled();
        this.myBuildConfiguration.RESTART_ACTIVITY = this.isRestartActivity();
        this.myBuildConfiguration.SHOW_TOAST = this.isShowToast();
        this.myBuildConfiguration.SHOW_IR_STATUS_NOTIFICATIONS = this.isShowStatusNotifications();
        this.myBuildConfiguration.ENABLE_RECORDER = this.isEnableRecorder();
    }

    public void reset() {
        this.myInstantRunCheckBox.setSelected(this.myBuildConfiguration.INSTANT_RUN);
        this.myRestartActivityCheckBox.setSelected(this.myBuildConfiguration.RESTART_ACTIVITY);
        this.myShowToastCheckBox.setSelected(this.myBuildConfiguration.SHOW_TOAST);
        this.myShowIrStatusNotifications.setSelected(this.myBuildConfiguration.SHOW_IR_STATUS_NOTIFICATIONS);
        this.myEnableRecorder.setSelected(this.myBuildConfiguration.ENABLE_RECORDER);
    }

    public void disposeUIResources() {
    }

    private boolean isInstantRunEnabled() {
        return this.myInstantRunCheckBox.isSelected();
    }

    private boolean isRestartActivity() {
        return this.myRestartActivityCheckBox.isSelected();
    }

    private boolean isShowToast() {
        return this.myShowToastCheckBox.isSelected();
    }

    private boolean isShowStatusNotifications() {
        return this.myShowIrStatusNotifications.isSelected();
    }

    private boolean isEnableRecorder() {
        return this.myEnableRecorder.isSelected();
    }

    private void createUIComponents() {
        this.myOldVersionLabel = new HyperlinkLabel();
        this.setSyncLinkMessage("");
        this.myOldVersionLabel.addHyperlinkListener((HyperlinkListener)this);
    }

    private void setSyncLinkMessage(@NotNull String syncMessage) {
        if (syncMessage == null) {
            InstantRunConfigurable.$$$reportNull$$$0(1);
        }
        this.myOldVersionLabel.setHyperlinkText("Instant Run requires a newer version of the Gradle plugin. ", "Update Project", syncMessage);
        this.myOldVersionLabel.repaint();
    }

    private void updateLinkState() {
        boolean isGradle = false;
        boolean isCurrentPlugin = false;
        block0: for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (project.isDefault()) continue;
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                AndroidModuleModel model = AndroidModuleModel.get(module);
                if (model == null) continue;
                isGradle = true;
                if (!InstantRunGradleUtils.modelSupportsInstantRun(model)) continue;
                isCurrentPlugin = true;
                continue block0;
            }
        }
        this.myGradleLabel.setVisible(!isGradle);
        this.myOldVersionLabel.setVisible(isGradle && !isCurrentPlugin);
        boolean enabled = isGradle && isCurrentPlugin;
        this.myInstantRunCheckBox.setEnabled(isGradle);
        this.enableIrOptions(enabled);
    }

    private void enableIrOptions(boolean enabled) {
        this.myRestartActivityCheckBox.setEnabled(enabled);
        this.myShowToastCheckBox.setEnabled(enabled);
        this.myShowIrStatusNotifications.setEnabled(enabled);
        this.myEnableRecorder.setEnabled(enabled);
        this.myExtraInfoHyperlink.setEnabled(enabled);
        this.myHelpGooglePanel.setVisible(!enabled);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (project.isDefault() || InstantRunConfigurable.updateProjectToInstantRunTools(project, this)) continue;
            this.setSyncLinkMessage("Error updating to new Gradle version");
        }
    }

    public static boolean updateProjectToInstantRunTools(@NotNull Project project, @Nullable GradleSyncListener listener) {
        AndroidPluginVersionUpdater updater;
        AndroidPluginVersionUpdater.UpdateResult result;
        if (project == null) {
            InstantRunConfigurable.$$$reportNull$$$0(2);
        }
        String pluginVersion = "2.3.0-beta1";
        if (GradleVersion.parse((String)"2.3.0").compareTo(InstantRunManager.MINIMUM_GRADLE_PLUGIN_VERSION) > 0) {
            pluginVersion = "2.3.0";
        }
        if ((result = (updater = AndroidPluginVersionUpdater.getInstance(project)).updatePluginVersion(GradleVersion.parse((String)pluginVersion), GradleVersion.parse((String)"3.3"))).isPluginVersionUpdated() && result.versionUpdateSuccess()) {
            Revision revision;
            String buildToolsVersion = "23.0.2";
            AndroidSdkHandler sdk = AndroidSdks.getInstance().tryToChooseSdkHandler();
            BuildToolInfo latestBuildTool = sdk.getLatestBuildTool((ProgressIndicator)new StudioLoggerProgressIndicator(InstantRunConfigurable.class), false);
            if (latestBuildTool != null && (revision = latestBuildTool.getRevision()).compareTo(Revision.parseRevision((String)buildToolsVersion)) > 0) {
                buildToolsVersion = revision.toShortString();
            }
            GradleUtil.setBuildToolsVersion(project, buildToolsVersion);
            GradleWrapper gradleWrapper = GradleWrapper.find(project);
            if (gradleWrapper != null) {
                gradleWrapper.updateDistributionUrlAndDisplayFailure("3.3");
            }
            GradleSyncInvoker.Request request = new GradleSyncInvoker.Request().setRunInBackground(false);
            GradleSyncInvoker.getInstance().requestProjectSync(project, request, listener);
            return true;
        }
        return false;
    }

    public void dispose() {
    }

    @Override
    public void syncStarted(@NotNull Project project) {
        if (project == null) {
            InstantRunConfigurable.$$$reportNull$$$0(3);
        }
        this.updateUi(true, false);
    }

    @Override
    public void setupStarted(@NotNull Project project) {
        if (project == null) {
            InstantRunConfigurable.$$$reportNull$$$0(4);
        }
    }

    @Override
    public void syncSucceeded(@NotNull Project project) {
        if (project == null) {
            InstantRunConfigurable.$$$reportNull$$$0(5);
        }
        this.updateUi(false, false);
    }

    @Override
    public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
        if (project == null) {
            InstantRunConfigurable.$$$reportNull$$$0(6);
        }
        if (errorMessage == null) {
            InstantRunConfigurable.$$$reportNull$$$0(7);
        }
        this.updateUi(false, true);
    }

    @Override
    public void syncSkipped(@NotNull Project project) {
        if (project == null) {
            InstantRunConfigurable.$$$reportNull$$$0(8);
        }
        this.updateUi(false, false);
    }

    private void updateUi(boolean syncing, boolean failed) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myContentPanel.isShowing()) {
                if (syncing) {
                    this.setSyncLinkMessage("(Syncing)");
                } else if (failed) {
                    this.setSyncLinkMessage("(Sync Failed)");
                } else {
                    this.setSyncLinkMessage("");
                }
                this.updateLinkState();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fd/InstantRunConfigurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncMessage";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fd/InstantRunConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSyncLinkMessage";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateProjectToInstantRunTools";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "syncStarted";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupStarted";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "syncSucceeded";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "syncFailed";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "syncSkipped";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel;
        HyperlinkLabel hyperlinkLabel2;
        HyperlinkLabel hyperlinkLabel3;
        JBLabel jBLabel;
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JBLabel jBLabel2;
        JBCheckBox jBCheckBox4;
        JBCheckBox jBCheckBox5;
        JPanel jPanel2;
        this.createUIComponents();
        this.myContentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(10, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myInstantRunCheckBox = jBCheckBox5 = new JBCheckBox();
        jBCheckBox5.setText("Enable Instant Run to hot swap code/resource changes on deploy (default enabled)");
        jPanel2.add((Component)jBCheckBox5, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRestartActivityCheckBox = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setText("Restart activity on code changes");
        jPanel2.add((Component)jBCheckBox4, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myGradleLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Instant Run requires the project to be built with Gradle.");
        jBLabel2.setVisible(false);
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        HyperlinkLabel hyperlinkLabel4 = this.myOldVersionLabel;
        jPanel2.add((Component)hyperlinkLabel4, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myShowToastCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Show toasts in the running app when changes are applied");
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myShowIrStatusNotifications = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Show Instant Run status notifications");
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myEnableRecorder = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Log extra info to help Google troubleshoot Instant Run issues (Recommended)");
        jPanel2.add((Component)jBCheckBox, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myHelpGooglePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(9, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myHavingTroubleLabel = jBLabel = new JBLabel();
        jBLabel.setFontColor(UIUtil.FontColor.NORMAL);
        jBLabel.setText("Having trouble with Instant Run?");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("messages/AndroidBundle").getString("instant.run.flr.banner.subtitle"));
        jPanel.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myReenableLink = hyperlinkLabel3 = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel3, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 0, 5));
        jPanel2.add((Component)jPanel3, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null, 5));
        this.myExtraInfoHyperlink = hyperlinkLabel2 = new HyperlinkLabel();
        Component component = jPanel3.add((Component)hyperlinkLabel2);
        this.myPrivacyPolicyLink = hyperlinkLabel = new HyperlinkLabel();
        Component component2 = jPanel3.add((Component)hyperlinkLabel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

