/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenGradleSettingsHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInsight.actions.AddGradleDslPluginAction;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class GradleDslMethodNotFoundErrorHandler
extends SyncErrorHandler {
    private static final String GRADLE_DSL_METHOD_NOT_FOUND_ERROR_PREFIX = "Gradle DSL method not found";
    private static final Pattern MISSING_METHOD_PATTERN = Pattern.compile("Could not find method (.*?) .*");

    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        String text;
        if (error == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(0);
        }
        if (notification == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(2);
        }
        if ((text = GradleDslMethodNotFoundErrorHandler.findErrorMessage(this.getRootCause((Throwable)error))) != null) {
            GradleDslMethodNotFoundErrorHandler.getQuickFixHyperlinks(notification, project, text);
            return true;
        }
        return false;
    }

    private static String findErrorMessage(@NotNull Throwable rootCause) {
        String errorType;
        if (rootCause == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(3);
        }
        if ((errorType = rootCause.getClass().getName()).equals("org.gradle.api.internal.MissingMethodException") || errorType.equals("org.gradle.internal.metaobject.AbstractDynamicObject$CustomMessageMissingMethodException")) {
            String method = GradleDslMethodNotFoundErrorHandler.parseMissingMethod(rootCause.getMessage());
            GradleDslMethodNotFoundErrorHandler.updateUsageTracker(AndroidStudioEvent.GradleSyncFailure.DSL_METHOD_NOT_FOUND, method);
            return "Gradle DSL method not found: '" + method + "'";
        }
        return null;
    }

    @NotNull
    private static String parseMissingMethod(@NotNull String rootCauseText) {
        Matcher matcher;
        if (rootCauseText == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(4);
        }
        String string = (matcher = MISSING_METHOD_PATTERN.matcher(rootCauseText)).find() ? matcher.group(1) : "";
        if (string == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static void getQuickFixHyperlinks(@NotNull NotificationData notification, @NotNull Project project, @NotNull String text) {
        VirtualFile file;
        if (notification == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(6);
        }
        if (project == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(7);
        }
        if (text == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(8);
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        String filePath = notification.getFilePath();
        VirtualFile virtualFile = file = filePath != null ? LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath) : null;
        if (file != null && "build.gradle".equals(file.getName())) {
            GradleDslMethodNotFoundErrorHandler.updateNotificationWithBuildFile(project, file, notification, text);
            return;
        }
        if (file != null && notification.getLine() > 0 && notification.getNavigatable() == null) {
            OpenFileHyperlink hyperlink = new OpenFileHyperlink(filePath, notification.getLine() - 1);
            hyperlinks.add(hyperlink);
        }
        SyncMessages.getInstance(project).updateNotification(notification, text, hyperlinks);
    }

    private static void updateNotificationWithBuildFile(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull NotificationData notification, @NotNull String text) {
        if (project == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(9);
        }
        if (virtualFile == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(10);
        }
        if (notification == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(11);
        }
        if (text == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(12);
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        NotificationHyperlink gradleSettingsHyperlink = GradleDslMethodNotFoundErrorHandler.getGradleSettingsHyperlink(project);
        NotificationHyperlink applyGradlePluginHyperlink = GradleDslMethodNotFoundErrorHandler.getApplyGradlePluginHyperlink(virtualFile, notification);
        FixAndroidGradlePluginVersionHyperlink upgradeAndroidPluginHyperlink = new FixAndroidGradlePluginVersionHyperlink();
        String newMsg = text + "\nPossible causes:<ul>";
        if (!GradleDslMethodNotFoundErrorHandler.gradleModelIsRecent(project)) {
            newMsg = newMsg + String.format("<li>The project '%1$s' may be using a version of the Android Gradle plug-in that does not contain the method (e.g. 'testCompile' was added in 1.1.0).\n", project.getName()) + upgradeAndroidPluginHyperlink.toHtml() + "</li>";
        }
        newMsg = newMsg + String.format("<li>The project '%1$s' may be using a version of Gradle that does not contain the method.\n", project.getName()) + gradleSettingsHyperlink.toHtml() + "</li><li>The build file may be missing a Gradle plugin.\n" + applyGradlePluginHyperlink.toHtml() + "</li>";
        notification.setTitle("Gradle Sync Issues");
        notification.setMessage(newMsg);
        notification.setNotificationCategory(NotificationCategory.convert((NotificationType)DEFAULT_NOTIFICATION_TYPE));
        hyperlinks.add(gradleSettingsHyperlink);
        hyperlinks.add(applyGradlePluginHyperlink);
        hyperlinks.add(upgradeAndroidPluginHyperlink);
        SyncMessages.getInstance(project).addNotificationListener(notification, hyperlinks);
    }

    @NotNull
    private static NotificationHyperlink getGradleSettingsHyperlink(@NotNull Project project) {
        VirtualFile propertiesFile;
        GradleWrapper gradleWrapper;
        if (project == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(13);
        }
        if (GradleDslMethodNotFoundErrorHandler.isUsingWrapper(project) && (gradleWrapper = GradleWrapper.find(project)) != null && (propertiesFile = gradleWrapper.getPropertiesFile()) != null) {
            NotificationHyperlink notificationHyperlink = new NotificationHyperlink("open.wrapper.file", "Open Gradle wrapper file"){

                @Override
                protected void execute(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(project, propertiesFile);
                    FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/GradleDslMethodNotFoundErrorHandler$1", "execute"));
                }
            };
            if (notificationHyperlink == null) {
                GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(14);
            }
            return notificationHyperlink;
        }
        OpenGradleSettingsHyperlink openGradleSettingsHyperlink = new OpenGradleSettingsHyperlink();
        if (openGradleSettingsHyperlink == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(15);
        }
        return openGradleSettingsHyperlink;
    }

    private static boolean gradleModelIsRecent(@NotNull Project project) {
        GradleVersion pluginVersion;
        AndroidPluginInfo androidPluginInfo;
        if (project == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(16);
        }
        if ((androidPluginInfo = AndroidPluginInfo.searchInBuildFilesOnly(project)) != null && (pluginVersion = androidPluginInfo.getPluginVersion()) != null) {
            AndroidPluginGeneration pluginGeneration = androidPluginInfo.getPluginGeneration();
            return pluginVersion.compareTo(pluginGeneration.getLatestKnownVersion()) > 0;
        }
        return false;
    }

    private static boolean isUsingWrapper(@NotNull Project project) {
        if (project == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(17);
        }
        GradleProjectSettings gradleSettings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
        GradleWrapper gradleWrapper = GradleWrapper.find(project);
        DistributionType distributionType = gradleSettings != null ? gradleSettings.getDistributionType() : null;
        return (distributionType == null || distributionType == DistributionType.DEFAULT_WRAPPED) && gradleWrapper != null;
    }

    @NotNull
    private static NotificationHyperlink getApplyGradlePluginHyperlink(final @NotNull VirtualFile virtualFile, final @NotNull NotificationData notification) {
        if (virtualFile == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(18);
        }
        if (notification == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(19);
        }
        NotificationHyperlink notificationHyperlink = new NotificationHyperlink("apply.gradle.plugin", "Apply Gradle plugin"){

            @Override
            protected void execute(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                GradleDslMethodNotFoundErrorHandler.openFile(virtualFile, notification, project);
                ActionManager actionManager = ActionManager.getInstance();
                String actionId = "AddGradleDslPluginAction";
                AnAction action = actionManager.getAction(actionId);
                assert (action instanceof AddGradleDslPluginAction);
                AddGradleDslPluginAction addPluginAction = (AddGradleDslPluginAction)action;
                actionManager.tryToExecute((AnAction)addPluginAction, ActionCommand.getInputEvent((String)actionId), null, "unknown", true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/GradleDslMethodNotFoundErrorHandler$2", "execute"));
            }
        };
        if (notificationHyperlink == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(20);
        }
        return notificationHyperlink;
    }

    private static void openFile(@NotNull VirtualFile virtualFile, @NotNull NotificationData notification, @NotNull Project project) {
        if (virtualFile == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(21);
        }
        if (notification == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(22);
        }
        if (project == null) {
            GradleDslMethodNotFoundErrorHandler.$$$reportNull$$$0(23);
        }
        int line = notification.getLine() - 1;
        int column = notification.getColumn() - 1;
        line = line < 0 ? -1 : line;
        column = column < 0 ? -1 : column + 1;
        new OpenFileDescriptor(project, virtualFile, line, column).navigate(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 14: 
            case 15: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 14: 
            case 15: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCause";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCauseText";
                break;
            }
            case 5: 
            case 14: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/errors/GradleDslMethodNotFoundErrorHandler";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/GradleDslMethodNotFoundErrorHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMissingMethod";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleSettingsHyperlink";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplyGradlePluginHyperlink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleError";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findErrorMessage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseMissingMethod";
                break;
            }
            case 5: 
            case 14: 
            case 15: 
            case 20: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixHyperlinks";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateNotificationWithBuildFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getGradleSettingsHyperlink";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "gradleModelIsRecent";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isUsingWrapper";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getApplyGradlePluginHyperlink";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 14: 
            case 15: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

