/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.java;

import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.issues.UnresolvedDependenciesReporter;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.JavaModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.common.DependencySetupErrors;
import com.android.tools.idea.gradle.project.sync.setup.module.java.JavaModuleDependenciesSetup;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesModuleSetupStep
extends JavaModuleSetupStep {
    private static final DependencyScope DEFAULT_DEPENDENCY_SCOPE = DependencyScope.COMPILE;
    @NotNull
    private final JavaModuleDependenciesSetup myDependenciesSetup;

    public DependenciesModuleSetupStep() {
        this(new JavaModuleDependenciesSetup());
    }

    @VisibleForTesting
    DependenciesModuleSetupStep(@NotNull JavaModuleDependenciesSetup dependenciesSetup) {
        if (dependenciesSetup == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(0);
        }
        this.myDependenciesSetup = dependenciesSetup;
    }

    @Override
    protected void doSetUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull JavaModuleModel javaModuleModel, @Nullable SyncAction.ModuleModels gradleModels, @Nullable ProgressIndicator indicator) {
        if (module == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(1);
        }
        if (ideModelsProvider == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(2);
        }
        if (javaModuleModel == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(3);
        }
        ArrayList<String> unresolved = new ArrayList<String>();
        for (JavaModuleDependency javaModuleDependency : javaModuleModel.getJavaModuleDependencies()) {
            DependenciesModuleSetupStep.updateDependency(module, ideModelsProvider, javaModuleDependency);
        }
        for (JarLibraryDependency jarLibraryDependency : javaModuleModel.getJarLibraryDependencies()) {
            if (jarLibraryDependency.isResolved()) {
                this.updateDependency(module, ideModelsProvider, jarLibraryDependency);
                continue;
            }
            unresolved.add(jarLibraryDependency.getName());
        }
        UnresolvedDependenciesReporter.getInstance().report(unresolved, module);
    }

    private static void updateDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull JavaModuleDependency dependency) {
        if (module == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(4);
        }
        if (modelsProvider == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(5);
        }
        if (dependency == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(6);
        }
        DependencySetupErrors setupErrors = DependencySetupErrors.getInstance(module.getProject());
        String moduleName = dependency.getModuleName();
        Module found = null;
        for (Module m : modelsProvider.getModules()) {
            if (!moduleName.equals(m.getName())) continue;
            found = m;
        }
        ModifiableRootModel moduleModel = modelsProvider.getModifiableRootModel(module);
        if (found != null) {
            AndroidFacet androidFacet = Facets.findFacet(found, modelsProvider, AndroidFacet.ID);
            if (androidFacet == null) {
                ModuleOrderEntry entry = moduleModel.addModuleOrderEntry(found);
                entry.setExported(true);
            } else {
                setupErrors.addInvalidModuleDependency(moduleModel.getModule(), found.getName(), "Java modules cannot depend on Android modules");
            }
            return;
        }
        setupErrors.addMissingModule(moduleName, module.getName(), null);
    }

    private void updateDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull JarLibraryDependency dependency) {
        if (module == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(7);
        }
        if (modelsProvider == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(8);
        }
        if (dependency == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(9);
        }
        DependencyScope scope = DependenciesModuleSetupStep.parseScope(dependency.getScope());
        File binaryPath = dependency.getBinaryPath();
        if (binaryPath == null) {
            DependencySetupErrors setupErrors = DependencySetupErrors.getInstance(module.getProject());
            setupErrors.addMissingBinaryPath(module.getName());
            return;
        }
        String name = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)binaryPath.getPath());
        this.myDependenciesSetup.setUpLibraryDependency(module, modelsProvider, name, scope, binaryPath, dependency.getSourcePath(), dependency.getJavadocPath());
    }

    @NotNull
    private static DependencyScope parseScope(@Nullable String scope) {
        if (scope == null) {
            DependencyScope dependencyScope = DEFAULT_DEPENDENCY_SCOPE;
            if (dependencyScope == null) {
                DependenciesModuleSetupStep.$$$reportNull$$$0(10);
            }
            return dependencyScope;
        }
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!scope.equalsIgnoreCase(dependencyScope.toString())) continue;
            DependencyScope dependencyScope2 = dependencyScope;
            if (dependencyScope2 == null) {
                DependenciesModuleSetupStep.$$$reportNull$$$0(11);
            }
            return dependencyScope2;
        }
        DependencyScope dependencyScope = DEFAULT_DEPENDENCY_SCOPE;
        if (dependencyScope == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(12);
        }
        return dependencyScope;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Java dependencies setup" == null) {
            DependenciesModuleSetupStep.$$$reportNull$$$0(13);
        }
        return "Java dependencies setup";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesSetup";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModelsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaModuleModel";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/java/DependenciesModuleSetupStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/java/DependenciesModuleSetupStep";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doSetUpModule";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateDependency";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

