/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.android;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidProjectValidationStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutRenderingIssueValidationStrategy
extends AndroidProjectValidationStrategy {
    @Nullable
    private GradleVersion myModelVersion;

    LayoutRenderingIssueValidationStrategy(@NotNull Project project) {
        if (project == null) {
            LayoutRenderingIssueValidationStrategy.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @Override
    void validate(@NotNull Module module, @NotNull AndroidModuleModel androidModel) {
        if (module == null) {
            LayoutRenderingIssueValidationStrategy.$$$reportNull$$$0(1);
        }
        if (androidModel == null) {
            LayoutRenderingIssueValidationStrategy.$$$reportNull$$$0(2);
        }
        if (androidModel.getFeatures().isLayoutRenderingIssuePresent()) {
            this.myModelVersion = androidModel.getModelVersion();
        }
    }

    @Override
    void fixAndReportFoundIssues() {
        if (this.myModelVersion != null) {
            String text = String.format("Using an obsolete version of the Gradle plugin (%1$s);", this.myModelVersion);
            text = text + " this can lead to layouts not rendering correctly.";
            SyncMessage message = new SyncMessage("Gradle Sync Issues", MessageType.WARNING, text);
            message.add(Arrays.asList(new FixAndroidGradlePluginVersionHyperlink(), new OpenUrlHyperlink("https://code.google.com/p/android/issues/detail?id=170841", "More Info...")));
            SyncMessages.getInstance(this.getProject()).report(message);
        }
    }

    @VisibleForTesting
    @Nullable
    GradleVersion getModelVersion() {
        return this.myModelVersion;
    }

    @VisibleForTesting
    void setModelVersion(@Nullable GradleVersion modelVersion) {
        this.myModelVersion = modelVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/validation/android/LayoutRenderingIssueValidationStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

