/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.tool;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AllocationInfo;
import com.android.ddmlib.AllocationsParser;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.LegacyAllocationConverter;
import com.android.tools.datastore.LegacyAllocationTracker;
import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.ddms.adb.AdbService;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profilers.ProfilerClient;
import com.google.common.base.Charsets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

class StudioProfilerDeviceManager
implements AndroidDebugBridge.IClientChangeListener,
AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IDebugBridgeChangeListener {
    private static final int DEVICE_PORT = 12389;
    private static final String DATASTORE_NAME = "DataStoreService";
    private final ProfilerClient myClient;
    private final DataStoreService myDataStoreService;
    private final StudioLegacyAllocationTracker myLegacyAllocationTracker;
    private AndroidDebugBridge myBridge;

    public StudioProfilerDeviceManager(@NotNull Project project) throws IOException {
        if (project == null) {
            StudioProfilerDeviceManager.$$$reportNull$$$0(0);
        }
        File adb = AndroidSdkUtils.getAdb(project);
        if (adb == null) {
            throw new IllegalStateException("No adb found");
        }
        this.myDataStoreService = new DataStoreService(DATASTORE_NAME);
        this.myClient = new ProfilerClient(DATASTORE_NAME);
        ListenableFuture<AndroidDebugBridge> future = AdbService.getInstance().getDebugBridge(adb);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

            public void onSuccess(AndroidDebugBridge bridge) {
                StudioProfilerDeviceManager.this.myBridge = bridge;
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/monitor/tool/StudioProfilerDeviceManager$1", "onFailure"));
            }
        }, (Executor)EdtExecutor.INSTANCE);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        this.myLegacyAllocationTracker = new StudioLegacyAllocationTracker();
        this.myDataStoreService.setLegacyAllocationTracker((LegacyAllocationTracker)this.myLegacyAllocationTracker);
    }

    private static Logger getLogger() {
        return Logger.getInstance(StudioProfilerDeviceManager.class);
    }

    public void updateDevices() {
        if (this.myBridge != null) {
            Profiler.SetProcessesRequest.Builder builder = Profiler.SetProcessesRequest.newBuilder();
            for (IDevice device : this.myBridge.getDevices()) {
                if (!device.isOnline()) continue;
                Profiler.Device profilerDevice = Profiler.Device.newBuilder().setSerial(device.getSerialNumber()).setModel(device.getName()).build();
                Profiler.DeviceProcesses.Builder deviceProcesses = Profiler.DeviceProcesses.newBuilder();
                deviceProcesses.setDevice(profilerDevice);
                for (Client client : device.getClients()) {
                    String description = client.getClientData().getClientDescription();
                    deviceProcesses.addProcess(Profiler.Process.newBuilder().setName(description == null ? "[UNKNOWN]" : description).setPid(client.getClientData().getPid()).build());
                }
                builder.addDeviceProcesses(deviceProcesses.build());
                this.myLegacyAllocationTracker.setDevice(device);
            }
            this.myClient.getProfilerClient().setProcesses(builder.build());
        }
    }

    public void clientChanged(Client client, int changeMask) {
        if ((changeMask & 1) != 0) {
            this.updateDevices();
        }
    }

    public void deviceConnected(IDevice device) {
        this.updateDevices();
        if (device.isOnline()) {
            this.spawnPerfd(device);
        }
    }

    public void deviceDisconnected(IDevice device) {
        this.updateDevices();
    }

    public void deviceChanged(IDevice device, int changeMask) {
        this.updateDevices();
        if ((changeMask & 1) != 0 && device.isOnline()) {
            this.spawnPerfd(device);
        }
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        this.myBridge = bridge;
    }

    public ProfilerClient getClient() {
        return this.myClient;
    }

    private void spawnPerfd(IDevice device) {
        PerfdThread thread = new PerfdThread(device, this.myClient);
        thread.start();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/monitor/tool/StudioProfilerDeviceManager", "<init>"));
    }

    private class StudioLegacyAllocationTracker
    implements LegacyAllocationTracker {
        private IDevice myDevice;
        private final LegacyAllocationConverter myConverter = new LegacyAllocationConverter();

        private StudioLegacyAllocationTracker() {
        }

        public void setDevice(IDevice device) {
            this.myDevice = device;
        }

        public boolean setAllocationTrackingEnabled(int processId, boolean enabled) {
            Client client = this.getClient(this.myDevice, processId);
            if (client == null) {
                return false;
            }
            client.enableAllocationTracker(enabled);
            return true;
        }

        public void getAllocationTrackingDump(int processId, final @NotNull ExecutorService executorService, final @NotNull Consumer<byte[]> consumer) {
            Client targetClient;
            if (executorService == null) {
                StudioLegacyAllocationTracker.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                StudioLegacyAllocationTracker.$$$reportNull$$$0(1);
            }
            if ((targetClient = this.getClient(this.myDevice, processId)) == null) {
                return;
            }
            AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)new AndroidDebugBridge.IClientChangeListener(){

                public void clientChanged(Client client, int changeMask) {
                    if (targetClient == client && (changeMask & 0x200) != 0) {
                        byte[] data = client.getClientData().getAllocationsData();
                        executorService.submit(() -> {
                            if (consumer == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            consumer.consume((Object)data);
                        });
                        AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/monitor/tool/StudioProfilerDeviceManager$StudioLegacyAllocationTracker$1", "lambda$clientChanged$0"));
                }
            });
            targetClient.requestAllocationDetails();
        }

        @NotNull
        public LegacyAllocationConverter parseDump(@NotNull byte[] dumpData) {
            AllocationInfo[] rawInfos;
            if (dumpData == null) {
                StudioLegacyAllocationTracker.$$$reportNull$$$0(2);
            }
            this.myConverter.prepare();
            for (AllocationInfo info : rawInfos = AllocationsParser.parse((ByteBuffer)ByteBuffer.wrap(dumpData))) {
                List<StackTraceElement> stackTraceElements = Arrays.asList(info.getStackTrace());
                LegacyAllocationConverter.CallStack callStack = this.myConverter.addCallStack(stackTraceElements);
                int classId = this.myConverter.addClassName(info.getAllocatedClass());
                this.myConverter.addAllocation(new LegacyAllocationConverter.Allocation(classId, info.getSize(), (int)info.getThreadId(), callStack.getId()));
            }
            LegacyAllocationConverter legacyAllocationConverter = this.myConverter;
            if (legacyAllocationConverter == null) {
                StudioLegacyAllocationTracker.$$$reportNull$$$0(3);
            }
            return legacyAllocationConverter;
        }

        private Client getClient(@NotNull IDevice device, int processId) {
            if (device == null) {
                StudioLegacyAllocationTracker.$$$reportNull$$$0(4);
            }
            if (StudioProfilerDeviceManager.this.myBridge == null) {
                return null;
            }
            return device.getClient(device.getClientName(processId));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executorService";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dumpData";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/monitor/tool/StudioProfilerDeviceManager$StudioLegacyAllocationTracker";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/monitor/tool/StudioProfilerDeviceManager$StudioLegacyAllocationTracker";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseDump";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllocationTrackingDump";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "parseDump";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getClient";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PerfdThread
    extends Thread {
        private final IDevice myDevice;
        private final ProfilerClient myClient;
        private int myLocalPort;

        public PerfdThread(IDevice device, ProfilerClient client) {
            super("Perfd Thread: " + device.getSerialNumber());
            this.myDevice = device;
            this.myClient = client;
            this.myLocalPort = 0;
        }

        @Override
        public void run() {
            try {
                String dir = "../../out/studio/native/out/release";
                File perfd = null;
                for (String abi : this.myDevice.getAbis()) {
                    File candidate = new File(PathManager.getHomePath(), dir + "/" + abi + "/perfd");
                    if (!candidate.exists()) continue;
                    perfd = candidate;
                }
                assert (perfd != null);
                String devicePath = "/data/local/tmp/perfd/";
                this.myDevice.executeShellCommand("mkdir -p " + devicePath, (IShellOutputReceiver)new NullReceiver());
                this.myDevice.pushFile(perfd.getAbsolutePath(), devicePath + "/perfd");
                this.myDevice.executeShellCommand("chmod +x " + devicePath + "perfd", (IShellOutputReceiver)new NullReceiver());
                this.myDevice.executeShellCommand(devicePath + "perfd", new IShellOutputReceiver(){

                    public void addOutput(byte[] data, int offset, int length) {
                        String s = new String(data, Charsets.UTF_8);
                        StudioProfilerDeviceManager.getLogger().info("[perfd]: " + s);
                        if (s.contains("Server listening")) {
                            try {
                                myLocalPort = NetUtils.findAvailableSocketPort();
                                myDevice.createForward(myLocalPort, 12389);
                                myClient.getProfilerClient().connect(Profiler.ConnectRequest.newBuilder().setPort(myLocalPort).build());
                            }
                            catch (AdbCommandRejectedException | TimeoutException | IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }

                    public void flush() {
                    }

                    public boolean isCancelled() {
                        return false;
                    }
                }, 0L, null);
                if (this.myLocalPort > 0) {
                    this.myClient.getProfilerClient().disconnect(Profiler.DisconnectRequest.newBuilder().setPort(this.myLocalPort).build());
                    StudioProfilerDeviceManager.getLogger().info("Terminating perfd thread");
                }
            }
            catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | SyncException | TimeoutException | IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class NullReceiver
    implements IShellOutputReceiver {
        private NullReceiver() {
        }

        public void addOutput(byte[] data, int offset, int length) {
        }

        public void flush() {
        }

        public boolean isCancelled() {
            return false;
        }
    }
}

