/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.cpu.model;

import com.android.tools.adtui.chart.hchart.Method;
import com.android.tools.adtui.chart.hchart.MethodUsage;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.model.HNode;
import com.android.tools.idea.monitor.ui.cpu.view.AppStatTreeNode;
import com.android.utils.SparseArray;
import com.intellij.ui.ColoredTreeCellRenderer;
import java.io.IOException;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public abstract class AppTrace {
    private SparseArray<HNode<MethodUsage>> myTopDownStats;
    private SparseArray<HNode<MethodUsage>> myBottomUpStats;
    private SparseArray<JComponent> myTopdownTrees;
    private SparseArray<JComponent> myBottomUpTrees;

    public abstract Source getSource();

    public abstract String getSeparator();

    public abstract void parse() throws IOException;

    public abstract SparseArray<HNode<Method>> getThreadsGraph();

    public SparseArray<HNode<MethodUsage>> getTopdownStats() {
        if (this.myTopDownStats == null) {
            this.generateTopDownGraphs();
        }
        return this.myTopDownStats;
    }

    public SparseArray<HNode<MethodUsage>> getBottomupStats() {
        if (this.myBottomUpStats == null) {
            this.generateBottomUpGraphs();
        }
        return this.myBottomUpStats;
    }

    private void generateBottomUpGraphs() {
        this.myBottomUpStats = new SparseArray();
        SparseArray<HNode<MethodUsage>> topDownGraphs = this.getTopdownStats();
        for (int i = 0; i < topDownGraphs.size(); ++i) {
            int threadPid = topDownGraphs.keyAt(i);
            HNode topDownGraph = (HNode)topDownGraphs.get(threadPid);
            HNode<MethodUsage> bottomUpGraph = this.generateBottomUpGraph((HNode<MethodUsage>)topDownGraph);
            this.myBottomUpStats.put(threadPid, bottomUpGraph);
        }
    }

    private HNode<MethodUsage> generateBottomUpGraph(HNode<MethodUsage> topDownGraph) {
        HNode bottomUpGraph = new HNode();
        MethodUsage fakeMethodUsageRoot = new MethodUsage();
        fakeMethodUsageRoot.setNamespace("");
        fakeMethodUsageRoot.setName("");
        fakeMethodUsageRoot.setExclusivePercentage(1.0);
        bottomUpGraph.setData((Object)fakeMethodUsageRoot);
        Stack<HNode<MethodUsage>> stack = new Stack<HNode<MethodUsage>>();
        topDownGraph = topDownGraph.getFirstChild();
        this.reverseTopDownGraph((HNode<MethodUsage>)topDownGraph, (HNode<MethodUsage>)bottomUpGraph, stack);
        return bottomUpGraph;
    }

    private void reverseTopDownGraph(HNode<MethodUsage> topDownNode, HNode<MethodUsage> bottomUpGraph, Stack<HNode<MethodUsage>> stack) {
        stack.push(topDownNode);
        if (((MethodUsage)topDownNode.getData()).getExclusivePercentage() > 0.0) {
            HNode tailNode = null;
            HNode headNode = null;
            for (int i = stack.size() - 1; i >= 0; --i) {
                HNode stackedNode = (HNode)stack.get(i);
                HNode newNode = new HNode();
                if (headNode == null) {
                    headNode = newNode;
                }
                newNode.setStart(stackedNode.getStart());
                newNode.setEnd(stackedNode.getEnd());
                newNode.setDepth(stack.size() - i);
                newNode.setData(stackedNode.getData());
                if (tailNode != null) {
                    tailNode.addHNode(newNode);
                }
                tailNode = newNode;
            }
            boolean mergedInGraph = false;
            for (HNode child : bottomUpGraph.getChildren()) {
                if (!((MethodUsage)child.getData()).getName().equals(((MethodUsage)headNode.getData()).getName()) || !((MethodUsage)child.getData()).getNameSpace().equals(((MethodUsage)headNode.getData()).getNameSpace())) continue;
                if (headNode.getChildren().size() > 0) {
                    child.addHNode(headNode.getFirstChild());
                }
                mergedInGraph = true;
                break;
            }
            if (!mergedInGraph) {
                bottomUpGraph.addHNode(headNode);
            }
        }
        for (HNode n : topDownNode.getChildren()) {
            this.reverseTopDownGraph((HNode<MethodUsage>)n, bottomUpGraph, stack);
        }
        stack.pop();
    }

    private void generateTopDownGraphs() {
        this.myTopDownStats = new SparseArray();
        SparseArray<HNode<Method>> threadGraphs = this.getThreadsGraph();
        for (int i = 0; i < threadGraphs.size(); ++i) {
            int threadPid = threadGraphs.keyAt(i);
            HNode execGraph = (HNode)threadGraphs.get(threadPid);
            HNode usageGraphRoot = new HNode();
            usageGraphRoot.setStart(0L);
            usageGraphRoot.setEnd(execGraph.duration());
            usageGraphRoot.setData((Object)new MethodUsage());
            long totalDuration = usageGraphRoot.duration();
            this.mergeStackTraces((HNode<Method>)execGraph, (HNode<MethodUsage>)usageGraphRoot);
            this.generateStats((HNode<MethodUsage>)usageGraphRoot, totalDuration);
            this.myTopDownStats.put(threadPid, (Object)usageGraphRoot);
        }
    }

    private void mergeStackTraces(HNode<Method> execNode, HNode<MethodUsage> usageNode) {
        HNode<MethodUsage> methodUsageNode;
        for (HNode childExecNode : execNode.getChildren()) {
            methodUsageNode = this.findOrCopyNodeInUsageGraph((HNode<Method>)childExecNode, usageNode);
            ((MethodUsage)methodUsageNode.getData()).increaseInclusiveDuration(childExecNode.duration());
        }
        for (HNode childExecNode : execNode.getChildren()) {
            methodUsageNode = this.findNodeInUsageGraph((HNode<Method>)childExecNode, usageNode);
            this.mergeStackTraces((HNode<Method>)childExecNode, methodUsageNode);
        }
    }

    private void generateStats(HNode<MethodUsage> usageNode, long totalDuration) {
        long childTotalRuntime = 0L;
        for (HNode childExecNode : usageNode.getChildren()) {
            childTotalRuntime += ((MethodUsage)childExecNode.getData()).getInclusiveDuration();
        }
        long exlusiveDuration = ((MethodUsage)usageNode.getData()).getInclusiveDuration() - childTotalRuntime;
        ((MethodUsage)usageNode.getData()).setExclusiveDuration(exlusiveDuration);
        ((MethodUsage)usageNode.getData()).setExclusivePercentage((double)((float)exlusiveDuration / (float)totalDuration));
        if (childTotalRuntime == 0L) {
            return;
        }
        long cursor = usageNode.getStart();
        for (HNode childUsageNode : usageNode.getChildren()) {
            MethodUsage methodUsage = (MethodUsage)childUsageNode.getData();
            childUsageNode.setStart(cursor);
            childUsageNode.setEnd(cursor += methodUsage.getInclusiveDuration());
            methodUsage.setInclusivePercentage((double)((float)childUsageNode.duration() / (float)totalDuration));
        }
        for (HNode child : usageNode.getChildren()) {
            this.generateStats((HNode<MethodUsage>)child, totalDuration);
        }
    }

    private boolean methodEqual(Method m, MethodUsage mu) {
        return m.getName().equals(mu.getName()) && m.getNameSpace().equals(mu.getNameSpace());
    }

    private HNode<MethodUsage> findNodeInUsageGraph(HNode<Method> node, HNode<MethodUsage> usageGraph) {
        for (HNode prospect : usageGraph.getChildren()) {
            if (!this.methodEqual((Method)node.getData(), (MethodUsage)prospect.getData())) continue;
            return prospect;
        }
        return null;
    }

    private HNode<MethodUsage> findOrCopyNodeInUsageGraph(HNode<Method> node, HNode<MethodUsage> usageGraph) {
        HNode<MethodUsage> foundNode = this.findNodeInUsageGraph(node, usageGraph);
        if (foundNode != null) {
            return foundNode;
        }
        HNode newNode = new HNode();
        MethodUsage mu = new MethodUsage();
        if (node.getData() != null) {
            mu.setNamespace(((Method)node.getData()).getNameSpace());
            mu.setName(((Method)node.getData()).getName());
        }
        newNode.setData((Object)mu);
        newNode.setDepth(node.getDepth());
        usageGraph.addHNode(newNode);
        return newNode;
    }

    public SparseArray<JComponent> getTopDownTrees() {
        if (this.myTopdownTrees != null) {
            return this.myTopdownTrees;
        }
        this.myTopdownTrees = new SparseArray();
        SparseArray<HNode<MethodUsage>> threadStats = this.getTopdownStats();
        for (int i = 0; i < threadStats.size(); ++i) {
            int threadPid = threadStats.keyAt(i);
            JComponent tree = this.generateTopdownTree((HNode<MethodUsage>)((HNode)threadStats.get(threadStats.keyAt(i))));
            this.myTopdownTrees.put(threadPid, (Object)tree);
        }
        return this.myTopdownTrees;
    }

    private JComponent generateTopdownTree(HNode<MethodUsage> graph) {
        AppStatTreeNode top = new AppStatTreeNode();
        graph = graph.getFirstChild();
        this.convertGraphToTree((HNode<MethodUsage>)graph, top);
        JTree tree = new JTree(top);
        JComponent topdownColumnTree = new ColumnTreeBuilder(tree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Method").setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    3.$$$reportNull$$$0(0);
                }
                AppStatTreeNode node = (AppStatTreeNode)value;
                this.append(AppTrace.this.generateNameForColumn(node.getMethodNamespace(), node.getMethodName(), AppTrace.this.getSeparator()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/monitor/ui/cpu/model/AppTrace$3", "customizeCellRenderer"));
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Inclusive stats").setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    2.$$$reportNull$$$0(0);
                }
                AppStatTreeNode node = (AppStatTreeNode)value;
                this.append(String.format("%2.1f%%", node.getPercentageInclusive() * 100.0));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/monitor/ui/cpu/model/AppTrace$2", "customizeCellRenderer"));
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Exclusive stats").setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    1.$$$reportNull$$$0(0);
                }
                AppStatTreeNode node = (AppStatTreeNode)value;
                this.append(String.format("%2.1f%%", node.getPercentageExclusive() * 100.0));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/monitor/ui/cpu/model/AppTrace$1", "customizeCellRenderer"));
            }
        })).build();
        return topdownColumnTree;
    }

    private String generateNameForColumn(String namespace, String method, String separator) {
        if (method == null) {
            method = "";
        }
        if (namespace == null) {
            namespace = "";
        }
        if (namespace.isEmpty() || method.isEmpty()) {
            separator = "";
        }
        return namespace + separator + method;
    }

    public SparseArray<JComponent> getBottomUpTrees() {
        if (this.myBottomUpTrees != null) {
            return this.myBottomUpTrees;
        }
        this.myBottomUpTrees = new SparseArray();
        SparseArray<HNode<MethodUsage>> threadStats = this.getBottomupStats();
        for (int i = 0; i < threadStats.size(); ++i) {
            int threadPid = threadStats.keyAt(i);
            JComponent tree = this.generateBottomUpTree((HNode<MethodUsage>)((HNode)threadStats.get(threadStats.keyAt(i))));
            this.myBottomUpTrees.put(threadPid, (Object)tree);
        }
        return this.myBottomUpTrees;
    }

    private JComponent generateBottomUpTree(HNode<MethodUsage> graph) {
        AppStatTreeNode top = new AppStatTreeNode();
        this.convertGraphToTree(graph, top);
        JTree tree = new JTree(top);
        JComponent bottomUpColumnTree = new ColumnTreeBuilder(tree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Method").setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    5.$$$reportNull$$$0(0);
                }
                AppStatTreeNode node = (AppStatTreeNode)value;
                this.append(AppTrace.this.generateNameForColumn(node.getMethodNamespace(), node.getMethodName(), AppTrace.this.getSeparator()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/monitor/ui/cpu/model/AppTrace$5", "customizeCellRenderer"));
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Exclusive stats").setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    4.$$$reportNull$$$0(0);
                }
                AppStatTreeNode node = (AppStatTreeNode)value;
                this.append(String.format("%2.1f%%", node.getPercentageExclusive() * 100.0));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/monitor/ui/cpu/model/AppTrace$4", "customizeCellRenderer"));
            }
        })).build();
        return bottomUpColumnTree;
    }

    private void convertGraphToTree(HNode<MethodUsage> graph, AppStatTreeNode treeNode) {
        MethodUsage top = (MethodUsage)graph.getData();
        if (top != null) {
            treeNode.setPercentageInclusive(top.getInclusivePercentage());
            treeNode.setPercentageExclusive(top.getExclusivePercentage());
            treeNode.setRuntimeExclusive(top.getExclusiveDuration());
            treeNode.setRuntimeInclusive(top.getInclusiveDuration());
            treeNode.setMethodName(top.getName());
            treeNode.setMethodNamespace(top.getNameSpace());
        }
        for (HNode n : graph.getChildren()) {
            AppStatTreeNode newNode = new AppStatTreeNode();
            treeNode.add(newNode);
            this.convertGraphToTree((HNode<MethodUsage>)n, newNode);
        }
    }

    public static enum Source {
        ART,
        SIMPLEPERF;

    }
}

