/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.memory.view;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.model.Range;
import com.android.tools.datastore.DataAdapter;
import com.android.tools.datastore.Poller;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.datastore.SeriesDataType;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseProfilerUiManager;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.memory.model.AllocationTrackingSample;
import com.android.tools.idea.monitor.ui.memory.model.MemoryDataCache;
import com.android.tools.idea.monitor.ui.memory.model.MemoryPoller;
import com.android.tools.idea.monitor.ui.memory.view.MemoryDetailView;
import com.android.tools.idea.monitor.ui.memory.view.MemorySegment;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Component;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MemoryProfilerUiManager
extends BaseProfilerUiManager {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Client myClient;
    @NotNull
    private final EventDispatcher<MemoryEventListener> myMemoryEventDispatcher;
    @Nullable
    private MemoryDataCache myDataCache;
    private JButton myTriggerHeapDumpButton;
    private JToggleButton myAllocationTrackerButton;
    @Nullable
    private MemoryDetailView myMemoryDetailView;
    private volatile boolean myAllowAllocationTracking;

    public MemoryProfilerUiManager(@NotNull Range timeCurrentRangeUs, @NotNull Choreographer choreographer, @NotNull SeriesDataStore datastore, @NotNull EventDispatcher<ProfilerEventListener> eventDispatcher, @NotNull Project project, @NotNull Client client) {
        if (timeCurrentRangeUs == null) {
            MemoryProfilerUiManager.$$$reportNull$$$0(0);
        }
        if (choreographer == null) {
            MemoryProfilerUiManager.$$$reportNull$$$0(1);
        }
        if (datastore == null) {
            MemoryProfilerUiManager.$$$reportNull$$$0(2);
        }
        if (eventDispatcher == null) {
            MemoryProfilerUiManager.$$$reportNull$$$0(3);
        }
        if (project == null) {
            MemoryProfilerUiManager.$$$reportNull$$$0(4);
        }
        if (client == null) {
            MemoryProfilerUiManager.$$$reportNull$$$0(5);
        }
        super(timeCurrentRangeUs, choreographer, datastore, eventDispatcher);
        this.myAllowAllocationTracking = false;
        this.myProject = project;
        this.myClient = client;
        this.myMemoryEventDispatcher = EventDispatcher.create(MemoryEventListener.class);
    }

    @Override
    @NotNull
    public Set<Poller> createPollers(int pid) {
        this.myDataCache = new MemoryDataCache(this.myMemoryEventDispatcher);
        MemoryPoller poller = new MemoryPoller(this.myDataStore, this.myDataCache, pid);
        Map<SeriesDataType, DataAdapter> adapters = poller.createAdapters();
        for (Map.Entry<SeriesDataType, DataAdapter> entry : adapters.entrySet()) {
            this.myDataStore.registerAdapter(entry.getKey(), entry.getValue());
        }
        if (this.myMemoryDetailView != null) {
            this.myMemoryDetailView.notifyDataIsReady(this.myDataCache);
        }
        HashSet hashSet = Sets.newHashSet((Object[])new Poller[]{poller});
        if (hashSet == null) {
            MemoryProfilerUiManager.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @Override
    @NotNull
    protected BaseSegment createOverviewSegment(@NotNull Range timeCurrentRangeUs, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> eventDispatcher) {
        if (timeCurrentRangeUs == null) {
            MemoryProfilerUiManager.$$$reportNull$$$0(7);
        }
        if (dataStore == null) {
            MemoryProfilerUiManager.$$$reportNull$$$0(8);
        }
        if (eventDispatcher == null) {
            MemoryProfilerUiManager.$$$reportNull$$$0(9);
        }
        MemorySegment memorySegment = new MemorySegment(timeCurrentRangeUs, dataStore, eventDispatcher);
        if (memorySegment == null) {
            MemoryProfilerUiManager.$$$reportNull$$$0(10);
        }
        return memorySegment;
    }

    @Override
    public void setupExtendedOverviewUi(@NotNull JPanel toolbar, @NotNull JPanel overviewPanel) {
        if (toolbar == null) {
            MemoryProfilerUiManager.$$$reportNull$$$0(11);
        }
        if (overviewPanel == null) {
            MemoryProfilerUiManager.$$$reportNull$$$0(12);
        }
        super.setupExtendedOverviewUi(toolbar, overviewPanel);
        assert (this.myPollerSet != null);
        this.myTriggerHeapDumpButton = new JButton(AndroidIcons.Ddms.DumpHprof);
        MemoryPoller poller = (MemoryPoller)((Object)Iterables.getOnlyElement((Iterable)this.myPollerSet));
        this.myTriggerHeapDumpButton.addActionListener(e -> {
            if (poller.requestHeapDump()) {
                ((ProfilerEventListener)this.myEventDispatcher.getMulticaster()).profilerExpanded(BaseProfilerUiManager.ProfilerType.MEMORY);
            }
        });
        toolbar.add((Component)this.myTriggerHeapDumpButton, "LEFT");
        this.myAllowAllocationTracking = true;
        this.myAllocationTrackerButton = new JToggleButton(AndroidIcons.Ddms.AllocationTracker, false);
        this.myClient.enableAllocationTracker(false);
        this.myAllocationTrackerButton.addActionListener(e -> {
            boolean selected = this.myAllocationTrackerButton.isSelected();
            if (selected) {
                if (!this.myAllowAllocationTracking) {
                    this.myAllocationTrackerButton.setSelected(false);
                    return;
                }
                this.myAllowAllocationTracking = false;
                this.myClient.enableAllocationTracker(true);
                final long startTime = TimeUnit.NANOSECONDS.toMicros(this.myDataStore.mapAbsoluteDeviceToRelativeTime(TimeUnit.MICROSECONDS.toNanos(this.myDataStore.getLatestTimeUs())));
                AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)new AndroidDebugBridge.IClientChangeListener(){

                    public void clientChanged(Client client, int changeMask) {
                        if (client == MemoryProfilerUiManager.this.myClient && (changeMask & 0x200) != 0) {
                            byte[] data = client.getClientData().getAllocationsData();
                            long endTime = TimeUnit.NANOSECONDS.toMicros(MemoryProfilerUiManager.this.myDataStore.mapAbsoluteDeviceToRelativeTime(TimeUnit.MICROSECONDS.toNanos(MemoryProfilerUiManager.this.myDataStore.getLatestTimeUs())));
                            UIUtil.invokeLaterIfNeeded(() -> {
                                ((ProfilerEventListener)MemoryProfilerUiManager.this.myEventDispatcher.getMulticaster()).profilerExpanded(BaseProfilerUiManager.ProfilerType.MEMORY);
                                if (MemoryProfilerUiManager.this.myProject.isDisposed()) {
                                    return;
                                }
                                if (MemoryProfilerUiManager.this.myDataCache != null) {
                                    MemoryProfilerUiManager.this.myDataCache.addAllocationTrackingData(new AllocationTrackingSample(startTime, endTime, data));
                                }
                            });
                            MemoryProfilerUiManager.this.myAllowAllocationTracking = true;
                            AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
                        }
                    }
                });
            } else {
                this.myClient.requestAllocationDetails();
                this.myClient.enableAllocationTracker(false);
            }
            this.myAllocationTrackerButton.updateUI();
        });
        toolbar.add((Component)this.myAllocationTrackerButton, "LEFT");
    }

    @Override
    public void setupDetailedViewUi(@NotNull JPanel toolbar, @NotNull JPanel detailPanel) {
        if (toolbar == null) {
            MemoryProfilerUiManager.$$$reportNull$$$0(13);
        }
        if (detailPanel == null) {
            MemoryProfilerUiManager.$$$reportNull$$$0(14);
        }
        this.myMemoryDetailView = new MemoryDetailView(detailPanel, this.myDataStore, this.myDataCache, this.myTimeCurrentRangeUs, this.myChoreographer, (EventDispatcher<ProfilerEventListener>)this.myEventDispatcher, this.myMemoryEventDispatcher);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myMemoryDetailView);
    }

    @Override
    public void resetProfiler(@NotNull JPanel toolbar, @NotNull JPanel overviewPanel, @NotNull JPanel detailPanel) {
        if (toolbar == null) {
            MemoryProfilerUiManager.$$$reportNull$$$0(15);
        }
        if (overviewPanel == null) {
            MemoryProfilerUiManager.$$$reportNull$$$0(16);
        }
        if (detailPanel == null) {
            MemoryProfilerUiManager.$$$reportNull$$$0(17);
        }
        super.resetProfiler(toolbar, overviewPanel, detailPanel);
        if (this.myMemoryDetailView != null) {
            Disposer.dispose((Disposable)this.myMemoryDetailView);
            this.myMemoryDetailView = null;
        }
        if (this.myTriggerHeapDumpButton != null) {
            toolbar.remove(this.myTriggerHeapDumpButton);
            this.myTriggerHeapDumpButton = null;
        }
        if (this.myAllocationTrackerButton != null) {
            toolbar.remove(this.myAllocationTrackerButton);
            this.myAllocationTrackerButton = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "choreographer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "datastore";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventDispatcher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/monitor/ui/memory/view/MemoryProfilerUiManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStore";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbar";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overviewPanel";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/monitor/ui/memory/view/MemoryProfilerUiManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPollers";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createOverviewSegment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 10: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createOverviewSegment";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setupExtendedOverviewUi";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setupDetailedViewUi";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resetProfiler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface MemoryEventListener
    extends EventListener {
        public void newHeapDumpInfosRetrieved(MemoryProfiler.HeapDumpInfo var1);

        public void newAllocationTrackingInfosRetrieved(AllocationTrackingSample var1);
    }
}

