/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.assetstudiolib.GraphicGenerator;
import com.android.assetstudiolib.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;

public final class AssetStudioGraphicGeneratorContext
implements GraphicGeneratorContext {
    private static Cache<String, BufferedImage> ourImageCache = CacheBuilder.newBuilder().build();

    private static Logger getLog() {
        return Logger.getInstance(AssetStudioGraphicGeneratorContext.class);
    }

    @NotNull
    private static BufferedImage getStencilImage(@NotNull String path) throws IOException {
        BufferedImage image;
        if (path == null) {
            AssetStudioGraphicGeneratorContext.$$$reportNull$$$0(0);
        }
        if ((image = GraphicGenerator.getStencilImage((String)path)) == null) {
            image = AssetStudioUtils.createDummyImage();
        }
        BufferedImage bufferedImage = image;
        if (bufferedImage == null) {
            AssetStudioGraphicGeneratorContext.$$$reportNull$$$0(1);
        }
        return bufferedImage;
    }

    public BufferedImage loadImageResource(final @NotNull String path) {
        if (path == null) {
            AssetStudioGraphicGeneratorContext.$$$reportNull$$$0(2);
        }
        try {
            return (BufferedImage)ourImageCache.get((Object)path, (Callable)new Callable<BufferedImage>(){

                @Override
                public BufferedImage call() throws Exception {
                    return AssetStudioGraphicGeneratorContext.getStencilImage(path);
                }
            });
        }
        catch (ExecutionException e) {
            AssetStudioGraphicGeneratorContext.getLog().error((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/AssetStudioGraphicGeneratorContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/AssetStudioGraphicGeneratorContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStencilImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStencilImage";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadImageResource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

