/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.icon;

import com.android.assetstudiolib.NotificationIconGenerator;
import com.android.resources.Density;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CategoryIconMap {
    private static final Filter ACCEPT_ALL = new Filter(){

        @Override
        public boolean accept(@NotNull String category) {
            if (category == null) {
                1.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/android/tools/idea/npw/assetstudio/icon/CategoryIconMap$1", "accept"));
        }
    };
    private static final Map<Density, Pattern> DENSITY_PATTERNS;
    @NotNull
    private final Map<String, Map<String, BufferedImage>> myCategoryMap;

    public CategoryIconMap(@NotNull Map<String, Map<String, BufferedImage>> categoryMap) {
        if (categoryMap == null) {
            CategoryIconMap.$$$reportNull$$$0(0);
        }
        this.myCategoryMap = categoryMap;
    }

    @Nullable
    public static Density pathToDensity(@NotNull String iconPath) {
        if (iconPath == null) {
            CategoryIconMap.$$$reportNull$$$0(1);
        }
        iconPath = FileUtil.toSystemIndependentName((String)iconPath);
        iconPath = iconPath.substring(0, iconPath.lastIndexOf(47) + 1);
        for (Density density : Density.values()) {
            if (!DENSITY_PATTERNS.get(density).matcher(iconPath).matches()) continue;
            return density;
        }
        return null;
    }

    @NotNull
    public Map<Density, BufferedImage> toDensityMap() {
        Map<Density, BufferedImage> map = this.toDensityMap(ACCEPT_ALL);
        if (map == null) {
            CategoryIconMap.$$$reportNull$$$0(2);
        }
        return map;
    }

    @NotNull
    public Map<Density, BufferedImage> toDensityMap(@NotNull Filter filter) {
        if (filter == null) {
            CategoryIconMap.$$$reportNull$$$0(3);
        }
        HashMap densityImageMap = Maps.newHashMap();
        for (String category : this.myCategoryMap.keySet()) {
            if (!filter.accept(category)) continue;
            Map<String, BufferedImage> pathImageMap = this.myCategoryMap.get(category);
            for (String path : pathImageMap.keySet()) {
                Density density = CategoryIconMap.pathToDensity(path);
                if (density == null) continue;
                BufferedImage image = pathImageMap.get(path);
                densityImageMap.put(density, image);
            }
        }
        HashMap hashMap = densityImageMap;
        if (hashMap == null) {
            CategoryIconMap.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    @NotNull
    public Map<File, BufferedImage> toFileMap(@NotNull File rootDir) {
        if (rootDir == null) {
            CategoryIconMap.$$$reportNull$$$0(5);
        }
        HashMap outputMap = Maps.newHashMap();
        for (Map<String, BufferedImage> pathImageMap : this.myCategoryMap.values()) {
            for (Map.Entry<String, BufferedImage> pathImageEntry : pathImageMap.entrySet()) {
                outputMap.put(new File(rootDir, pathImageEntry.getKey()), pathImageEntry.getValue());
            }
        }
        HashMap hashMap = outputMap;
        if (hashMap == null) {
            CategoryIconMap.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Density density : Density.values()) {
            builder.put((Object)density, (Object)Pattern.compile(String.format(".*[^a-z]%s[^a-z].*", density.getResourceValue()), 2));
        }
        DENSITY_PATTERNS = builder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryMap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconPath";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/icon/CategoryIconMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/icon/CategoryIconMap";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toDensityMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toFileMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "pathToDensity";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toDensityMap";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toFileMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class NotificationFilter
    implements Filter {
        @NotNull
        private final NotificationIconGenerator.Version myVersion;

        public NotificationFilter(@NotNull NotificationIconGenerator.Version version) {
            if (version == null) {
                NotificationFilter.$$$reportNull$$$0(0);
            }
            this.myVersion = version;
        }

        @Override
        public boolean accept(@NotNull String category) {
            if (category == null) {
                NotificationFilter.$$$reportNull$$$0(1);
            }
            return this.myVersion.getDisplayName().equals(category);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "category";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/npw/assetstudio/icon/CategoryIconMap$NotificationFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Filter {
        public boolean accept(@NotNull String var1);
    }
}

