/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepositoryRootListener;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectResourceRepository
extends MultiResourceRepository {
    private final AndroidFacet myFacet;

    private ProjectResourceRepository(@NotNull AndroidFacet facet, @NotNull List<? extends LocalResourceRepository> delegates) {
        if (facet == null) {
            ProjectResourceRepository.$$$reportNull$$$0(0);
        }
        if (delegates == null) {
            ProjectResourceRepository.$$$reportNull$$$0(1);
        }
        super(facet.getModule().getName() + " with modules", delegates);
        this.myFacet = facet;
    }

    @Nullable
    public static ProjectResourceRepository getProjectResources(@NotNull Module module, boolean createIfNecessary) {
        AndroidFacet facet;
        if (module == null) {
            ProjectResourceRepository.$$$reportNull$$$0(2);
        }
        if ((facet = AndroidFacet.getInstance(module)) != null) {
            return facet.getProjectResources(createIfNecessary);
        }
        return null;
    }

    @Contract(value="!null, true -> !null")
    @Nullable
    public static ProjectResourceRepository getProjectResources(@NotNull AndroidFacet facet, boolean createIfNecessary) {
        if (facet == null) {
            ProjectResourceRepository.$$$reportNull$$$0(3);
        }
        return facet.getProjectResources(createIfNecessary);
    }

    @NotNull
    public static ProjectResourceRepository create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ProjectResourceRepository.$$$reportNull$$$0(4);
        }
        List<LocalResourceRepository> resources = ProjectResourceRepository.computeRepositories(facet);
        ProjectResourceRepository repository = new ProjectResourceRepository(facet, resources);
        ProjectResourceRepositoryRootListener.ensureSubscribed(facet.getModule().getProject());
        ProjectResourceRepository projectResourceRepository = repository;
        if (projectResourceRepository == null) {
            ProjectResourceRepository.$$$reportNull$$$0(5);
        }
        return projectResourceRepository;
    }

    private static List<LocalResourceRepository> computeRepositories(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ProjectResourceRepository.$$$reportNull$$$0(6);
        }
        LocalResourceRepository main = ModuleResourceRepository.getModuleResources(facet, true);
        List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
        if (dependentFacets.isEmpty()) {
            return Collections.singletonList(main);
        }
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)dependentFacets.size());
        for (AndroidFacet f : dependentFacets) {
            LocalResourceRepository r = ModuleResourceRepository.getModuleResources(f, true);
            resources.add(r);
        }
        resources.add(main);
        return resources;
    }

    void updateRoots() {
        List<LocalResourceRepository> repositories = ProjectResourceRepository.computeRepositories(this.myFacet);
        this.updateRoots(repositories);
    }

    void updateRoots(List<LocalResourceRepository> resourceDirectories) {
        this.invalidateResourceDirs();
        if (!resourceDirectories.equals(this.myChildren)) {
            this.setChildren(resourceDirectories);
        }
    }

    @NotNull
    static ProjectResourceRepository createForTest(AndroidFacet facet, List<LocalResourceRepository> modules) {
        ProjectResourceRepository projectResourceRepository = new ProjectResourceRepository(facet, modules);
        if (projectResourceRepository == null) {
            ProjectResourceRepository.$$$reportNull$$$0(7);
        }
        return projectResourceRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegates";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ProjectResourceRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ProjectResourceRepository";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createForTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProjectResources";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeRepositories";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

