/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractInstaller;
import com.android.repository.impl.meta.Archive;
import com.android.repository.io.FileOp;
import com.android.repository.util.InstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchOperation;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PatchInstaller
extends AbstractInstaller
implements PatchOperation {
    private static final String PATCH_JAR_FN = "patch.jar";
    private LocalPackage myExisting;
    private File myPatchFile;

    public PatchInstaller(@Nullable LocalPackage existing, @NotNull RemotePackage p, @NotNull Downloader downloader, @NotNull RepoManager mgr, @NotNull FileOp fop) {
        if (p == null) {
            PatchInstaller.$$$reportNull$$$0(0);
        }
        if (downloader == null) {
            PatchInstaller.$$$reportNull$$$0(1);
        }
        if (mgr == null) {
            PatchInstaller.$$$reportNull$$$0(2);
        }
        if (fop == null) {
            PatchInstaller.$$$reportNull$$$0(3);
        }
        super(p, mgr, downloader, fop);
        this.myExisting = existing;
    }

    protected boolean doComplete(@Nullable File installTemp, @NotNull ProgressIndicator progress) {
        if (progress == null) {
            PatchInstaller.$$$reportNull$$$0(4);
        }
        if (this.myPatchFile == null) {
            this.myPatchFile = new File(installTemp, PATCH_JAR_FN);
        }
        return PatchInstallerUtil.installPatch(this, this.myPatchFile, this.mFop, progress);
    }

    protected boolean doPrepare(@NotNull File tempDir, @NotNull ProgressIndicator progress) {
        if (tempDir == null) {
            PatchInstaller.$$$reportNull$$$0(5);
        }
        if (progress == null) {
            PatchInstaller.$$$reportNull$$$0(6);
        }
        LocalPackage local = (LocalPackage)this.getRepoManager().getPackages().getLocalPackages().get(this.getPackage().getPath());
        Archive archive = this.getPackage().getArchive();
        assert (archive != null);
        Archive.PatchType patch = archive.getPatch(local.getVersion());
        assert (patch != null);
        this.myPatchFile = this.downloadPatchFile(patch, tempDir, progress);
        if (this.myPatchFile == null) {
            progress.logWarning("Patch failed to download.");
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public LocalPackage getExisting() {
        return this.myExisting;
    }

    @Override
    @Nullable
    public LocalPackage getPatcher(@NotNull ProgressIndicator progress) {
        LocalPackage dependantPatcher;
        if (progress == null) {
            PatchInstaller.$$$reportNull$$$0(7);
        }
        if ((dependantPatcher = PatchInstallerUtil.getDependantPatcher(this.getPackage(), this.getRepoManager())) == null) {
            dependantPatcher = this.tryToCompletePatcherInstall(progress);
        }
        if (dependantPatcher == null) {
            progress.logWarning("Failed to find SDK Patch Applier!");
        }
        return dependantPatcher;
    }

    @Nullable
    private LocalPackage tryToCompletePatcherInstall(@NotNull ProgressIndicator progress) {
        PackageOperation op;
        if (progress == null) {
            PatchInstaller.$$$reportNull$$$0(8);
        }
        if ((op = PatchInstallerUtil.getInProgressDependantPatcherInstall(this.getPackage(), this.getRepoManager())) != null && op.getInstallStatus() == PackageOperation.InstallStatus.PREPARED) {
            op.complete(progress);
        }
        this.getRepoManager().reloadLocalIfNeeded(progress);
        return PatchInstallerUtil.getDependantPatcher(this.getPackage(), this.getRepoManager());
    }

    @Override
    @NotNull
    public File getNewFilesRoot() {
        throw new UnsupportedOperationException("PatchInstaller can't generate patches");
    }

    @Override
    @NotNull
    public String getNewVersionName() {
        String string = this.getPackage().getDisplayName() + " Version " + this.getPackage().getVersion();
        if (string == null) {
            PatchInstaller.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    private File downloadPatchFile(@NotNull Archive.PatchType patch, @NotNull File tempDir, @NotNull ProgressIndicator progress) {
        URL url;
        if (patch == null) {
            PatchInstaller.$$$reportNull$$$0(10);
        }
        if (tempDir == null) {
            PatchInstaller.$$$reportNull$$$0(11);
        }
        if (progress == null) {
            PatchInstaller.$$$reportNull$$$0(12);
        }
        if ((url = InstallerUtil.resolveUrl((String)patch.getUrl(), (RemotePackage)this.getPackage(), (ProgressIndicator)progress)) == null) {
            progress.logWarning("Failed to resolve URL: " + patch.getUrl());
            return null;
        }
        try {
            File patchFile = new File(tempDir, PATCH_JAR_FN);
            this.getDownloader().downloadFully(url, patchFile, patch.getChecksum(), progress);
            return patchFile;
        }
        catch (IOException e) {
            progress.logWarning("Error during downloading", (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mgr";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fop";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempDir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/install/patch/PatchInstaller";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/install/patch/PatchInstaller";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewVersionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doComplete";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doPrepare";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPatcher";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryToCompletePatcherInstall";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "downloadPatchFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

