/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOp;
import com.android.tools.idea.sdk.install.patch.PatchInstaller;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.UrlClassLoader;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchRunner {
    private static final String PATCHER_JAR_FN = "patcher.jar";
    private static final String RUNNER_CLASS_NAME = "com.intellij.updater.Runner";
    private static final String UPDATER_UI_CLASS_NAME = "com.intellij.updater.UpdaterUI";
    private static final String REPO_UI_CLASS_NAME = "com.android.tools.idea.sdk.updater.RepoUpdaterUI";
    private static final String PATCH_GENERATOR_CLASS_NAME = "com.android.tools.idea.sdk.updater.PatchGenerator";
    private final Class myRunnerClass;
    private final Class myUiBaseClass;
    private final Class myUiClass;
    private final Class myGeneratorClass;
    private final File myPatcherJar;
    private static Map<LocalPackage, PatchRunner> ourCache = ContainerUtil.createWeakMap();

    @Nullable
    public static PatchRunner getPatchRunner(@NotNull LocalPackage runnerPackage, @NotNull ProgressIndicator progress, @NotNull FileOp fop) {
        PatchRunner result;
        if (runnerPackage == null) {
            PatchRunner.$$$reportNull$$$0(0);
        }
        if (progress == null) {
            PatchRunner.$$$reportNull$$$0(1);
        }
        if (fop == null) {
            PatchRunner.$$$reportNull$$$0(2);
        }
        if ((result = ourCache.get(runnerPackage)) != null) {
            return result;
        }
        try {
            File patcherFile = PatchRunner.getPatcherFile(runnerPackage, fop);
            if (patcherFile == null) {
                progress.logWarning("Failed to find patcher JAR!");
                return null;
            }
            ClassLoader loader = PatchRunner.getClassLoader(patcherFile, progress);
            Class<?> runnerClass = Class.forName(RUNNER_CLASS_NAME, true, loader);
            Class<?> uiBaseClass = Class.forName(UPDATER_UI_CLASS_NAME, true, loader);
            Class<?> uiClass = Class.forName(REPO_UI_CLASS_NAME, true, loader);
            Class<?> generatorClass = Class.forName(PATCH_GENERATOR_CLASS_NAME, true, loader);
            result = new PatchRunner(patcherFile, runnerClass, uiBaseClass, uiClass, generatorClass);
        }
        catch (ClassNotFoundException e) {
            progress.logWarning("Failed to load patcher classes!");
            return null;
        }
        ourCache.put(runnerPackage, result);
        return result;
    }

    public boolean run(@NotNull File destination, @NotNull File patchFile, @NotNull ProgressIndicator progress) throws RestartRequiredException {
        Method doInstall;
        Object ui;
        if (destination == null) {
            PatchRunner.$$$reportNull$$$0(3);
        }
        if (patchFile == null) {
            PatchRunner.$$$reportNull$$$0(4);
        }
        if (progress == null) {
            PatchRunner.$$$reportNull$$$0(5);
        }
        try {
            ui = this.myUiClass.getConstructor(Component.class, ProgressIndicator.class).newInstance(null, progress);
        }
        catch (ReflectiveOperationException e) {
            progress.logWarning("Failed to create updater UI!", (Throwable)e);
            return false;
        }
        try {
            Method initLogger = this.myRunnerClass.getMethod("initLogger", new Class[0]);
            initLogger.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            progress.logWarning("Failed to initialize logger!", (Throwable)e);
            return false;
        }
        try {
            doInstall = this.myRunnerClass.getMethod("doInstall", String.class, this.myUiBaseClass, String.class);
        }
        catch (Throwable e) {
            progress.logWarning("Failed to find main method in runner!", e);
            return false;
        }
        try {
            progress.logInfo("Running patcher...");
            if (!((Boolean)doInstall.invoke(null, patchFile.getPath(), ui, destination.getPath())).booleanValue()) {
                progress.logWarning("Failed to apply patch");
                return false;
            }
            progress.logInfo("Patch applied.");
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RestartRequiredException) {
                throw (RestartRequiredException)e.getTargetException();
            }
            progress.logWarning("Failed to run patcher", (Throwable)e);
            return false;
        }
        catch (Throwable e) {
            progress.logWarning("Failed to run patcher", e);
            return false;
        }
        return true;
    }

    public boolean generatePatch(@Nullable File existingRoot, @NotNull File newRoot, @Nullable String existingDescription, @NotNull String newDescription, @NotNull File destination, @NotNull ProgressIndicator progress) {
        if (newRoot == null) {
            PatchRunner.$$$reportNull$$$0(6);
        }
        if (newDescription == null) {
            PatchRunner.$$$reportNull$$$0(7);
        }
        if (destination == null) {
            PatchRunner.$$$reportNull$$$0(8);
        }
        if (progress == null) {
            PatchRunner.$$$reportNull$$$0(9);
        }
        try {
            Method generateMethod = this.myGeneratorClass.getMethod("generateFullPackage", File.class, File.class, File.class, String.class, String.class, ProgressIndicator.class);
            return (Boolean)generateMethod.invoke(null, newRoot, existingRoot, destination, existingDescription, newDescription, progress);
        }
        catch (NoSuchMethodException e) {
            progress.logWarning("Patcher doesn't support full package generation!");
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable reason = e.getTargetException();
            progress.logWarning("Patch invocation failed! " + reason);
            if (reason != null) {
                reason.printStackTrace();
            }
            return false;
        }
        catch (IllegalAccessException e) {
            progress.logWarning("Patch generation failed!");
            return false;
        }
    }

    @Nullable
    private static File getPatcherFile(@Nullable LocalPackage patcherPackage, @NotNull FileOp fop) {
        if (fop == null) {
            PatchRunner.$$$reportNull$$$0(10);
        }
        File patcherFile = patcherPackage == null ? null : new File(patcherPackage.getLocation(), PATCHER_JAR_FN);
        return patcherFile != null && fop.exists(patcherFile) ? patcherFile : null;
    }

    @VisibleForTesting
    PatchRunner(@NotNull File jarFile, @NotNull Class runnerClass, @NotNull Class uiBaseClass, @NotNull Class uiClass, @NotNull Class generatorClass) throws ClassNotFoundException {
        if (jarFile == null) {
            PatchRunner.$$$reportNull$$$0(11);
        }
        if (runnerClass == null) {
            PatchRunner.$$$reportNull$$$0(12);
        }
        if (uiBaseClass == null) {
            PatchRunner.$$$reportNull$$$0(13);
        }
        if (uiClass == null) {
            PatchRunner.$$$reportNull$$$0(14);
        }
        if (generatorClass == null) {
            PatchRunner.$$$reportNull$$$0(15);
        }
        this.myPatcherJar = jarFile;
        this.myRunnerClass = runnerClass;
        this.myUiBaseClass = uiBaseClass;
        this.myUiClass = uiClass;
        this.myGeneratorClass = generatorClass;
    }

    @NotNull
    private static ClassLoader getClassLoader(@NotNull File patcherJar, @NotNull ProgressIndicator progress) {
        UrlClassLoader loader;
        if (patcherJar == null) {
            PatchRunner.$$$reportNull$$$0(16);
        }
        if (progress == null) {
            PatchRunner.$$$reportNull$$$0(17);
        }
        try {
            loader = UrlClassLoader.build().urls(new URL[]{patcherJar.toURI().toURL()}).parent(PatchInstaller.class.getClassLoader()).get();
        }
        catch (MalformedURLException e) {
            throw new AssertionError("Failed to create URL from file: " + patcherJar, e);
        }
        UrlClassLoader urlClassLoader = loader;
        if (urlClassLoader == null) {
            PatchRunner.$$$reportNull$$$0(18);
        }
        return urlClassLoader;
    }

    @NotNull
    public File getPatcherJar() {
        File file = this.myPatcherJar;
        if (file == null) {
            PatchRunner.$$$reportNull$$$0(19);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerPackage";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fop";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDescription";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiBaseClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatorClass";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patcherJar";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/install/patch/PatchRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/install/patch/PatchRunner";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassLoader";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatcherJar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPatchRunner";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generatePatch";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPatcherFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getClassLoader";
                break;
            }
            case 18: 
            case 19: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RestartRequiredException
    extends RuntimeException {
    }
}

