/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.analytics;

import com.android.sdklib.devices.State;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderErrorModelFactory;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.uibuilder.analytics.NlUsageTracker;
import com.android.tools.idea.uibuilder.analytics.NopTracker;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorRenderResult;
import com.google.wireless.android.sdk.stats.LayoutEditorState;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import java.lang.ref.WeakReference;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlUsageTrackerManager
implements NlUsageTracker {
    static final NlUsageTracker NOP_TRACKER = new NopTracker();
    private static final int LOG_RENDER_PERCENT = 10;
    private static final Cache<DesignSurface, NlUsageTracker> sTrackersCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private static ExecutorService ourExecutorService = new ThreadPoolExecutor(0, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(10));
    private static final Random sRandom = new Random();
    private final Executor myExecutor;
    private final WeakReference<DesignSurface> myDesignSurfaceRef;
    private final UsageTracker myUsageTracker;

    NlUsageTrackerManager(@NotNull Executor executor, @Nullable DesignSurface surface, @NotNull UsageTracker usageTracker) {
        if (executor == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(0);
        }
        if (usageTracker == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(1);
        }
        this.myExecutor = executor;
        this.myDesignSurfaceRef = new WeakReference<DesignSurface>(surface);
        this.myUsageTracker = usageTracker;
    }

    @NotNull
    static NlUsageTracker getInstanceInner(@Nullable DesignSurface surface) {
        NlUsageTracker nlUsageTracker;
        if (surface == null) {
            NlUsageTracker nlUsageTracker2 = NOP_TRACKER;
            if (nlUsageTracker2 == null) {
                NlUsageTrackerManager.$$$reportNull$$$0(2);
            }
            return nlUsageTracker2;
        }
        try {
            nlUsageTracker = (NlUsageTracker)sTrackersCache.get((Object)surface, () -> new NlUsageTrackerManager(ourExecutorService, surface, UsageTracker.getInstance()));
        }
        catch (ExecutionException e) {
            assert (false);
            NlUsageTracker nlUsageTracker3 = NOP_TRACKER;
            if (nlUsageTracker3 == null) {
                NlUsageTrackerManager.$$$reportNull$$$0(4);
            }
            return nlUsageTracker3;
        }
        if (nlUsageTracker == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(3);
        }
        return nlUsageTracker;
    }

    @NotNull
    public static NlUsageTracker getInstance(@Nullable DesignSurface surface) {
        NlUsageTracker nlUsageTracker = UsageTracker.getInstance().getAnalyticsSettings().hasOptedIn() ? NlUsageTrackerManager.getInstanceInner(surface) : NOP_TRACKER;
        if (nlUsageTracker == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(5);
        }
        return nlUsageTracker;
    }

    @NotNull
    static LayoutEditorState getState(@Nullable DesignSurface surface) {
        Configuration configuration;
        LayoutEditorState.Builder builder = LayoutEditorState.newBuilder();
        if (surface == null) {
            LayoutEditorState layoutEditorState = builder.build();
            if (layoutEditorState == null) {
                NlUsageTrackerManager.$$$reportNull$$$0(6);
            }
            return layoutEditorState;
        }
        builder.setMode(surface.isPreviewSurface() ? LayoutEditorState.Mode.PREVIEW_MODE : LayoutEditorState.Mode.DESIGN_MODE);
        switch (surface.getLayoutType()) {
            case DRAWABLE: {
                builder.setType(LayoutEditorState.Type.DRAWABLE);
                break;
            }
            case LAYOUT: {
                builder.setType(LayoutEditorState.Type.LAYOUT);
                break;
            }
            case MENU: {
                builder.setType(LayoutEditorState.Type.MENU);
                break;
            }
            case PREFERENCE_SCREEN: {
                builder.setType(LayoutEditorState.Type.PREFERENCE_SCREEN);
                break;
            }
        }
        double scale = surface.getScale();
        if (SystemInfo.isMac && UIUtil.isRetina()) {
            scale *= 2.0;
        }
        if ((configuration = surface.getConfiguration()) != null) {
            State deviceState = configuration.getDeviceState();
            if (deviceState != null) {
                switch (deviceState.getOrientation()) {
                    case PORTRAIT: {
                        builder.setConfigOrientation(LayoutEditorState.Orientation.PORTRAIT);
                        break;
                    }
                    case LANDSCAPE: {
                        builder.setConfigOrientation(LayoutEditorState.Orientation.LANDSCAPE);
                        break;
                    }
                }
            }
            if (configuration.getTarget() != null) {
                builder.setConfigApiLevel(configuration.getTarget().getVersion().getApiString());
            }
        }
        if (scale >= 0.0) {
            builder.setConfigZoomLevel((int)(scale * 100.0));
        }
        switch (surface.getScreenMode()) {
            case SCREEN_ONLY: {
                builder.setSurfaces(LayoutEditorState.Surfaces.SCREEN_SURFACE);
                break;
            }
            case BLUEPRINT_ONLY: {
                builder.setSurfaces(LayoutEditorState.Surfaces.BLUEPRINT_SURFACE);
                break;
            }
            case BOTH: {
                builder.setSurfaces(LayoutEditorState.Surfaces.BOTH);
            }
        }
        LayoutEditorState layoutEditorState = builder.build();
        if (layoutEditorState == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(7);
        }
        return layoutEditorState;
    }

    boolean shouldLog(int percent) {
        return sRandom.nextInt(100) >= 100 - percent - 1;
    }

    private void logStudioEvent(@NotNull LayoutEditorEvent.LayoutEditorEventType eventType, @Nullable Consumer<LayoutEditorEvent.Builder> consumer) {
        if (eventType == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(8);
        }
        try {
            this.myExecutor.execute(() -> {
                if (eventType == null) {
                    NlUsageTrackerManager.$$$reportNull$$$0(12);
                }
                LayoutEditorEvent.Builder builder = LayoutEditorEvent.newBuilder().setType(eventType).setState(NlUsageTrackerManager.getState((DesignSurface)this.myDesignSurfaceRef.get()));
                if (consumer != null) {
                    consumer.accept(builder);
                }
                AndroidStudioEvent.Builder studioEvent = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.LAYOUT_EDITOR).setKind(AndroidStudioEvent.EventKind.LAYOUT_EDITOR_EVENT).setLayoutEditorEvent(builder.build());
                this.myUsageTracker.log(studioEvent);
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public void logAction(@NotNull LayoutEditorEvent.LayoutEditorEventType eventType) {
        if (eventType == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(9);
        }
        assert (!LayoutEditorEvent.LayoutEditorEventType.RENDER.equals((Object)eventType)) : "RENDER actions should be logged through logRenderResult";
        this.logStudioEvent(eventType, null);
    }

    @Override
    public void logRenderResult(@Nullable NlModel.ChangeType trigger, @NotNull RenderResult result, long totalRenderTimeMs) {
        if (result == null) {
            NlUsageTrackerManager.$$$reportNull$$$0(10);
        }
        if (!this.shouldLog(10)) {
            return;
        }
        this.logStudioEvent(LayoutEditorEvent.LayoutEditorEventType.RENDER, builder -> {
            void event;
            if (result == null) {
                NlUsageTrackerManager.$$$reportNull$$$0(11);
            }
            LayoutEditorRenderResult.Builder builder2 = LayoutEditorRenderResult.newBuilder().setResultCode(result.getRenderResult().getStatus().ordinal()).setTotalRenderTimeMs(totalRenderTimeMs);
            if (trigger != null) {
                switch (trigger) {
                    case RESOURCE_EDIT: 
                    case RESOURCE_CHANGED: {
                        builder2.setTrigger(LayoutEditorRenderResult.Trigger.RESOURCE_CHANGE);
                        break;
                    }
                    case EDIT: 
                    case ADD_COMPONENTS: 
                    case DELETE: 
                    case DND_COMMIT: 
                    case DND_END: 
                    case DROP: 
                    case RESIZE_END: 
                    case RESIZE_COMMIT: {
                        builder2.setTrigger(LayoutEditorRenderResult.Trigger.EDIT);
                        break;
                    }
                    case REQUEST_RENDER: {
                        builder2.setTrigger(LayoutEditorRenderResult.Trigger.USER);
                        break;
                    }
                    case BUILD: {
                        builder2.setTrigger(LayoutEditorRenderResult.Trigger.BUILD);
                        break;
                    }
                }
            }
            builder2.setComponentCount((int)result.getRootViews().stream().flatMap(s -> Stream.concat(s.getChildren().stream(), Stream.of(s))).count());
            RenderErrorModel errorModel = RenderErrorModelFactory.createErrorModel(result, null);
            builder2.setTotalIssueCount(errorModel.getSize());
            if (errorModel.getSize() > 0) {
                int errorCount = 0;
                int fidelityWarningCount = 0;
                for (RenderErrorModel.Issue issue : errorModel.getIssues()) {
                    if (HighlightSeverity.ERROR.equals((Object)issue.getSeverity())) {
                        ++errorCount;
                        continue;
                    }
                    if (!issue.getSummary().startsWith("Layout fid")) continue;
                    ++fidelityWarningCount;
                }
                builder2.setErrorCount(errorCount).setFidelityWarningCount(fidelityWarningCount);
            }
            event.setRenderResult(builder2.build());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageTracker";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/analytics/NlUsageTrackerManager";
                break;
            }
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventType";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/analytics/NlUsageTrackerManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceInner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "logStudioEvent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "logAction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "logRenderResult";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$logRenderResult$3";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$logStudioEvent$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

