/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertiesGrouper;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlPropertiesSorter;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.ViewAllPropertiesAction;
import com.android.tools.idea.uibuilder.property.editors.NlPropertyEditors;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.tools.idea.uibuilder.property.ptable.PTable;
import com.android.tools.idea.uibuilder.property.ptable.PTableGroupItem;
import com.android.tools.idea.uibuilder.property.ptable.PTableItem;
import com.android.tools.idea.uibuilder.property.ptable.PTableModel;
import com.android.util.PropertiesMap;
import com.google.common.collect.Table;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.RowFilter;
import javax.swing.event.HyperlinkEvent;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPropertiesPanel
extends JPanel
implements ViewAllPropertiesAction.Model,
DataProvider,
DeleteProvider,
CutProvider,
CopyProvider,
PasteProvider {
    private static final String CARD_ADVANCED = "table";
    private static final String CARD_DEFAULT = "default";
    private static final int VERTICAL_SCROLLING_UNIT_INCREMENT = 50;
    private static final int VERTICAL_SCROLLING_BLOCK_INCREMENT = 25;
    private final TableRowSorter<PTableModel> myRowSorter;
    private final MyFilter myFilter;
    private final PTable myTable;
    private final JPanel myTablePanel;
    private final PTableModel myModel;
    private final InspectorPanel myInspectorPanel;
    private final MyFocusTraversalPolicy myFocusTraversalPolicy;
    private final JPanel myCardPanel;
    private List<NlComponent> myComponents;
    private List<NlPropertyItem> myProperties;
    private boolean myAllPropertiesPanelVisible;

    public NlPropertiesPanel(@NotNull NlPropertiesManager propertiesManager, @NotNull Disposable parentDisposable) {
        if (propertiesManager == null) {
            NlPropertiesPanel.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            NlPropertiesPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.myRowSorter = new TableRowSorter();
        this.myFilter = new MyFilter();
        this.myModel = new PTableModel();
        this.myTable = new PTable(this.myModel);
        this.myTable.setEditorProvider(NlPropertyEditors.getInstance(propertiesManager.getProject()));
        this.myTable.getEmptyText().setText("No selected component");
        JComponent fewerPropertiesLink = this.createViewAllPropertiesLinkPanel(false);
        fewerPropertiesLink.setBorder(BorderFactory.createEmptyBorder(8, 4, 2, 0));
        this.myTablePanel = new JPanel(new BorderLayout());
        this.myTablePanel.setVisible(false);
        this.myTablePanel.setBackground(this.myTable.getBackground());
        this.myTablePanel.add((Component)((Object)this.myTable), "North");
        this.myTablePanel.add((Component)fewerPropertiesLink, "South");
        this.myInspectorPanel = new InspectorPanel(propertiesManager, parentDisposable, this.createViewAllPropertiesLinkPanel(true));
        this.myCardPanel = new JPanel((LayoutManager)new JBCardLayout());
        this.add((Component)this.myCardPanel, "Center");
        this.myCardPanel.add(CARD_DEFAULT, ScrollPaneFactory.createScrollPane((Component)this.myInspectorPanel, (int)20, (int)31));
        JScrollPane tableScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTablePanel);
        tableScrollPane.getVerticalScrollBar().setUnitIncrement(50);
        tableScrollPane.getVerticalScrollBar().setBlockIncrement(25);
        tableScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.myFocusTraversalPolicy = new MyFocusTraversalPolicy();
        this.myCardPanel.add(CARD_ADVANCED, tableScrollPane);
        this.myCardPanel.setFocusCycleRoot(true);
        this.myCardPanel.setFocusTraversalPolicy(this.myFocusTraversalPolicy);
        this.myComponents = Collections.emptyList();
        this.myProperties = Collections.emptyList();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this::scrollIntoView);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this::scrollIntoView);
    }

    public void setFilter(@NotNull String filter) {
        if (filter == null) {
            NlPropertiesPanel.$$$reportNull$$$0(2);
        }
        int selectedRow = this.myTable.getSelectedRow();
        PTableItem selectedItem = this.myTable.getSelectedItem();
        if (filter.isEmpty()) {
            this.myTable.setRowSorter(null);
        } else {
            this.myFilter.setPattern(filter);
            this.myRowSorter.setModel(this.myModel);
            this.myRowSorter.setRowFilter(this.myFilter);
            this.myRowSorter.setSortKeys(null);
            this.myTable.setRowSorter(this.myRowSorter);
        }
        this.myTable.restoreSelection(selectedRow, selectedItem);
        this.myInspectorPanel.setFilter(filter);
    }

    public void activatePropertySheet() {
        this.setAllPropertiesPanelVisible(true);
    }

    public void activateInspector() {
        this.setAllPropertiesPanelVisible(false);
    }

    public void setItems(@NotNull List<NlComponent> components, @NotNull Table<String, String, NlPropertyItem> properties, @NotNull NlPropertiesManager propertiesManager) {
        List<PTableItem> groupedProperties;
        if (components == null) {
            NlPropertiesPanel.$$$reportNull$$$0(3);
        }
        if (properties == null) {
            NlPropertiesPanel.$$$reportNull$$$0(4);
        }
        if (propertiesManager == null) {
            NlPropertiesPanel.$$$reportNull$$$0(5);
        }
        this.myComponents = components;
        this.myProperties = NlPropertiesPanel.extractPropertiesForTable(properties);
        if (components.isEmpty()) {
            groupedProperties = Collections.emptyList();
        } else {
            List<NlPropertyItem> sortedProperties = new NlPropertiesSorter().sort(this.myProperties, components);
            groupedProperties = new NlPropertiesGrouper().group(sortedProperties, components);
        }
        if (this.myTable.isEditing()) {
            this.myTable.removeEditor();
        }
        int selectedRow = this.myTable.getSelectedRow();
        PTableItem selectedItem = this.myTable.getSelectedItem();
        this.myModel.setItems(groupedProperties);
        if (this.myTable.getRowCount() > 0) {
            this.myTable.restoreSelection(selectedRow, selectedItem);
        }
        this.updateDefaultProperties(propertiesManager);
        this.myInspectorPanel.setComponent(components, properties, propertiesManager);
        this.myTablePanel.setVisible(!groupedProperties.isEmpty());
    }

    @NotNull
    private static List<NlPropertyItem> extractPropertiesForTable(@NotNull Table<String, String, NlPropertyItem> properties) {
        if (properties == null) {
            NlPropertiesPanel.$$$reportNull$$$0(6);
        }
        Map androidProperties = properties.row((Object)"http://schemas.android.com/apk/res/android");
        Map autoProperties = properties.row((Object)"http://schemas.android.com/apk/res-auto");
        Map designProperties = properties.row((Object)"http://schemas.android.com/tools");
        Map bareProperties = properties.row((Object)"");
        ArrayList<NlPropertyItem> result = new ArrayList<NlPropertyItem>(properties.size());
        result.addAll(autoProperties.values());
        for (Map.Entry entry : androidProperties.entrySet()) {
            if (autoProperties.containsKey(entry.getKey())) continue;
            result.add((NlPropertyItem)entry.getValue());
        }
        result.addAll(designProperties.values());
        result.addAll(bareProperties.values());
        ArrayList<NlPropertyItem> arrayList = result;
        if (arrayList == null) {
            NlPropertiesPanel.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public void modelRendered(@NotNull NlPropertiesManager propertiesManager) {
        if (propertiesManager == null) {
            NlPropertiesPanel.$$$reportNull$$$0(8);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (propertiesManager == null) {
                NlPropertiesPanel.$$$reportNull$$$0(27);
            }
            this.updateDefaultProperties(propertiesManager);
            this.myInspectorPanel.refresh();
        });
    }

    private void updateDefaultProperties(@NotNull NlPropertiesManager propertiesManager) {
        if (propertiesManager == null) {
            NlPropertiesPanel.$$$reportNull$$$0(9);
        }
        if (this.myComponents.isEmpty() || this.myProperties.isEmpty()) {
            return;
        }
        PropertiesMap defaultValues = propertiesManager.getDefaultProperties(this.myComponents);
        if (defaultValues.isEmpty()) {
            return;
        }
        for (NlPropertyItem property : this.myProperties) {
            property.setDefaultValue(NlPropertiesPanel.getDefaultProperty(defaultValues, property));
        }
    }

    @Nullable
    private static PropertiesMap.Property getDefaultProperty(@NotNull PropertiesMap defaultValues, @NotNull NlProperty property) {
        if (defaultValues == null) {
            NlPropertiesPanel.$$$reportNull$$$0(10);
        }
        if (property == null) {
            NlPropertiesPanel.$$$reportNull$$$0(11);
        }
        if ("http://schemas.android.com/apk/res/android".equals(property.getNamespace())) {
            PropertiesMap.Property defaultValue = (PropertiesMap.Property)defaultValues.get((Object)("android:" + property.getName()));
            if (defaultValue != null) {
                return defaultValue;
            }
            return (PropertiesMap.Property)defaultValues.get((Object)("@android:" + property.getName()));
        }
        return (PropertiesMap.Property)defaultValues.get((Object)property.getName());
    }

    @NotNull
    private JComponent createViewAllPropertiesLinkPanel(boolean viewAllProperties) {
        HyperlinkLabel textLink = new HyperlinkLabel();
        textLink.setHyperlinkText(viewAllProperties ? "View all properties" : "View fewer properties");
        textLink.addHyperlinkListener(event -> this.setAllPropertiesPanelVisible(event, viewAllProperties));
        HyperlinkLabel iconLink = new HyperlinkLabel();
        iconLink.setIcon(AndroidIcons.NeleIcons.ToggleProperties);
        iconLink.setFocusable(false);
        iconLink.setUseIconAsLink(true);
        iconLink.addHyperlinkListener(event -> this.setAllPropertiesPanelVisible(event, viewAllProperties));
        JPanel linkPanel = new JPanel(new FlowLayout(0, 0, 0));
        linkPanel.setOpaque(false);
        linkPanel.add((Component)textLink);
        linkPanel.add((Component)iconLink);
        JPanel jPanel = linkPanel;
        if (jPanel == null) {
            NlPropertiesPanel.$$$reportNull$$$0(12);
        }
        return jPanel;
    }

    private void setAllPropertiesPanelVisible(@NotNull HyperlinkEvent event, boolean viewAllProperties) {
        if (event == null) {
            NlPropertiesPanel.$$$reportNull$$$0(13);
        }
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setAllPropertiesPanelVisible(viewAllProperties);
        }
    }

    @Override
    public boolean isAllPropertiesPanelVisible() {
        return this.myAllPropertiesPanelVisible;
    }

    @Override
    public void setAllPropertiesPanelVisible(boolean viewAllProperties) {
        this.myAllPropertiesPanelVisible = viewAllProperties;
        JBCardLayout cardLayout = (JBCardLayout)this.myCardPanel.getLayout();
        String name = viewAllProperties ? CARD_ADVANCED : CARD_DEFAULT;
        Object next = viewAllProperties ? this.myTable : this.myInspectorPanel;
        cardLayout.swipe((Container)this.myCardPanel, name, JBCardLayout.SwipeDirection.AUTO, ((Component)next)::requestFocus);
    }

    public boolean activatePreferredEditor(@NotNull String propertyName, boolean afterload) {
        if (propertyName == null) {
            NlPropertiesPanel.$$$reportNull$$$0(14);
        }
        if (this.isAllPropertiesPanelVisible()) {
            this.setAllPropertiesPanelVisible(false);
        }
        return this.myInspectorPanel.activatePreferredEditor(propertyName, afterload);
    }

    private void scrollIntoView(@NotNull PropertyChangeEvent event) {
        Component newFocusedComponent;
        if (event == null) {
            NlPropertiesPanel.$$$reportNull$$$0(15);
        }
        if (event.getNewValue() instanceof Component && "focusOwner".equals(event.getPropertyName()) && this.isAncestorOf(newFocusedComponent = (Component)event.getNewValue()) && newFocusedComponent.getParent() instanceof JComponent && this.myFocusTraversalPolicy.isLastFocusRecipient(newFocusedComponent)) {
            JComponent parent1 = (JComponent)newFocusedComponent.getParent();
            Rectangle bounds = newFocusedComponent.getBounds();
            if (newFocusedComponent == this.myTable) {
                bounds = this.myTable.getCellRect(this.myTable.getSelectedRow(), 1, true);
                bounds.x = 0;
            }
            parent1.scrollRectToVisible(bounds);
        }
    }

    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(16);
        }
        return false;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(17);
        }
        return false;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(18);
        }
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(19);
        }
        return false;
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(20);
        }
        return false;
    }

    public void performCut(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(21);
        }
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(22);
        }
        return false;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(23);
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(24);
        }
        return false;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(25);
        }
        return false;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlPropertiesPanel.$$$reportNull$$$0(26);
        }
    }

    public PTable getTable() {
        return this.myTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/NlPropertiesPanel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValues";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/NlPropertiesPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPropertiesForTable";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewAllPropertiesLinkPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setItems";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractPropertiesForTable";
                break;
            }
            case 7: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "modelRendered";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateDefaultProperties";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultProperty";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setAllPropertiesPanelVisible";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "activatePreferredEditor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "scrollIntoView";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isCutEnabled";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isCutVisible";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "performCut";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isPastePossible";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isPasteEnabled";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "performPaste";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$modelRendered$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private Component myLastFocusRecipient;

        private MyFocusTraversalPolicy() {
        }

        private boolean isLastFocusRecipient(@NotNull Component component) {
            if (component == null) {
                MyFocusTraversalPolicy.$$$reportNull$$$0(0);
            }
            boolean isLastRecipient = component == this.myLastFocusRecipient;
            this.myLastFocusRecipient = null;
            return isLastRecipient;
        }

        @Override
        protected boolean accept(@NotNull Component component) {
            if (component == null) {
                MyFocusTraversalPolicy.$$$reportNull$$$0(1);
            }
            if (!super.accept(component)) {
                return false;
            }
            this.myLastFocusRecipient = component;
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "component";
            objectArray2[1] = "com/android/tools/idea/uibuilder/property/NlPropertiesPanel$MyFocusTraversalPolicy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isLastFocusRecipient";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class MyFilter
    extends RowFilter<PTableModel, Integer> {
        private final SpeedSearchComparator myComparator = new SpeedSearchComparator(false);
        private String myPattern;

        MyFilter() {
        }

        void setPattern(@NotNull String pattern) {
            if (pattern == null) {
                MyFilter.$$$reportNull$$$0(0);
            }
            this.myPattern = pattern;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends PTableModel, ? extends Integer> entry) {
            PTableItem item = (PTableItem)entry.getValue(0);
            if (this.isMatch(item.getName())) {
                return true;
            }
            if (item.getParent() != null && this.isMatch(item.getParent().getName())) {
                return true;
            }
            if (!(item instanceof PTableGroupItem)) {
                return false;
            }
            PTableGroupItem group = (PTableGroupItem)item;
            for (PTableItem child : group.getChildren()) {
                if (!this.isMatch(child.getName())) continue;
                return true;
            }
            return false;
        }

        private boolean isMatch(@NotNull String text) {
            if (text == null) {
                MyFilter.$$$reportNull$$$0(1);
            }
            return this.myComparator.matchingFragments(this.myPattern, text) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/property/NlPropertiesPanel$MyFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setPattern";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMatch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

