/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlDesignProperties;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.NlInspectorProviders;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectorPanel
extends JPanel
implements KeyEventDispatcher {
    private static final int HORIZONTAL_SPACING = 6;
    private final JComponent myAllPropertiesLink;
    private final NlInspectorProviders myProviders;
    private final NlDesignProperties myDesignProperties;
    private final Font myBoldLabelFont;
    private final JPanel myInspector;
    private final SpeedSearchComparator myComparator;
    private final Map<Component, ExpandableGroup> mySource2GroupMap;
    private final Map<JLabel, ExpandableGroup> myLabel2GroupMap;
    private final Multimap<JLabel, Component> myLabel2ComponentMap;
    private final JLabel myDefaultLabel;
    private List<InspectorComponent> myInspectors;
    private ExpandableGroup myGroup;
    private GridConstraints myConstraints;
    private int myRow;
    private boolean myActivateEditorAfterLoad;
    private String myPropertyNameForActivation;
    private String myFilter;

    public InspectorPanel(@NotNull NlPropertiesManager propertiesManager, @NotNull Disposable parentDisposable, @NotNull JComponent allPropertiesLink) {
        if (propertiesManager == null) {
            InspectorPanel.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            InspectorPanel.$$$reportNull$$$0(1);
        }
        if (allPropertiesLink == null) {
            InspectorPanel.$$$reportNull$$$0(2);
        }
        super(new BorderLayout());
        this.myBoldLabelFont = UIUtil.getLabelFont().deriveFont(1);
        this.mySource2GroupMap = new IdentityHashMap<Component, ExpandableGroup>(4);
        this.myLabel2GroupMap = new IdentityHashMap<JLabel, ExpandableGroup>(4);
        this.myLabel2ComponentMap = HashMultimap.create();
        this.myDefaultLabel = new JLabel();
        this.myInspectors = Collections.emptyList();
        this.myConstraints = new GridConstraints();
        this.myAllPropertiesLink = allPropertiesLink;
        this.myAllPropertiesLink.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 0));
        this.myProviders = new NlInspectorProviders(propertiesManager, parentDisposable);
        this.myDesignProperties = new NlDesignProperties();
        this.myInspector = new GridInspectorPanel();
        this.myInspector.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        this.myComparator = new SpeedSearchComparator(false);
        this.myFilter = "";
        this.add((Component)this.myInspector, "Center");
    }

    @Override
    public void requestFocus() {
        List<NlComponentEditor> editors;
        if (!this.myInspectors.isEmpty() && !(editors = this.myInspectors.get(0).getEditors()).isEmpty()) {
            editors.get(0).requestFocus();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        Component source;
        ExpandableGroup group;
        if (event.getKeyCode() == 9 && event.getModifiers() == 0 && event.getID() == 401 && event.getSource() instanceof Component && (group = this.mySource2GroupMap.get(source = (Component)event.getSource())) != null && !group.isExpanded()) {
            group.setExpanded(true, true);
            ApplicationManager.getApplication().invokeLater(source::transferFocus);
            return true;
        }
        return false;
    }

    public void setFilter(@NotNull String filter) {
        if (filter == null) {
            InspectorPanel.$$$reportNull$$$0(3);
        }
        this.myFilter = filter;
        ApplicationManager.getApplication().invokeLater(this::updateAfterFilterChange);
    }

    private void updateAfterFilterChange() {
        if (this.myFilter.isEmpty()) {
            this.restoreGroups();
        } else {
            this.applyFilter();
        }
        this.myInspector.invalidate();
        this.myInspector.repaint();
    }

    private void applyFilter() {
        for (JLabel label : this.myLabel2ComponentMap.keySet()) {
            boolean display = this.isMatch(label);
            label.setVisible(display);
            this.myLabel2ComponentMap.get((Object)label).forEach(component -> component.setVisible(display));
            ExpandableGroup group = this.myLabel2GroupMap.get(label);
            if (group == null) continue;
            label.setIcon(null);
        }
    }

    private void restoreGroups() {
        HashSet<Component> toShow = new HashSet<Component>(Arrays.asList(this.myInspector.getComponents()));
        for (ExpandableGroup group : this.myLabel2GroupMap.values()) {
            toShow.removeAll(group.myComponents);
            group.setExpanded(group.isExpanded(), false);
        }
        toShow.forEach(component -> component.setVisible(true));
    }

    private boolean isMatch(@NotNull JLabel label) {
        if (label == null) {
            InspectorPanel.$$$reportNull$$$0(4);
        }
        if (this.myFilter.isEmpty()) {
            return true;
        }
        if (StringUtil.isEmpty((String)label.getText()) || label.getFont() == this.myBoldLabelFont) {
            return false;
        }
        return this.myComparator.matchingFragments(this.myFilter, label.getText()) != null;
    }

    private static GridLayoutManager createLayoutManager(int rows, int columns) {
        JBInsets margin = new JBInsets(0, 0, 0, 0);
        return new GridLayoutManager(rows, columns, (Insets)margin, 0, 0);
    }

    public void setComponent(@NotNull List<NlComponent> components, @NotNull Table<String, String, ? extends NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            InspectorPanel.$$$reportNull$$$0(5);
        }
        if (properties == null) {
            InspectorPanel.$$$reportNull$$$0(6);
        }
        if (propertiesManager == null) {
            InspectorPanel.$$$reportNull$$$0(7);
        }
        this.myInspector.setLayout(null);
        this.myInspector.removeAll();
        this.mySource2GroupMap.clear();
        this.myLabel2GroupMap.clear();
        this.myLabel2ComponentMap.clear();
        this.myRow = 0;
        if (!components.isEmpty()) {
            HashMap propertiesByName = Maps.newHashMapWithExpectedSize((int)properties.size());
            for (NlProperty property : properties.row((Object)"http://schemas.android.com/apk/res/android").values()) {
                propertiesByName.put(property.getName(), property);
            }
            for (NlProperty property : properties.row((Object)"http://schemas.android.com/apk/res-auto").values()) {
                propertiesByName.put(property.getName(), property);
            }
            for (NlProperty property : properties.row((Object)"").values()) {
                propertiesByName.put(property.getName(), property);
            }
            for (NlProperty property : this.myDesignProperties.getKnownProperties(components)) {
                propertiesByName.putIfAbsent(property.getName(), property);
            }
            this.myInspectors = this.myProviders.createInspectorComponents(components, propertiesByName, propertiesManager);
            int rows = 0;
            for (InspectorComponent inspector : this.myInspectors) {
                rows += inspector.getMaxNumberOfRows();
            }
            rows += this.myInspectors.size();
            this.myInspector.setLayout((LayoutManager)InspectorPanel.createLayoutManager(rows += 2, 2));
            for (InspectorComponent inspector : this.myInspectors) {
                this.addSeparator();
                inspector.attachToInspector(this);
            }
            this.endGroup();
            this.addSeparator();
            this.myInspector.add((Component)new Spacer(), new GridConstraints(this.myRow++, 0, 1, 2, 0, 1, 2, 6, null, null, null, 0, false));
            this.addLineComponent(this.myAllPropertiesLink, this.myRow++);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            this.updateAfterFilterChange();
            if (this.myActivateEditorAfterLoad) {
                this.activatePreferredEditor(this.myPropertyNameForActivation);
            }
        });
    }

    public void refresh() {
        ApplicationManager.getApplication().invokeLater(() -> this.myInspectors.forEach(InspectorComponent::refresh));
    }

    public boolean activatePreferredEditor(@NotNull String propertyName, boolean activateAfterLoading) {
        if (propertyName == null) {
            InspectorPanel.$$$reportNull$$$0(8);
        }
        if (activateAfterLoading) {
            this.myActivateEditorAfterLoad = true;
            this.myPropertyNameForActivation = propertyName;
        } else {
            this.activatePreferredEditor(propertyName);
        }
        return true;
    }

    private void activatePreferredEditor(@NotNull String propertyName) {
        if (propertyName == null) {
            InspectorPanel.$$$reportNull$$$0(9);
        }
        this.myActivateEditorAfterLoad = false;
        this.myPropertyNameForActivation = null;
        boolean designPropertyRequired = propertyName.startsWith("tools:");
        propertyName = StringUtil.trimStart((String)propertyName, (String)"tools:");
        for (InspectorComponent component : this.myInspectors) {
            for (NlComponentEditor editor : component.getEditors()) {
                NlProperty property = editor.getProperty();
                if (property == null || !propertyName.equals(property.getName()) || designPropertyRequired && !"http://schemas.android.com/tools".equals(property.getNamespace())) continue;
                editor.requestFocus();
                return;
            }
        }
    }

    public JLabel addTitle(@NotNull String title) {
        if (title == null) {
            InspectorPanel.$$$reportNull$$$0(10);
        }
        JLabel label = InspectorPanel.createLabel(title, null, null);
        label.setFont(this.myBoldLabelFont);
        this.addLineComponent(label, this.myRow++);
        this.myLabel2ComponentMap.put((Object)this.myDefaultLabel, (Object)label);
        return label;
    }

    public void addSeparator() {
        this.endGroup();
        if (this.myRow > 0) {
            JSeparator component = new JSeparator();
            this.addLineComponent(component, this.myRow++);
            this.myLabel2ComponentMap.put((Object)this.myDefaultLabel, (Object)component);
        }
    }

    public JLabel addExpandableComponent(@NotNull String labelText, @Nullable String tooltip, @NotNull Component component, @NotNull Component keySource) {
        if (labelText == null) {
            InspectorPanel.$$$reportNull$$$0(11);
        }
        if (component == null) {
            InspectorPanel.$$$reportNull$$$0(12);
        }
        if (keySource == null) {
            InspectorPanel.$$$reportNull$$$0(13);
        }
        JLabel label = InspectorPanel.createLabel(labelText, tooltip, component);
        this.addLabelComponent(label, this.myRow);
        this.addValueComponent(component, this.myRow++);
        this.startGroup(label, keySource);
        this.myLabel2GroupMap.put(label, this.myGroup);
        this.myLabel2ComponentMap.put((Object)label, (Object)component);
        return label;
    }

    public JLabel addComponent(@NotNull String labelText, @Nullable String tooltip, @NotNull Component component) {
        if (labelText == null) {
            InspectorPanel.$$$reportNull$$$0(14);
        }
        if (component == null) {
            InspectorPanel.$$$reportNull$$$0(15);
        }
        JLabel label = InspectorPanel.createLabel(labelText, tooltip, component);
        this.addLabelComponent(label, this.myRow);
        this.addValueComponent(component, this.myRow++);
        this.myLabel2ComponentMap.put((Object)label, (Object)component);
        return label;
    }

    public void addPanel(@NotNull JComponent panel) {
        if (panel == null) {
            InspectorPanel.$$$reportNull$$$0(16);
        }
        this.addLineComponent(panel, this.myRow++);
        this.myLabel2ComponentMap.put((Object)this.myDefaultLabel, (Object)panel);
    }

    private static JLabel createLabel(@NotNull String labelText, @Nullable String tooltip, @Nullable Component component) {
        if (labelText == null) {
            InspectorPanel.$$$reportNull$$$0(17);
        }
        JBLabel label = new JBLabel(labelText);
        label.setLabelFor(component);
        label.setToolTipText(tooltip);
        return label;
    }

    private void addLineComponent(@NotNull Component component, int row) {
        if (component == null) {
            InspectorPanel.$$$reportNull$$$0(18);
        }
        this.addComponent(component, row, 0, 2, 8, 1);
    }

    private void addLabelComponent(@NotNull Component component, int row) {
        if (component == null) {
            InspectorPanel.$$$reportNull$$$0(19);
        }
        this.addComponent(component, row, 0, 1, 8, 1);
    }

    private void addValueComponent(@NotNull Component component, int row) {
        if (component == null) {
            InspectorPanel.$$$reportNull$$$0(20);
        }
        this.addComponent(component, row, 1, 1, 4, 1);
    }

    private void addComponent(@NotNull Component component, int row, int column, int columnSpan, int anchor, int fill) {
        if (component == null) {
            InspectorPanel.$$$reportNull$$$0(21);
        }
        this.addToGridPanel(this.myInspector, component, row, column, columnSpan, anchor, fill);
        if (this.myGroup != null) {
            this.myGroup.addComponent(component);
        }
    }

    private void addToGridPanel(@NotNull JPanel panel, @NotNull Component component, int row, int column, int columnSpan, int anchor, int fill) {
        if (panel == null) {
            InspectorPanel.$$$reportNull$$$0(22);
        }
        if (component == null) {
            InspectorPanel.$$$reportNull$$$0(23);
        }
        this.myConstraints.setRow(row);
        this.myConstraints.setColumn(column);
        this.myConstraints.setColSpan(columnSpan);
        this.myConstraints.setAnchor(anchor);
        this.myConstraints.setFill(fill);
        panel.add(component, this.myConstraints);
    }

    private void startGroup(@NotNull JLabel label, @NotNull Component keySource) {
        if (label == null) {
            InspectorPanel.$$$reportNull$$$0(24);
        }
        if (keySource == null) {
            InspectorPanel.$$$reportNull$$$0(25);
        }
        assert (this.myGroup == null);
        this.myGroup = new ExpandableGroup(label);
        this.mySource2GroupMap.put(keySource, this.myGroup);
    }

    private void endGroup() {
        this.myGroup = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allPropertiesLink";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelText";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 13: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keySource";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/property/inspector/InspectorPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isMatch";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setComponent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "activatePreferredEditor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addTitle";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "addExpandableComponent";
                break;
            }
            case 14: 
            case 15: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "addComponent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "addPanel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "createLabel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "addLineComponent";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "addLabelComponent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "addValueComponent";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "addToGridPanel";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "startGroup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GridInspectorPanel
    extends JPanel {
        private int myWidth;

        private GridInspectorPanel() {
        }

        @Override
        public void setLayout(LayoutManager layoutManager) {
            this.myWidth = -1;
            super.setLayout(layoutManager);
        }

        @Override
        public void doLayout() {
            this.updateGridConstraints();
            super.doLayout();
        }

        private void updateGridConstraints() {
            LayoutManager layoutManager = this.getLayout();
            if (layoutManager instanceof GridLayoutManager) {
                GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
                if (this.getWidth() != this.myWidth) {
                    this.myWidth = this.getWidth();
                    for (Component component : this.getComponents()) {
                        GridConstraints constraints = gridLayoutManager.getConstraintsForComponent(component);
                        if (constraints == null) continue;
                        this.updateMinimumSize(constraints);
                    }
                }
            }
        }

        private void updateMinimumSize(@NotNull GridConstraints constraints) {
            if (constraints == null) {
                GridInspectorPanel.$$$reportNull$$$0(0);
            }
            if (constraints.getColSpan() == 1) {
                if (constraints.getColumn() == 0) {
                    constraints.myMinimumSize.setSize((double)(this.myWidth - 12) * 0.4, -1.0);
                } else if (constraints.getColumn() == 1) {
                    constraints.myMinimumSize.setSize((double)(this.myWidth - 12) * 0.6, -1.0);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraints", "com/android/tools/idea/uibuilder/property/inspector/InspectorPanel$GridInspectorPanel", "updateMinimumSize"));
        }
    }

    private static class ExpandableGroup {
        private static final String KEY_PREFIX = "inspector.open.";
        private static final Icon EXPANDED_ICON = (Icon)UIManager.get("Tree.expandedIcon");
        private static final Icon COLLAPSED_ICON = (Icon)UIManager.get("Tree.collapsedIcon");
        private final JLabel myLabel;
        private final List<Component> myComponents;
        private boolean myExpanded;

        public ExpandableGroup(final @NotNull JLabel label) {
            if (label == null) {
                ExpandableGroup.$$$reportNull$$$0(0);
            }
            this.myLabel = label;
            this.myComponents = new ArrayList<Component>(4);
            this.myExpanded = PropertiesComponent.getInstance().getBoolean(KEY_PREFIX + label.getText());
            label.setIcon(this.myExpanded ? EXPANDED_ICON : COLLAPSED_ICON);
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (label.getIcon() != null) {
                        this.setExpanded(!this.isExpanded(), true);
                    }
                }
            });
        }

        public void addComponent(@NotNull Component component) {
            if (component == null) {
                ExpandableGroup.$$$reportNull$$$0(1);
            }
            this.myComponents.add(component);
            component.setVisible(this.myExpanded);
        }

        public boolean isExpanded() {
            return this.myExpanded;
        }

        public void setExpanded(boolean expanded, boolean updateProperties) {
            this.myExpanded = expanded;
            this.myLabel.setIcon(expanded ? EXPANDED_ICON : COLLAPSED_ICON);
            this.myComponents.forEach(component -> component.setVisible(expanded));
            if (updateProperties) {
                PropertiesComponent.getInstance().setValue(KEY_PREFIX + this.myLabel.getText(), expanded);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/property/inspector/InspectorPanel$ExpandableGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addComponent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

