/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.SelectionListener;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.ScenePicker;
import com.android.tools.idea.uibuilder.scene.TemporarySceneComponent;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.target.ActionTarget;
import com.android.tools.idea.uibuilder.scene.target.AnchorTarget;
import com.android.tools.idea.uibuilder.scene.target.DragDndTarget;
import com.android.tools.idea.uibuilder.scene.target.DragTarget;
import com.android.tools.idea.uibuilder.scene.target.GuidelineCycleTarget;
import com.android.tools.idea.uibuilder.scene.target.GuidelineTarget;
import com.android.tools.idea.uibuilder.scene.target.LassoTarget;
import com.android.tools.idea.uibuilder.scene.target.ResizeTarget;
import com.android.tools.idea.uibuilder.scene.target.Target;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Scene
implements ModelListener,
SelectionListener {
    private final ScreenView myScreenView;
    private static final boolean DEBUG = false;
    private NlModel myModel;
    private boolean isManualDpiFactor;
    private float myDpiFactor;
    private HashMap<NlComponent, SceneComponent> mySceneComponents;
    private SceneComponent myRoot;
    private boolean myAnimate;
    public static final int NO_LAYOUT = 0;
    public static final int IMMEDIATE_LAYOUT = 1;
    public static final int ANIMATED_LAYOUT = 2;
    private boolean myNeedsDisplayListRebuilt;
    private Target myOverTarget;
    private SceneComponent myCurrentComponent;
    private SceneComponent myDnDComponent;
    private int mNeedsLayout;
    private int myLastMouseX;
    private int myLastMouseY;
    private boolean myDidPreviousRepaint;
    private HitListener myHoverListener;
    private HitListener myHitListener;
    private Target myHitTarget;
    private int myMouseCursor;
    private SceneComponent myHitComponent;
    ArrayList<SceneComponent> myNewSelectedComponents;
    private boolean myIsControlDown;
    private boolean myIsShiftDown;
    private boolean myIsAltDown;
    private boolean myShowAllConstraints;
    private FilterType myFilterTarget;

    public static Scene createScene(@NotNull NlModel model, @NotNull ScreenView screenView) {
        if (model == null) {
            Scene.$$$reportNull$$$0(0);
        }
        if (screenView == null) {
            Scene.$$$reportNull$$$0(1);
        }
        Scene scene = new Scene(screenView, model.getConfiguration().getDensity().getDpiValue());
        scene.add(model);
        return scene;
    }

    private Scene(@NotNull ScreenView screenView, float dpiFactor) {
        if (screenView == null) {
            Scene.$$$reportNull$$$0(2);
        }
        this.mySceneComponents = new HashMap();
        this.myAnimate = true;
        this.myNeedsDisplayListRebuilt = true;
        this.mNeedsLayout = 0;
        this.myDidPreviousRepaint = true;
        this.myHoverListener = new HitListener();
        this.myHitListener = new HitListener();
        this.myHitTarget = null;
        this.myNewSelectedComponents = new ArrayList();
        this.myShowAllConstraints = false;
        this.myFilterTarget = FilterType.NONE;
        this.myScreenView = screenView;
        this.myScreenView.getSelectionModel().addListener(this);
        this.myDpiFactor = dpiFactor / 160.0f;
    }

    public int pxToDp(int px) {
        return (int)(0.5f + (float)px / this.myDpiFactor);
    }

    public int dpToPx(int dp) {
        return (int)(0.5f + (float)dp * this.myDpiFactor);
    }

    void setDpiFactorOverride(float dpiFactor) {
        this.isManualDpiFactor = true;
        this.myDpiFactor = dpiFactor;
    }

    public boolean getAnimate() {
        return this.myAnimate;
    }

    public void setAnimate(boolean animate) {
        this.myAnimate = animate;
    }

    @Nullable
    public SceneComponent getSceneComponent(@Nullable NlComponent component) {
        if (component == null) {
            return null;
        }
        return this.mySceneComponents.get(component);
    }

    @Nullable
    public SceneComponent getSceneComponent(@NotNull String componentId) {
        if (componentId == null) {
            Scene.$$$reportNull$$$0(3);
        }
        if (this.myRoot == null) {
            return null;
        }
        return this.myRoot.getSceneComponent(componentId);
    }

    public List<NlComponent> getSelection() {
        return this.myModel.getSelectionModel().getSelection();
    }

    @Nullable
    public SceneComponent getRoot() {
        return this.myRoot;
    }

    public int getMouseCursor() {
        return this.myMouseCursor;
    }

    public void setDnDComponent(NlComponent component) {
        SceneComponent existingComponent = this.getSceneComponent(component);
        if (component == null || existingComponent != this.myDnDComponent) {
            if (this.myDnDComponent != null) {
                if (this.myDnDComponent instanceof TemporarySceneComponent) {
                    this.myDnDComponent.removeFromParent();
                } else {
                    int pos = this.myDnDComponent.findTarget(DragDndTarget.class);
                    if (pos != -1) {
                        this.myDnDComponent.removeTarget(pos);
                    }
                }
            }
            this.myDnDComponent = null;
        }
        if (component != null) {
            if (existingComponent == null) {
                this.myDnDComponent = new TemporarySceneComponent(this, component);
                if (this.myRoot != null) {
                    this.myRoot.addChild(this.myDnDComponent);
                }
            } else {
                this.myDnDComponent = existingComponent;
                this.myDnDComponent.addTarget(new DragDndTarget());
            }
        }
    }

    public boolean isAutoconnectOn() {
        return PropertiesComponent.getInstance().getBoolean("ConstraintLayoutPreferenceAutoConnect", false);
    }

    public boolean isShowAllConstraints() {
        return this.myShowAllConstraints || PropertiesComponent.getInstance().getBoolean("ConstraintLayoutPreferenceShowAllConstraints");
    }

    public void setShowAllConstraints(boolean showAllConstraints) {
        this.myShowAllConstraints = showAllConstraints;
    }

    public void updateModifiers(int modifiers) {
        this.myIsControlDown = (modifiers & 0x80) != 0 || (modifiers & 2) != 0;
        this.myIsShiftDown = (modifiers & 0x40) != 0 || (modifiers & 1) != 0;
        this.myIsAltDown = (modifiers & 0x200) != 0 || (modifiers & 8) != 0;
    }

    public boolean isControlDown() {
        return this.myIsControlDown;
    }

    public boolean isShiftDown() {
        return this.myIsShiftDown;
    }

    public boolean isAltDown() {
        return this.myIsAltDown;
    }

    public void clearAttributes() {
        if (this.myRoot != null) {
            this.myRoot.clearAttributes();
        }
        this.select(Collections.emptyList());
    }

    public void add(@NotNull NlModel model) {
        if (model == null) {
            Scene.$$$reportNull$$$0(4);
        }
        ConfigurationListener listener = flags -> {
            float newDpiFactor;
            if (model == null) {
                Scene.$$$reportNull$$$0(25);
            }
            if ((flags & 2) != 0 && !this.isManualDpiFactor && this.myDpiFactor != (newDpiFactor = (float)model.getConfiguration().getDensity().getDpiValue() / 160.0f)) {
                this.updateFrom(model);
            }
            return true;
        };
        model.getConfiguration().addListener(listener);
        Disposer.register((Disposable)model, () -> {
            if (model == null) {
                Scene.$$$reportNull$$$0(24);
            }
            model.getConfiguration().removeListener(listener);
        });
        List<NlComponent> components = model.getComponents();
        if (components.size() != 0) {
            NlComponent rootComponent = components.get(0).getRoot();
            this.myAnimate = false;
            this.myRoot = this.updateFromComponent(rootComponent);
            this.myAnimate = true;
            this.addTargets(this.myRoot);
        }
        model.addListener(this);
        this.myModel = model;
        if (this.myScreenView != null) {
            this.selectionChanged(this.myScreenView.getSelectionModel(), this.myScreenView.getSelectionModel().getSelection());
        }
    }

    public void addComponent(@NotNull SceneComponent component) {
        if (component == null) {
            Scene.$$$reportNull$$$0(5);
        }
        this.mySceneComponents.put(component.getNlComponent(), component);
    }

    public void updateFrom(@NotNull NlModel model) {
        List<NlComponent> components;
        if (model == null) {
            Scene.$$$reportNull$$$0(6);
        }
        if ((components = model.getComponents()).size() == 0) {
            this.mySceneComponents.clear();
            this.myRoot = null;
            return;
        }
        for (SceneComponent component : this.mySceneComponents.values()) {
            component.used = false;
        }
        if (!this.isManualDpiFactor) {
            this.myDpiFactor = (float)model.getConfiguration().getDensity().getDpiValue() / 160.0f;
        }
        NlComponent rootComponent = components.get(0).getRoot();
        this.myRoot = this.updateFromComponent(rootComponent);
        Iterator<SceneComponent> it = this.mySceneComponents.values().iterator();
        while (it.hasNext()) {
            SceneComponent component = it.next();
            if (component.used) continue;
            component.removeFromParent();
            it.remove();
        }
        if (this.myRoot != null && this.myScreenView != null && this.myScreenView.getSelectionModel().isEmpty()) {
            this.addTargets(this.myRoot);
        }
        if (this.myScreenView != null) {
            this.selectionChanged(this.myScreenView.getSelectionModel().getSelection(), false);
        }
    }

    private SceneComponent updateFromComponent(@NotNull NlComponent component) {
        SceneComponent sceneComponent;
        if (component == null) {
            Scene.$$$reportNull$$$0(7);
        }
        if ((sceneComponent = this.mySceneComponents.get(component)) != null) {
            sceneComponent.used = true;
            sceneComponent.updateFrom(component);
            this.myNeedsDisplayListRebuilt = true;
        } else {
            sceneComponent = new SceneComponent(this, component);
        }
        int numChildren = component.getChildCount();
        for (int i = 0; i < numChildren; ++i) {
            SceneComponent child = this.updateFromComponent(component.getChild(i));
            if (child.getParent() == sceneComponent) continue;
            sceneComponent.addChild(child);
        }
        return sceneComponent;
    }

    void addTargets(@NotNull SceneComponent component) {
        SceneComponent parent;
        ViewHandler handler;
        if (component == null) {
            Scene.$$$reportNull$$$0(8);
        }
        if ((handler = (component = (parent = component.getParent()) != null ? parent : this.myRoot).getNlComponent().getViewHandler()) instanceof ViewGroupHandler) {
            ViewGroupHandler viewGroupHandler = (ViewGroupHandler)handler;
            if (component.getViewGroupHandler() != viewGroupHandler) {
                component.setViewGroupHandler(viewGroupHandler, true);
            }
            int childCount = component.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                SceneComponent child = component.getChild(i);
                if (child.getViewGroupHandler() == viewGroupHandler) continue;
                child.setViewGroupHandler(viewGroupHandler, false);
            }
        }
        this.needsRebuildList();
    }

    void clearChildTargets(SceneComponent component) {
        int count = component.getChildCount();
        component.setViewGroupHandler(null, false);
        for (int i = 0; i < count; ++i) {
            SceneComponent child = component.getChild(i);
            child.setViewGroupHandler(null, false);
            this.clearChildTargets(child);
        }
    }

    @Override
    public void selectionChanged(@NotNull SelectionModel model, @NotNull List<NlComponent> selection) {
        if (model == null) {
            Scene.$$$reportNull$$$0(9);
        }
        if (selection == null) {
            Scene.$$$reportNull$$$0(10);
        }
        this.selectionChanged(selection, true);
    }

    public void selectionChanged(@NotNull List<NlComponent> selection, boolean updateTargets) {
        if (selection == null) {
            Scene.$$$reportNull$$$0(11);
        }
        if (this.myRoot != null) {
            if (updateTargets) {
                this.clearChildTargets(this.myRoot);
            }
            this.myRoot.markSelection(selection);
            if (!selection.isEmpty()) {
                NlComponent primary = selection.get(0);
                SceneComponent component = this.getSceneComponent(primary);
                if (component != null) {
                    this.addTargets(component);
                } else {
                    this.addTargets(this.myRoot);
                }
            } else {
                this.addTargets(this.myRoot);
            }
        }
    }

    @Override
    public void modelChanged(@NotNull NlModel model) {
        if (model == null) {
            Scene.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (model == null) {
                Scene.$$$reportNull$$$0(23);
            }
            this.updateFrom(model);
        });
    }

    @Override
    public void modelRendered(@NotNull NlModel model) {
        if (model == null) {
            Scene.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (model == null) {
                Scene.$$$reportNull$$$0(22);
            }
            this.updateFrom(model);
        });
    }

    @Override
    public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
        if (model == null) {
            Scene.$$$reportNull$$$0(14);
        }
        boolean previous = this.myAnimate;
        this.myAnimate = animate;
        this.updateFrom(model);
        this.myAnimate = previous;
    }

    /*
     * WARNING - void declaration
     */
    public boolean buildDisplayList(@NotNull DisplayList displayList, long time, ScreenView screenView) {
        void screenView2;
        if (displayList == null) {
            Scene.$$$reportNull$$$0(15);
        }
        return this.buildDisplayList(displayList, time, SceneContext.get((ScreenView)screenView2));
    }

    public boolean buildDisplayList(@NotNull DisplayList displayList, long time) {
        if (displayList == null) {
            Scene.$$$reportNull$$$0(16);
        }
        return this.buildDisplayList(displayList, time, SceneContext.get());
    }

    public void repaint() {
        this.myScreenView.getSurface().repaint();
    }

    /*
     * WARNING - void declaration
     */
    public boolean buildDisplayList(@NotNull DisplayList displayList, long time, SceneContext sceneContext) {
        if (displayList == null) {
            Scene.$$$reportNull$$$0(17);
        }
        boolean needsRepaint = false;
        if (this.myRoot != null) {
            void sceneContext2;
            needsRepaint = this.myRoot.layout((SceneContext)sceneContext2, time);
            if (sceneContext2 != null) {
                this.myRoot.buildDisplayList(time, displayList, (SceneContext)sceneContext2);
            }
        }
        if (this.myDidPreviousRepaint) {
            this.myDidPreviousRepaint = needsRepaint;
            needsRepaint = true;
        }
        return needsRepaint;
    }

    public void select(List<SceneComponent> components) {
        if (this.myScreenView != null) {
            ArrayList<NlComponent> nlComponents = new ArrayList<NlComponent>();
            if (this.myIsShiftDown) {
                List<NlComponent> selection = this.myScreenView.getSelectionModel().getSelection();
                nlComponents.addAll(selection);
            }
            int count = components.size();
            for (int i = 0; i < count; ++i) {
                NlComponent component = components.get(i).getNlComponent();
                if (this.myIsShiftDown && nlComponents.contains(component)) {
                    nlComponents.remove(component);
                    continue;
                }
                nlComponents.add(component);
            }
            this.myScreenView.getSelectionModel().setSelection(nlComponents);
        }
    }

    public boolean allowsTarget(Target target) {
        SceneComponent component = target.getComponent();
        if (component.isSelected()) {
            boolean hasBaselineConnection;
            boolean bl = hasBaselineConnection = component.getNlComponent().getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
            if (target instanceof AnchorTarget) {
                AnchorTarget anchor = (AnchorTarget)target;
                if (anchor.getType() == AnchorTarget.Type.BASELINE) {
                    return component.canShowBaseline() || hasBaselineConnection;
                }
                return !hasBaselineConnection && !component.canShowBaseline() || hasBaselineConnection && anchor.isHorizontalAnchor();
            }
            if (component.canShowBaseline()) {
                return target instanceof ActionTarget || target instanceof DragTarget || target instanceof ResizeTarget;
            }
            return !component.isDragging();
        }
        if (target instanceof AnchorTarget) {
            AnchorTarget anchor = (AnchorTarget)target;
            if (this.myFilterTarget == FilterType.BASELINE_ANCHOR) {
                return anchor.getType() == AnchorTarget.Type.BASELINE;
            }
            if (this.myFilterTarget == FilterType.VERTICAL_ANCHOR && anchor.isVerticalAnchor()) {
                return true;
            }
            if (this.myFilterTarget == FilterType.HORIZONTAL_ANCHOR && anchor.isHorizontalAnchor()) {
                return true;
            }
            if (this.myFilterTarget == FilterType.ANCHOR) {
                return true;
            }
        }
        if (this.myFilterTarget == FilterType.RESIZE && target instanceof ResizeTarget) {
            return true;
        }
        if (target instanceof DragTarget) {
            return true;
        }
        if (target instanceof LassoTarget) {
            return true;
        }
        if (target instanceof GuidelineCycleTarget) {
            return true;
        }
        if (target instanceof ActionTarget) {
            return false;
        }
        return this.myFilterTarget == FilterType.ALL;
    }

    public void mouseHover(@NotNull SceneContext transform, int x, int y) {
        SceneComponent closestComponent;
        Target closestTarget;
        if (transform == null) {
            Scene.$$$reportNull$$$0(18);
        }
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        this.myMouseCursor = 0;
        if (this.myRoot != null) {
            this.myHoverListener.find(transform, this.myRoot, x, y);
        }
        if (this.myOverTarget != (closestTarget = this.myHoverListener.getClosestTarget())) {
            if (this.myOverTarget != null) {
                this.myOverTarget.setOver(false);
                this.myOverTarget = null;
                this.needsRebuildList();
            }
            if (closestTarget != null) {
                closestTarget.setOver(true);
                this.myOverTarget = closestTarget;
                this.needsRebuildList();
            }
        }
        if (this.myCurrentComponent != (closestComponent = this.myHoverListener.getClosestComponent())) {
            if (this.myCurrentComponent != null) {
                this.myCurrentComponent.setDrawState(SceneComponent.DrawState.NORMAL);
                this.myCurrentComponent = null;
            }
            if (closestComponent != null) {
                closestComponent.setDrawState(SceneComponent.DrawState.HOVER);
                this.myCurrentComponent = closestComponent;
            }
        }
        if (this.myOverTarget != null) {
            this.myMouseCursor = this.myOverTarget.getMouseCursor();
        }
    }

    private void delegateMouseDownToSelection(int x, int y, SceneComponent currentComponent) {
        List<NlComponent> selection = this.getSelection();
        if (selection.size() > 1) {
            int count = selection.size();
            for (int i = 0; i < count; ++i) {
                SceneComponent c;
                NlComponent nlComponent = selection.get(i);
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null || c == currentComponent) continue;
                ArrayList<Target> targets = c.getTargets();
                int numTargets = targets.size();
                for (int j = 0; j < numTargets; ++j) {
                    Target target = targets.get(j);
                    if (!(target instanceof DragTarget)) continue;
                    DragTarget dragTarget = (DragTarget)target;
                    dragTarget.mouseDown(x, y);
                }
            }
        }
    }

    private void delegateMouseDragToSelection(int x, int y, @Nullable Target closestTarget, SceneComponent currentComponent) {
        List<NlComponent> selection = this.getSelection();
        if (selection.size() > 1) {
            int count = selection.size();
            for (int i = 0; i < count; ++i) {
                SceneComponent c;
                NlComponent nlComponent = selection.get(i);
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null || c == currentComponent) continue;
                ArrayList<Target> targets = c.getTargets();
                int numTargets = targets.size();
                for (int j = 0; j < numTargets; ++j) {
                    Target target = targets.get(j);
                    if (!(target instanceof DragTarget)) continue;
                    DragTarget dragTarget = (DragTarget)target;
                    dragTarget.mouseDrag(x, y, closestTarget);
                }
            }
        }
    }

    private void delegateMouseReleaseToSelection(int x, int y, @Nullable Target closestTarget, SceneComponent currentComponent) {
        List<NlComponent> selection = this.getSelection();
        if (selection.size() > 1) {
            int count = selection.size();
            for (int i = 0; i < count; ++i) {
                SceneComponent c;
                NlComponent nlComponent = selection.get(i);
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null) continue;
                ArrayList<Target> targets = c.getTargets();
                int numTargets = targets.size();
                for (int j = 0; j < numTargets; ++j) {
                    Target target = targets.get(j);
                    if (!(target instanceof DragTarget)) continue;
                    DragTarget dragTarget = (DragTarget)target;
                    dragTarget.mouseRelease(x, y, closestTarget);
                }
            }
        }
    }

    public void mouseDown(@NotNull SceneContext transform, int x, int y) {
        if (transform == null) {
            Scene.$$$reportNull$$$0(19);
        }
        this.mNeedsLayout = 0;
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        this.myFilterTarget = FilterType.NONE;
        if (this.myRoot == null) {
            return;
        }
        this.myHitListener.find(transform, this.myRoot, x, y);
        this.myHitTarget = null;
        this.myHitTarget = this.myHitListener.getClosestTarget();
        this.myHitComponent = this.myHitListener.getClosestComponent();
        if (this.myHitTarget != null) {
            if (this.myHitTarget instanceof AnchorTarget) {
                AnchorTarget anchor = (AnchorTarget)this.myHitTarget;
                this.myFilterTarget = anchor.isHorizontalAnchor() ? FilterType.HORIZONTAL_ANCHOR : FilterType.VERTICAL_ANCHOR;
                if (anchor.getType() == AnchorTarget.Type.BASELINE) {
                    this.myFilterTarget = FilterType.BASELINE_ANCHOR;
                }
            }
            this.myHitTarget.mouseDown(x, y);
            if (this.myHitTarget instanceof DragTarget) {
                this.delegateMouseDownToSelection(x, y, this.myHitTarget.getComponent());
            }
        }
    }

    public void mouseDrag(@NotNull SceneContext transform, int x, int y) {
        if (transform == null) {
            Scene.$$$reportNull$$$0(20);
        }
        if (this.myLastMouseX == x && this.myLastMouseY == y) {
            return;
        }
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        if (this.myHitTarget != null) {
            this.myHitListener.find(transform, this.myRoot, x, y);
            this.myHitTarget.mouseDrag(x, y, this.myHitListener.getClosestTarget());
            this.myHitTarget.getComponent().setDragging(true);
            if (this.myHitTarget instanceof DragTarget) {
                this.delegateMouseDragToSelection(x, y, this.myHitListener.getClosestTarget(), this.myHitTarget.getComponent());
            }
        }
        this.mouseHover(transform, x, y);
        this.checkRequestLayoutStatus();
    }

    void checkRequestLayoutStatus() {
        if (this.mNeedsLayout != 0) {
            this.myModel.requestLayout(this.mNeedsLayout == 2);
        }
    }

    public void mouseRelease(@NotNull SceneContext transform, int x, int y) {
        DragTarget dragTarget;
        if (transform == null) {
            Scene.$$$reportNull$$$0(21);
        }
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        if (this.myHitTarget != null) {
            this.myHitTarget.getComponent().setDragging(false);
            this.myHitListener.find(transform, this.myRoot, x, y);
            this.myHitTarget.mouseRelease(x, y, this.myHitListener.getFilteredTarget(this.myHitTarget));
            if (this.myHitTarget instanceof DragTarget) {
                this.delegateMouseReleaseToSelection(x, y, this.myHitListener.getClosestTarget(), this.myHitTarget.getComponent());
            }
        }
        this.myFilterTarget = FilterType.NONE;
        this.myNewSelectedComponents.clear();
        if (this.myHitComponent != null && this.myHitListener.getClosestComponent() == this.myHitComponent) {
            this.myNewSelectedComponents.add(this.myHitComponent);
        }
        if (this.myHitTarget instanceof ActionTarget || this.myHitTarget instanceof GuidelineTarget) {
            this.myNewSelectedComponents.clear();
            this.myNewSelectedComponents.add(this.myHitTarget.getComponent());
        }
        if (this.myHitTarget instanceof DragTarget && (dragTarget = (DragTarget)this.myHitTarget).hasChangedComponent()) {
            this.myNewSelectedComponents.clear();
            this.myNewSelectedComponents.add(dragTarget.getComponent());
        }
        if (this.myHitTarget instanceof LassoTarget) {
            LassoTarget lassoTarget = (LassoTarget)this.myHitTarget;
            lassoTarget.fillSelectedComponents(this.myNewSelectedComponents);
        }
        boolean canChangeSelection = true;
        if (this.myHitTarget != null) {
            canChangeSelection = this.myHitTarget.canChangeSelection();
        }
        if (canChangeSelection && !this.sameSelection()) {
            this.select(this.myNewSelectedComponents);
        }
        this.checkRequestLayoutStatus();
    }

    private boolean sameSelection() {
        List<NlComponent> currentSelection = this.myScreenView.getSelectionModel().getSelection();
        if (this.myNewSelectedComponents.size() == currentSelection.size()) {
            int count = currentSelection.size();
            for (int i = 0; i < count; ++i) {
                NlComponent component = currentSelection.get(i);
                SceneComponent sceneComponent = this.getSceneComponent(component);
                if (this.myNewSelectedComponents.contains(sceneComponent)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void needsLayout(int type) {
        if (this.mNeedsLayout < type) {
            this.mNeedsLayout = type;
        }
    }

    public boolean getNeedsDisplayListRebuilt() {
        return this.myNeedsDisplayListRebuilt;
    }

    public void clearNeedsRebuildList() {
        this.myNeedsDisplayListRebuilt = false;
    }

    public void needsRebuildList() {
        this.myNeedsDisplayListRebuilt = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentId";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayList";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/scene/Scene";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createScene";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSceneComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFrom";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFromComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addTargets";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "selectionChanged";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "modelChanged";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "modelRendered";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "modelChangedOnLayout";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "buildDisplayList";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseHover";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseDown";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseDrag";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseRelease";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$modelRendered$3";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$modelChanged$2";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$add$1";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$add$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    class HitListener
    implements ScenePicker.HitElementListener {
        private ScenePicker myPicker = new ScenePicker();
        double myClosestComponentDistance = Double.MAX_VALUE;
        double myClosestTargetDistance = Double.MAX_VALUE;
        ArrayList<SceneComponent> myHitComponents = new ArrayList();
        ArrayList<Target> myHitTargets = new ArrayList();

        public HitListener() {
            this.myPicker.setSelectListener(this);
        }

        public void find(@NotNull SceneContext transform, @NotNull SceneComponent root, int x, int y) {
            if (transform == null) {
                HitListener.$$$reportNull$$$0(0);
            }
            if (root == null) {
                HitListener.$$$reportNull$$$0(1);
            }
            this.myHitComponents.clear();
            this.myHitTargets.clear();
            this.myClosestComponentDistance = Double.MAX_VALUE;
            this.myClosestTargetDistance = Double.MAX_VALUE;
            this.myPicker.reset();
            root.addHit(transform, this.myPicker);
            this.myPicker.find(transform.getSwingX(x), transform.getSwingY(y));
        }

        @Override
        public void over(Object over, double dist) {
            if (over instanceof Target) {
                Target target = (Target)over;
                if (dist < this.myClosestTargetDistance) {
                    this.myHitTargets.clear();
                    this.myHitTargets.add(target);
                    this.myClosestTargetDistance = dist;
                } else if (dist == this.myClosestTargetDistance) {
                    this.myHitTargets.add(target);
                }
            } else if (over instanceof SceneComponent) {
                SceneComponent component = (SceneComponent)over;
                if (dist < this.myClosestComponentDistance) {
                    this.myHitComponents.clear();
                    this.myHitComponents.add(component);
                    this.myClosestComponentDistance = dist;
                } else if (dist == this.myClosestComponentDistance) {
                    this.myHitComponents.add(component);
                }
            }
        }

        public Target getClosestTarget() {
            int count = this.myHitTargets.size();
            if (count == 0) {
                return null;
            }
            if (count == 1) {
                return this.myHitTargets.get(0);
            }
            List<NlComponent> selection = Scene.this.myScreenView.getSelectionModel().getSelection();
            if (selection.isEmpty()) {
                Target candidate = this.myHitTargets.get(count - 1);
                for (int i = count - 2; i >= 0; --i) {
                    Target target = this.myHitTargets.get(i);
                    if (target.getPreferenceLevel() <= candidate.getPreferenceLevel()) continue;
                    candidate = target;
                }
                return candidate;
            }
            Target candidate = this.myHitTargets.get(count - 1);
            boolean inSelection = selection.contains(candidate.getComponent().getNlComponent());
            for (int i = count - 2; i >= 0; --i) {
                Target target = this.myHitTargets.get(i);
                if (!selection.contains(target.getComponent().getNlComponent()) || inSelection && target.getPreferenceLevel() <= candidate.getPreferenceLevel()) continue;
                candidate = target;
                inSelection = true;
            }
            return candidate;
        }

        public Target getFilteredTarget(Target filteredTarget) {
            int count = this.myHitTargets.size();
            Target hit = null;
            boolean found = false;
            for (int i = 0; i < count; ++i) {
                Target target = this.myHitTargets.get(i);
                if (target == filteredTarget) {
                    found = true;
                    continue;
                }
                if (!filteredTarget.getClass().isAssignableFrom(target.getClass())) continue;
                hit = target;
            }
            if (hit == null && found) {
                hit = filteredTarget;
            }
            return hit;
        }

        public SceneComponent getClosestComponent() {
            SceneComponent target;
            int i;
            int count = this.myHitComponents.size();
            if (count == 0) {
                return null;
            }
            if (count == 1) {
                return this.myHitComponents.get(0);
            }
            List<NlComponent> selection = Scene.this.myScreenView.getSelectionModel().getSelection();
            if (selection.isEmpty()) {
                return this.myHitComponents.get(count - 1);
            }
            SceneComponent candidate = this.myHitComponents.get(count - 1);
            boolean inSelection = selection.contains(candidate.getNlComponent());
            if (inSelection) {
                return candidate;
            }
            for (i = count - 2; i >= 0; --i) {
                target = this.myHitComponents.get(i);
                if (!selection.contains(target.getNlComponent())) continue;
                candidate = target;
                break;
            }
            for (i = count - 1; i >= 0; --i) {
                target = this.myHitComponents.get(i);
                if (!target.hasAncestor(candidate)) continue;
                candidate = target;
                break;
            }
            return candidate;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "transform";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/uibuilder/scene/Scene$HitListener";
            objectArray[2] = "find";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum FilterType {
        ALL,
        ANCHOR,
        VERTICAL_ANCHOR,
        HORIZONTAL_ANCHOR,
        BASELINE_ANCHOR,
        NONE,
        RESIZE;

    }
}

