/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.uibuilder.api.ScrollHandler;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.surface.Interaction;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import org.jetbrains.annotations.Nullable;

public class ScrollInteraction
extends Interaction {
    private static final int MAX_SCROLL_MULTIPLIER = 5;
    private final ScrollHandler myHandler;
    private int myScrolledAmount;
    private short myLastScrollSign;
    private int myScrollMultiplier = 1;
    private ScreenView myScreenView;

    private ScrollInteraction(ScreenView screenView, ScrollHandler scrollHandler) {
        this.myScreenView = screenView;
        this.myHandler = scrollHandler;
    }

    @Nullable
    public static ScrollInteraction createScrollInteraction(ScreenView screenView, NlComponent component) {
        ScrollHandler scrollHandler = null;
        ViewEditorImpl editor = new ViewEditorImpl(screenView);
        for (NlComponent currentComponent = component; currentComponent != null; currentComponent = currentComponent.getParent()) {
            ViewGroupHandler viewGroupHandler = currentComponent.getViewGroupHandler();
            ScrollHandler scrollHandler2 = scrollHandler = viewGroupHandler != null ? viewGroupHandler.createScrollHandler(editor, currentComponent) : null;
            if (scrollHandler != null) break;
        }
        if (scrollHandler == null) {
            return null;
        }
        return new ScrollInteraction(screenView, scrollHandler);
    }

    @Override
    public void scroll(int x, int y, int scrollAmount) {
        short currentScrollSign = (short)(scrollAmount < 0 ? -1 : 0);
        if (this.myLastScrollSign != currentScrollSign) {
            this.myScrollMultiplier = 1;
            this.myLastScrollSign = currentScrollSign;
        } else if (this.myScrollMultiplier < 5) {
            ++this.myScrollMultiplier;
        }
        int newScrolledAmount = this.myScrolledAmount + scrollAmount * this.myScrollMultiplier;
        int scrolled = this.myHandler.update(newScrolledAmount);
        if (scrolled != 0) {
            this.myScrolledAmount += scrollAmount;
            this.myScreenView.getModel().requestRender();
        }
    }

    @Override
    public void end(int x, int y, int modifiers, boolean canceled) {
        if (canceled) {
            this.myHandler.update(0);
            this.myScreenView.getModel().requestRender();
            return;
        }
        this.myScrollMultiplier = 1;
        this.myHandler.commit(this.myScrolledAmount);
        this.myScrolledAmount = 0;
    }
}

