/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.WelcomeUIUtils;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;

public final class DownloadOperation
extends InstallOperation<File, File> {
    @NotNull
    private final String myUrl;

    public DownloadOperation(@NotNull InstallContext context, @NotNull String url, double progressShare) {
        if (context == null) {
            DownloadOperation.$$$reportNull$$$0(0);
        }
        if (url == null) {
            DownloadOperation.$$$reportNull$$$0(1);
        }
        super(context, progressShare);
        this.myUrl = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void download(@NotNull String url, @NotNull File destination, @NotNull ProgressIndicator indicator) throws IOException {
        if (url == null) {
            DownloadOperation.$$$reportNull$$$0(2);
        }
        if (destination == null) {
            DownloadOperation.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            DownloadOperation.$$$reportNull$$$0(4);
        }
        indicator.setText(String.format("Downloading %s", destination.getName()));
        HttpURLConnection connection = HttpConfigurable.getInstance().openHttpConnection(url);
        int contentLength = connection.getContentLength();
        if (contentLength <= 0) {
            indicator.setIndeterminate(true);
        }
        InputStream readStream = null;
        OutputStream stream = null;
        try {
            readStream = connection.getInputStream();
            stream = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] buffer = new byte[0x200000];
            int totalRead = 0;
            long startTime = System.currentTimeMillis();
            int read = readStream.read(buffer);
            while (read > 0) {
                stream.write(buffer, 0, read);
                long duration = System.currentTimeMillis() - startTime;
                long downloadRate = duration == 0L ? 0L : (long)(totalRead += read) / duration;
                String message = String.format("Downloading %1$s (%2$s/s)", destination.getName(), WelcomeUIUtils.getSizeLabel(downloadRate * 1000L));
                indicator.setText(message);
                if (contentLength > 0) {
                    indicator.setFraction((double)totalRead / (double)contentLength);
                }
                indicator.checkCanceled();
                read = readStream.read(buffer);
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (readStream != null) {
                readStream.close();
            }
        }
    }

    @NotNull
    private static String getFileName(@NotNull String urlString) {
        block5: {
            String string;
            if (urlString == null) {
                DownloadOperation.$$$reportNull$$$0(5);
            }
            try {
                if (!URLUtil.containsScheme((String)urlString)) break block5;
                URL url = new URL(urlString);
                string = PathUtil.getFileName((String)url.getPath());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (string == null) {
                DownloadOperation.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = PathUtil.getFileName((String)urlString);
        if (string == null) {
            DownloadOperation.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    protected File perform(@NotNull ProgressIndicator indicator, @NotNull File arg) throws WizardException, InstallationCancelledException {
        File file;
        if (indicator == null) {
            DownloadOperation.$$$reportNull$$$0(8);
        }
        if (arg == null) {
            DownloadOperation.$$$reportNull$$$0(9);
        }
        File file2 = new File(this.myContext.getTempDirectory(), DownloadOperation.getFileName(this.myUrl));
        this.myContext.print(String.format("Downloading %1$s from %2$s\n", file2.getName(), this.myUrl), ConsoleViewContentType.SYSTEM_OUTPUT);
        indicator.start();
        try {
            while (!this.attemptDownload(file2, indicator)) {
            }
            file = file2;
        }
        catch (ProcessCanceledException e) {
            throw new InstallationCancelledException();
        }
        if (file == null) {
            DownloadOperation.$$$reportNull$$$0(10);
        }
        return file;
    }

    private boolean attemptDownload(File file, ProgressIndicator indicator) throws WizardException {
        try {
            DownloadOperation.download(this.myUrl, file, indicator);
            return true;
        }
        catch (UnknownHostException e) {
            this.prompt(String.format("Unknown host: %s", e.getMessage()), e);
        }
        catch (IOException e) {
            String details = StringUtil.isEmpty((String)e.getMessage()) ? "Unable to download Android Studio components." : e.getMessage();
            this.prompt(details, e);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            String details = StringUtil.isEmpty((String)e.getMessage()) ? "Unable to download Android Studio components." : e.getMessage();
            this.prompt(details, e);
        }
        return false;
    }

    private void prompt(String details, Exception e) throws WizardException {
        this.promptToRetry(details + "\n\nPlease check your Internet connection and retry.", details, e);
    }

    @Override
    public void cleanup(@NotNull File result) {
        if (result == null) {
            DownloadOperation.$$$reportNull$$$0(11);
        }
        if (result.isFile() && FileUtil.isAncestor((File)result, (File)this.myContext.getTempDirectory(), (boolean)false)) {
            FileUtil.delete((File)result);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlString";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/welcome/install/DownloadOperation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/welcome/install/DownloadOperation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

