/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template;

import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.StringEvaluator;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.ui.ApiComboBoxItem;
import com.android.tools.idea.wizard.dynamic.AndroidStudioWizardStep;
import com.android.tools.idea.wizard.template.TemplateWizardState;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Deprecated
public abstract class TemplateWizardStep
extends ModuleWizardStep
implements ActionListener,
FocusListener,
DocumentListener,
ChangeListener,
AndroidStudioWizardStep {
    protected static final String LAST_USED_CLASS_PREFIX_KEY = "LAST_USED_CLASS_PREFIX";
    protected final TemplateWizardState myTemplateState;
    protected final BiMap<String, JComponent> myParamFields;
    protected final Map<String, JLabel> myParamFieldLabels;
    protected final Map<JRadioButton, Pair<String, Object>> myRadioButtonValues;
    protected final Map<Parameter, ApiComboBoxItem> myComboBoxValues;
    protected final Project myProject;
    protected final Module myModule;
    private final Icon mySidePanelIcon;
    protected boolean myIgnoreUpdates;
    protected boolean myFirstUpdate;
    protected boolean myIsValid;
    protected boolean myVisible;
    protected final UpdateListener myUpdateListener;
    private final StringEvaluator myStringEvaluator;
    protected Queue<String> myIdsWithNewValues;
    public static final UpdateListener NONE = new UpdateListener(){

        @Override
        public void update() {
        }
    };

    public TemplateWizardStep(@NotNull TemplateWizardState state, @Nullable Project project, @Nullable Module module, @Nullable Icon sidePanelIcon, @Nullable UpdateListener updateListener) {
        if (state == null) {
            TemplateWizardStep.$$$reportNull$$$0(0);
        }
        this.myParamFields = HashBiMap.create();
        this.myParamFieldLabels = Maps.newHashMap();
        this.myRadioButtonValues = Maps.newHashMap();
        this.myComboBoxValues = Maps.newHashMap();
        this.myIgnoreUpdates = false;
        this.myFirstUpdate = true;
        this.myIsValid = true;
        this.myVisible = true;
        this.myStringEvaluator = new StringEvaluator();
        this.myIdsWithNewValues = new ConcurrentLinkedQueue<String>();
        this.myTemplateState = state;
        this.myProject = project;
        this.myModule = module;
        this.mySidePanelIcon = sidePanelIcon;
        this.myUpdateListener = updateListener;
    }

    public void _init() {
        super._init();
        this.update();
    }

    @NotNull
    protected abstract JLabel getDescription();

    protected void setDescriptionHtml(@Nullable String s) {
        JLabel label;
        if (s == null) {
            s = "";
        }
        if (!s.startsWith("<html>")) {
            s = "<html>" + s + "</html>";
            s = s.replaceAll("\n", "<br>");
        }
        if ((label = this.getDescription()) != null) {
            label.setText(s);
            this.growLabelIfNecessary(label);
        }
    }

    @NotNull
    protected abstract JLabel getError();

    public void setErrorHtml(@Nullable String s) {
        JLabel label;
        if (s == null) {
            s = "";
        }
        if (!s.startsWith("<html>")) {
            s = "<html><font color='#" + ColorUtil.toHex((Color)JBColor.RED) + "'>" + XmlUtils.toXmlTextValue((String)s) + "</font></html>";
            s = s.replaceAll("\n", "<br>");
        }
        if ((label = this.getError()) != null) {
            label.setText(s);
            this.growLabelIfNecessary(label);
        }
    }

    protected void growLabelIfNecessary(JLabel label) {
        Dimension newSize = label.getMinimumSize();
        label.setPreferredSize(null);
        label.validate();
        Dimension pd = label.getPreferredSize();
        int currentWidth = label.getSize().width;
        int preferredHeight = 0;
        if (currentWidth != 0 && pd.width != 0 && pd.height != 0) {
            preferredHeight = pd.height * (int)((float)pd.width / (float)currentWidth);
            if (currentWidth % pd.width != 0) {
                preferredHeight += pd.height;
            }
        }
        newSize.height = Math.max(newSize.height, preferredHeight);
        label.setMinimumSize(newSize);
        label.setPreferredSize(newSize);
        if (this.getComponent() != null) {
            this.getComponent().revalidate();
        }
    }

    @Nullable
    protected String getHelpText(@NotNull String param) {
        if (param == null) {
            TemplateWizardStep.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Override
    public boolean isValid() {
        return this.myIsValid;
    }

    public void setVisible(boolean visible) {
        this.myVisible = visible;
    }

    public boolean isStepVisible() {
        return this.myVisible;
    }

    public void updateParams() {
        if (!this.myVisible) {
            return;
        }
        Template.convertApisToInt(this.myTemplateState.getParameters());
        Component focusedComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        this.setDescriptionHtml("");
        this.setErrorHtml("");
        for (String string : this.myParamFields.keySet()) {
            Object newValue;
            if (this.myTemplateState.myHidden.contains(string)) continue;
            Parameter param = this.myTemplateState.hasTemplate() ? this.myTemplateState.getTemplateMetadata().getParameter(string) : null;
            Object oldValue = this.myTemplateState.get(string);
            JComponent component = (JComponent)this.myParamFields.get((Object)string);
            if (component == focusedComponent || component.isAncestorOf(focusedComponent)) {
                String help = param != null && param.help != null && param.help.length() > 0 ? param.help : this.getHelpText(string);
                this.setDescriptionHtml(help);
            }
            if ((newValue = this.getComponentValue(param, component)) == null || newValue.equals(oldValue)) continue;
            this.myTemplateState.put(string, newValue);
            if (oldValue != null) {
                this.myTemplateState.myModified.add(string);
            }
            if (this.myIdsWithNewValues.contains(string)) continue;
            this.myIdsWithNewValues.add(string);
        }
        for (Map.Entry entry : this.myRadioButtonValues.entrySet()) {
            if (!((JRadioButton)entry.getKey()).isSelected()) continue;
            Pair value = (Pair)entry.getValue();
            this.myTemplateState.put((String)value.getFirst(), value.getSecond());
        }
    }

    protected void deriveValues() {
        TemplateMetadata metadata = this.myTemplateState.getTemplateMetadata();
        if (metadata == null) {
            return;
        }
        for (String changedParamId : this.myIdsWithNewValues) {
            for (String paramName : this.myParamFields.keySet()) {
                String updated;
                Parameter param = this.myTemplateState.hasTemplate() ? metadata.getParameter(paramName) : null;
                if (param == null || (param.suggest == null || param.suggest.isEmpty()) && (param.visibility == null || param.visibility.isEmpty())) continue;
                if (param.visibility != null && param.visibility.contains(changedParamId)) {
                    this.updateVisibility(param);
                }
                if (this.myTemplateState.myHidden.contains(paramName) || param.suggest == null || !param.suggest.contains(changedParamId) || (updated = this.myStringEvaluator.evaluate(param.suggest, this.myTemplateState.getParameters())) == null || updated.equals(this.myTemplateState.get(param.id))) continue;
                this.myIdsWithNewValues.add(param.id);
                this.updateDerivedValue(param.id, (JTextField)this.myParamFields.get((Object)param.id), new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return updated;
                    }
                });
            }
        }
    }

    protected void updateVisibility(Parameter param) {
        if (param.visibility != null && !param.visibility.isEmpty()) {
            boolean visible = this.myStringEvaluator.evaluateBooleanExpression(param.visibility, this.myTemplateState.getParameters(), true);
            if (visible) {
                String updated;
                this.myTemplateState.myHidden.remove(param.id);
                if (param.suggest != null && (updated = this.myStringEvaluator.evaluate(param.suggest, this.myTemplateState.getParameters())) != null && !updated.equals(this.myTemplateState.get(param.id))) {
                    this.updateDerivedValue(param.id, (JTextField)this.myParamFields.get((Object)param.id), new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return updated;
                        }
                    });
                }
            } else {
                this.myTemplateState.myHidden.add(param.id);
            }
            ((JComponent)this.myParamFields.get((Object)param.id)).setVisible(visible);
            if (this.myParamFieldLabels.containsKey(param.id)) {
                this.myParamFieldLabels.get(param.id).setVisible(visible);
            }
        }
    }

    public boolean validate() {
        Template.convertApisToInt(this.myTemplateState.getParameters());
        if (!this.myVisible) {
            return true;
        }
        Integer minApi = (Integer)this.myTemplateState.get("minApiLevel");
        Integer buildApi = (Integer)this.myTemplateState.get("buildApi");
        for (String paramName : this.myParamFields.keySet()) {
            Parameter param;
            if (this.myTemplateState.myHidden.contains(paramName) || (param = this.myTemplateState.hasTemplate() ? this.myTemplateState.getTemplateMetadata().getParameter(paramName) : null) == null) continue;
            HashSet relatedValues = Sets.newHashSet();
            for (Parameter related : this.myTemplateState.getTemplateMetadata().getRelatedParams(param)) {
                relatedValues.add(this.myTemplateState.get(related.id));
            }
            String error = param.validate(this.myProject, this.myModule, this.myTemplateState.getSourceProvider(), (String)this.myTemplateState.get("packageName"), this.myTemplateState.get(paramName), relatedValues);
            if (error != null) {
                this.setErrorHtml(error);
                return false;
            }
            if (!this.myComboBoxValues.containsKey(param)) continue;
            ApiComboBoxItem selectedItem = this.myComboBoxValues.get(param);
            if (selectedItem == null) {
                return false;
            }
            if (minApi == null || buildApi == null) {
                return false;
            }
            String message = selectedItem.validate(minApi, buildApi);
            if (message == null) continue;
            this.setErrorHtml(message);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUiFromParameters() {
        if (this.myTemplateState.myTemplate == null) {
            return;
        }
        for (Parameter param : this.myTemplateState.myTemplate.getMetadata().getParameters()) {
            if (param.initial == null || this.myTemplateState.myModified.contains(param.id)) continue;
            this.myTemplateState.myParameters.remove(param.id);
        }
        this.myTemplateState.setParameterDefaults();
        Template.convertApisToInt(this.myTemplateState.getParameters());
        boolean oldIgnoreUpdates = this.myIgnoreUpdates;
        try {
            this.myIgnoreUpdates = true;
            block4: for (String paramName : this.myParamFields.keySet()) {
                if (this.myTemplateState.myHidden.contains(paramName)) continue;
                JComponent component = (JComponent)this.myParamFields.get((Object)paramName);
                Object value = this.myTemplateState.get(paramName);
                if (value == null) continue;
                if (component instanceof JCheckBox) {
                    ((JCheckBox)component).setSelected(Boolean.parseBoolean(value.toString()));
                    continue;
                }
                if (component instanceof JComboBox) {
                    for (int i = 0; i < ((JComboBox)component).getItemCount(); ++i) {
                        if (!((ApiComboBoxItem)((JComboBox)component).getItemAt(i)).getData().equals(value)) continue;
                        ((JComboBox)component).setSelectedIndex(i);
                        continue block4;
                    }
                    continue;
                }
                if (component instanceof JTextField) {
                    ((JTextField)component).setText(value.toString());
                    continue;
                }
                if (component instanceof TextFieldWithBrowseButton) {
                    ((TextFieldWithBrowseButton)component).setText(value.toString());
                    continue;
                }
                if (component instanceof JSlider) {
                    ((JSlider)component).setValue(Integer.parseInt(value.toString()));
                    continue;
                }
                if (component instanceof JSpinner) {
                    ((JSpinner)component).setValue(Integer.parseInt(value.toString()));
                    continue;
                }
                if (!(component instanceof ColorPanel)) continue;
                ((ColorPanel)component).setSelectedColor((Color)value);
            }
        }
        finally {
            this.myIgnoreUpdates = oldIgnoreUpdates;
        }
    }

    @Nullable
    protected Object getComponentValue(Parameter param, JComponent component) {
        Object newValue = null;
        if (component instanceof JCheckBox) {
            newValue = ((JCheckBox)component).isSelected();
        } else if (component instanceof JComboBox) {
            ApiComboBoxItem selectedItem = (ApiComboBoxItem)((JComboBox)component).getSelectedItem();
            this.myComboBoxValues.put(param, selectedItem);
            if (selectedItem != null) {
                newValue = selectedItem.getData();
            }
        } else if (component instanceof JTextField) {
            newValue = ((JTextField)component).getText();
        } else if (component instanceof TextFieldWithBrowseButton) {
            newValue = ((TextFieldWithBrowseButton)component).getText();
        } else if (component instanceof JSlider) {
            newValue = ((JSlider)component).getValue();
        } else if (component instanceof JSpinner) {
            newValue = ((JSpinner)component).getValue();
        } else if (component instanceof ColorPanel) {
            newValue = ((ColorPanel)component).getSelectedColor();
        }
        return newValue;
    }

    protected static void populateComboBox(@NotNull JComboBox comboBox, @NotNull Parameter parameter) {
        if (comboBox == null) {
            TemplateWizardStep.$$$reportNull$$$0(2);
        }
        if (parameter == null) {
            TemplateWizardStep.$$$reportNull$$$0(3);
        }
        List<Element> options = parameter.getOptions();
        assert (!options.isEmpty());
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            Element option = options.get(i);
            String optionId = option.getAttribute("id");
            assert (optionId != null && !optionId.isEmpty()) : "id";
            NodeList childNodes = option.getChildNodes();
            assert (childNodes.getLength() == 1 && childNodes.item(0).getNodeType() == 3);
            String optionLabel = childNodes.item(0).getNodeValue().trim();
            int minSdk = 1;
            try {
                minSdk = Integer.parseInt(option.getAttribute("minApi"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int minBuildApi = 1;
            try {
                minBuildApi = Integer.parseInt(option.getAttribute("minBuildApi"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            comboBox.addItem(new ApiComboBoxItem<String>(optionId, optionLabel, minSdk, minBuildApi));
            String isDefault = option.getAttribute("default");
            if (isDefault == null || isDefault.isEmpty() || !Boolean.valueOf(isDefault).booleanValue()) continue;
            comboBox.setSelectedIndex(comboBox.getItemCount() - 1);
        }
    }

    protected static <E extends Enum<E>> void populateComboBox(@NotNull JComboBox comboBox, @NotNull Class<E> enumClass) {
        if (comboBox == null) {
            TemplateWizardStep.$$$reportNull$$$0(4);
        }
        if (enumClass == null) {
            TemplateWizardStep.$$$reportNull$$$0(5);
        }
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            comboBox.addItem(new ApiComboBoxItem<String>(e.name(), e.toString(), 1, 1));
        }
    }

    protected static void populateComboBox(@NotNull JComboBox comboBox, @NotNull Object[] array) {
        if (comboBox == null) {
            TemplateWizardStep.$$$reportNull$$$0(6);
        }
        if (array == null) {
            TemplateWizardStep.$$$reportNull$$$0(7);
        }
        for (int i = 0; i < array.length; ++i) {
            comboBox.addItem(new ApiComboBoxItem<Integer>(i, array[i].toString(), 1, 1));
        }
    }

    protected void registerLabel(@NotNull String paramName, @NotNull JLabel label) {
        if (paramName == null) {
            TemplateWizardStep.$$$reportNull$$$0(8);
        }
        if (label == null) {
            TemplateWizardStep.$$$reportNull$$$0(9);
        }
        this.myParamFieldLabels.put(paramName, label);
    }

    protected void register(@NotNull String paramName, @NotNull JCheckBox checkBox) {
        if (paramName == null) {
            TemplateWizardStep.$$$reportNull$$$0(10);
        }
        if (checkBox == null) {
            TemplateWizardStep.$$$reportNull$$$0(11);
        }
        this.myParamFields.put((Object)paramName, (Object)checkBox);
        Object value = this.myTemplateState.get(paramName);
        if (value != null) {
            checkBox.setSelected(Boolean.parseBoolean(value.toString()));
        } else {
            this.myTemplateState.put(paramName, false);
        }
        checkBox.addFocusListener(this);
        checkBox.addActionListener(this);
    }

    protected void register(@NotNull String paramName, @NotNull JComboBox comboBox) {
        if (paramName == null) {
            TemplateWizardStep.$$$reportNull$$$0(12);
        }
        if (comboBox == null) {
            TemplateWizardStep.$$$reportNull$$$0(13);
        }
        this.myParamFields.put((Object)paramName, (Object)comboBox);
        Object value = this.myTemplateState.get(paramName);
        if (value != null) {
            for (int i = 0; i < comboBox.getItemCount(); ++i) {
                Object item = comboBox.getItemAt(i);
                if (!(item instanceof ApiComboBoxItem) || !((ApiComboBoxItem)item).getData().equals(value)) continue;
                comboBox.setSelectedIndex(i);
                break;
            }
        }
        comboBox.addFocusListener(this);
        comboBox.addActionListener(this);
    }

    protected void register(@NotNull String paramName, @NotNull JTextField textField) {
        String value;
        if (paramName == null) {
            TemplateWizardStep.$$$reportNull$$$0(14);
        }
        if (textField == null) {
            TemplateWizardStep.$$$reportNull$$$0(15);
        }
        if ((value = (String)this.myTemplateState.get(paramName)) != null) {
            textField.setText(value);
        } else {
            this.myTemplateState.put(paramName, "");
        }
        this.myParamFields.put((Object)paramName, (Object)textField);
        textField.addFocusListener(this);
        textField.getDocument().addDocumentListener(this);
    }

    protected void register(@NotNull String paramName, @NotNull JRadioButton radioButton, @Nullable Object value) {
        Object currentValue;
        if (paramName == null) {
            TemplateWizardStep.$$$reportNull$$$0(16);
        }
        if (radioButton == null) {
            TemplateWizardStep.$$$reportNull$$$0(17);
        }
        radioButton.setSelected((currentValue = this.myTemplateState.get(paramName)) != null && currentValue.equals(value));
        if (value != null) {
            this.myRadioButtonValues.put(radioButton, (Pair<String, Object>)Pair.of((Object)paramName, (Object)value));
        }
        radioButton.addFocusListener(this);
        radioButton.addActionListener(this);
    }

    protected void register(@NotNull String paramName, @NotNull JSlider paddingSlider) {
        Integer value;
        if (paramName == null) {
            TemplateWizardStep.$$$reportNull$$$0(18);
        }
        if (paddingSlider == null) {
            TemplateWizardStep.$$$reportNull$$$0(19);
        }
        if ((value = (Integer)this.myTemplateState.get(paramName)) != null) {
            paddingSlider.setValue(value);
        } else {
            this.myTemplateState.put(paramName, paddingSlider.getValue());
        }
        this.myParamFields.put((Object)paramName, (Object)paddingSlider);
        paddingSlider.addFocusListener(this);
        paddingSlider.addChangeListener(this);
    }

    protected void register(@NotNull String paramName, @NotNull JSpinner spinner) {
        Integer value;
        if (paramName == null) {
            TemplateWizardStep.$$$reportNull$$$0(20);
        }
        if (spinner == null) {
            TemplateWizardStep.$$$reportNull$$$0(21);
        }
        if ((value = (Integer)this.myTemplateState.get(paramName)) != null) {
            spinner.setValue(value);
        } else {
            this.myTemplateState.put(paramName, spinner.getValue());
        }
        this.myParamFields.put((Object)paramName, (Object)spinner);
        spinner.addFocusListener(this);
        spinner.addChangeListener(this);
    }

    protected void register(@NotNull String paramName, @NotNull TextFieldWithBrowseButton field) {
        String value;
        if (paramName == null) {
            TemplateWizardStep.$$$reportNull$$$0(22);
        }
        if (field == null) {
            TemplateWizardStep.$$$reportNull$$$0(23);
        }
        if ((value = (String)this.myTemplateState.get(paramName)) != null) {
            field.setText(value);
        } else {
            this.myTemplateState.put(paramName, field.getText());
        }
        this.myParamFields.put((Object)paramName, (Object)field);
        field.addFocusListener((FocusListener)this);
        field.getTextField().getDocument().addDocumentListener(this);
        field.getTextField().addFocusListener(this);
    }

    protected void register(@NotNull String paramName, @NotNull ColorPanel colorPanel) {
        Color value;
        if (paramName == null) {
            TemplateWizardStep.$$$reportNull$$$0(24);
        }
        if (colorPanel == null) {
            TemplateWizardStep.$$$reportNull$$$0(25);
        }
        if ((value = (Color)this.myTemplateState.get(paramName)) != null) {
            colorPanel.setSelectedColor(value);
        } else {
            this.myTemplateState.put(paramName, colorPanel.getSelectedColor());
        }
        this.myParamFields.put((Object)paramName, (Object)colorPanel);
        colorPanel.addFocusListener((FocusListener)this);
        colorPanel.addActionListener((ActionListener)this);
    }

    protected void update() {
        if (this.myIgnoreUpdates) {
            return;
        }
        this.myIgnoreUpdates = true;
        this.myIdsWithNewValues = new ConcurrentLinkedQueue<String>();
        this.updateParams();
        if (this.myFirstUpdate) {
            this.myIdsWithNewValues = new ConcurrentLinkedQueue<String>(this.myTemplateState.getParameters().keySet());
        }
        this.deriveValues();
        this.myIsValid = this.validate();
        if (this.myUpdateListener != null) {
            this.myUpdateListener.update();
        }
        this.myFirstUpdate = false;
        this.myIgnoreUpdates = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateDerivedValue(@NotNull String attrName, @NotNull JTextField textField, @NotNull Callable<String> valueDeriver) {
        if (attrName == null) {
            TemplateWizardStep.$$$reportNull$$$0(26);
        }
        if (textField == null) {
            TemplateWizardStep.$$$reportNull$$$0(27);
        }
        if (valueDeriver == null) {
            TemplateWizardStep.$$$reportNull$$$0(28);
        }
        boolean updated = false;
        try {
            String s;
            this.myIgnoreUpdates = true;
            if (!this.myTemplateState.myModified.contains(attrName) && (s = valueDeriver.call()) != null && !s.equals(this.myTemplateState.get(attrName))) {
                this.myTemplateState.put(attrName, s);
                textField.setText(s);
                this.myTemplateState.myModified.remove(attrName);
                updated = true;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.myIgnoreUpdates = false;
        }
        return updated;
    }

    public JComponent getComponent() {
        return null;
    }

    public Icon getIcon() {
        return this.mySidePanelIcon;
    }

    public void updateDataModel() {
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent actionEvent) {
        if (actionEvent == null) {
            TemplateWizardStep.$$$reportNull$$$0(29);
        }
        this.update();
    }

    @Override
    public void focusGained(@NotNull FocusEvent focusEvent) {
        if (focusEvent == null) {
            TemplateWizardStep.$$$reportNull$$$0(30);
        }
        this.update();
    }

    @Override
    public void focusLost(@NotNull FocusEvent focusEvent) {
        if (focusEvent == null) {
            TemplateWizardStep.$$$reportNull$$$0(31);
        }
        this.update();
    }

    @Override
    public void insertUpdate(@NotNull DocumentEvent documentEvent) {
        if (documentEvent == null) {
            TemplateWizardStep.$$$reportNull$$$0(32);
        }
        this.update();
    }

    @Override
    public void removeUpdate(@NotNull DocumentEvent documentEvent) {
        if (documentEvent == null) {
            TemplateWizardStep.$$$reportNull$$$0(33);
        }
        this.update();
    }

    @Override
    public void changedUpdate(@NotNull DocumentEvent documentEvent) {
        if (documentEvent == null) {
            TemplateWizardStep.$$$reportNull$$$0(34);
        }
        this.update();
    }

    @Override
    public void stateChanged(@NotNull ChangeEvent e) {
        if (e == null) {
            TemplateWizardStep.$$$reportNull$$$0(35);
        }
        this.update();
    }

    protected void hide(JComponent ... components) {
        for (JComponent component : components) {
            component.setVisible(false);
        }
    }

    protected void show(JComponent ... components) {
        for (JComponent component : components) {
            component.setVisible(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "radioButton";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paddingSlider";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spinner";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorPanel";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDeriver";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionEvent";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusEvent";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentEvent";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/wizard/template/TemplateWizardStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getHelpText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "populateComboBox";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "registerLabel";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDerivedValue";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "focusGained";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "focusLost";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "insertUpdate";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "removeUpdate";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "changedUpdate";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "stateChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface UpdateListener {
        public void update();
    }
}

