/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.formatter;

import com.intellij.application.options.XmlCodeStyleSettingsProvider;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.formatter.AndroidXmlCodeStyleSettings;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidCodeStyleNotificationProvider
extends EditorNotifications.Provider<MyPanel> {
    private static final Key<MyPanel> KEY = Key.create((String)"android.xml.code.style.notification");
    @NonNls
    private static final String ANDROID_XML_CODE_STYLE_NOTIFICATION_GROUP = "Android XML code style notification";
    private final Project myProject;
    private final EditorNotifications myNotifications;

    public AndroidCodeStyleNotificationProvider(Project project, EditorNotifications notifications) {
        this.myProject = project;
        this.myNotifications = notifications;
    }

    @NotNull
    public Key<MyPanel> getKey() {
        Key<MyPanel> key = KEY;
        if (key == null) {
            AndroidCodeStyleNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public MyPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        VirtualFile resDir;
        if (file == null) {
            AndroidCodeStyleNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            AndroidCodeStyleNotificationProvider.$$$reportNull$$$0(2);
        }
        if (file.getFileType() != XmlFileType.INSTANCE || !(fileEditor instanceof TextEditor)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject);
        if (module == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        VirtualFile parent = file.getParent();
        VirtualFile virtualFile = resDir = parent != null ? parent.getParent() : null;
        if (resDir == null || !facet.getLocalResourceManager().isResourceDir(resDir)) {
            return null;
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)this.myProject);
        AndroidXmlCodeStyleSettings androidSettings = AndroidXmlCodeStyleSettings.getInstance(settings);
        if (androidSettings.USE_CUSTOM_SETTINGS) {
            return null;
        }
        if (NotificationsConfigurationImpl.getSettings((String)ANDROID_XML_CODE_STYLE_NOTIFICATION_GROUP).getDisplayType() == NotificationDisplayType.NONE) {
            return null;
        }
        NotificationsConfiguration.getNotificationsConfiguration().register(ANDROID_XML_CODE_STYLE_NOTIFICATION_GROUP, NotificationDisplayType.BALLOON, false);
        return new MyPanel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/formatter/AndroidCodeStyleNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/formatter/AndroidCodeStyleNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MyPanel
    extends EditorNotificationPanel {
        MyPanel() {
            this.setText("You can format your XML resources in the 'standard' Android way. Choose 'Set from... | Android' in the XML code style settings.");
            this.createActionLabel("Open code style settings", new Runnable(){

                @Override
                public void run() {
                    ShowSettingsUtilImpl.showSettingsDialog((Project)AndroidCodeStyleNotificationProvider.this.myProject, (String)("preferences.sourceCode." + XmlCodeStyleSettingsProvider.CONFIGURABLE_DISPLAY_NAME), (String)"");
                    AndroidCodeStyleNotificationProvider.this.myNotifications.updateAllNotifications();
                }
            });
            this.createActionLabel("Disable notification", new Runnable(){

                @Override
                public void run() {
                    NotificationsConfiguration.getNotificationsConfiguration().changeSettings(AndroidCodeStyleNotificationProvider.ANDROID_XML_CODE_STYLE_NOTIFICATION_GROUP, NotificationDisplayType.NONE, false, false);
                    AndroidCodeStyleNotificationProvider.this.myNotifications.updateAllNotifications();
                }
            });
        }
    }
}

